/*  PawfalSlider
 *  Copyleft (C) 2002 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include "Fl_PawfalSlider.H"
#include <FL/fl_draw.H>

void Fl_PawfalSlider::draw()
{	
	int Size=15;
	int Offset=Size/2; 

	fl_push_clip(x(), y(), w(), h()); 

	fl_color(FL_GRAY);
	fl_rectf(x(), y(), w(), h());	

	fl_color(FL_BLACK);
	fl_rectf(x()+w()/2-2, y()+Offset, 4, h()-Size);	

	double val;
  
	if (minimum() == maximum())
	{
		val = 0.5;
	}
	else 
	{
    	val = (value()-minimum())/(maximum()-minimum());
    	if (val > 1.0) val = 1.0;
    	else if (val < 0.0) val = 0.0;
  	}
	
	int Pos=(int)(val*(h()-Size-1))+Offset;	
	unsigned char rr=0,gg=0,bb=0;
		
	int col = selection_color();
	Fl::get_color((Fl_Color)col,rr,gg,bb);
	
	for (int n=1; n<4; n++)
	{
		shadow((n-1)*40,rr,gg,bb);
		fl_pie(((x()+w()/2)-Offset)+n-1, (y()+Pos-Offset)+n-1, Size/n, Size/n, 0, 360);	
	}
	
	fl_color(FL_BLACK);
	fl_arc((x()+w()/2)-Offset, y()+Pos-Offset, Size+1, Size+1, 0, 360);	
	
	fl_pop_clip();
}

void Fl_PawfalSlider::shadow(const int offs,const uchar r,uchar g,uchar b) {
  int rr,gg,bb;

	rr = r + offs; 
	rr = rr > 255 ? 255:rr;
	rr = rr < 0 ? 0:rr;
	gg = g + offs; 
	gg = gg > 255 ? 255:gg;
	gg = gg < 0 ? 0:gg;
	bb = b + offs; 
	bb = bb > 255 ? 255:bb;
	bb = bb < 0 ? 0:bb;
	fl_color((uchar)rr,(uchar)gg,(uchar)bb);
}
