/*  SpiralSynth
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include "ScopeGUI.h"
#include "../SpiralSound/Output.h"
#include "../SpiralSound/SpiralInfo.h"

#include <FL/fl_draw.H>

ScopeWidget::ScopeWidget(int x,int y,int w,int h,const char *l=0) :
Fl_Widget(x,y,w,h,l),
m_Data(NULL)
{
}


void ScopeWidget::draw()    	
{	
	int ho=h()/2;
	
	fl_color(SpiralInfo::GUIBG_COLOUR);
	fl_rectf(x(), y(), w(), h());
	
	fl_color(SpiralInfo::GUI_COLOUR+3);
	for(int n=0; n<SpiralInfo::BUFSIZE-1 && n<w(); n++)
	{
		if (m_Data)	fl_line(x()+n,   y()+ho+m_Data[n]/400.0f,
							x()+n+1, y()+ho+m_Data[n+1]/400.0f);
	}	
}

ScopeGUI::ScopeGUI() : m_Bypass(false)
{
}

void ScopeGUI::Display(short *data)
{
	m_Scope->m_Data=data;
	if (!m_Bypass) m_Scope->redraw();
}
		
void ScopeGUI::CreateGUI(int xoff=0, int yoff=0, char *name)
{
	 Fl_Group* o = GUIScopeGroup = new Fl_Group(xoff, yoff, 220, 110, name);
      o->type(1);
	  o->box(FL_UP_BOX);
      o->labeltype(FL_ENGRAVED_LABEL);
      o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
	  o->user_data((void*)(this));
       	  
	  m_Scope = new ScopeWidget(xoff+5, yoff+20, 205, 85, "Scope");

	  Bypass = new Fl_Button(175+xoff, 3+yoff, 40, 16, "Bypass");
      Bypass->labelsize(10);
      Bypass->type(1);		 
	  Bypass->callback((Fl_Callback*)cb_Bypass);

      o->end();
}

void ScopeGUI::cb_Bypass_i(Fl_Button* o, void* v)
{m_Bypass=o->value();}
void ScopeGUI::cb_Bypass(Fl_Button* o, void* v)
{((ScopeGUI*)(o->parent()->user_data()))->cb_Bypass_i(o,v);}
