/*  SpiralSynth
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Pack.H>
#include <FL/Fl_Check_Button.H>
#include "Widgets/Fl_Knob.H"
#include "Widgets/Fl_PawfalSlider.H"
#include <FL/Fl_Button.H>
#include <FL/Fl_Pixmap.H>

#include "GUIBase.h"
#include "../SpiralSound/Oscillator.h"

#ifndef OSCGUI
#define OSCGUI

class OscillatorGUI : public GUIBase
{
public:
	OscillatorGUI(Oscillator *o);
	
	virtual void CreateGUI(int xoff=0, int yoff=0, char *name="");	
	virtual void UpdateValues();
	
	void MidiPitchBend(int amount);
		
	Oscillator *m_osc;	
	
protected:

	Fl_Group 		*GUIOscGroup;
	Fl_Check_Button *ShapeSquare;
	Fl_Pixmap 		 pixmap_Square;
	Fl_Check_Button *ShapeNoise;
	Fl_Pixmap 		 pixmap_Noise;
	Fl_Check_Button *ShapeSaw;
	Fl_Pixmap 		 pixmap_Saw;
	Fl_Knob 		*Freq;
	Fl_Knob 		*ModAmount;
	Fl_Knob 		*FineTune;
	Fl_PawfalSlider 		*PulseWidth;
	Fl_PawfalSlider 		*SHLen;
	Fl_PawfalSlider 		*Portmento;
	
	//// Callbacks ////
	
	inline void cb_Freq_i(Fl_Knob* o, void* v);
    static void cb_Freq(Fl_Knob*, void*);
	inline void cb_FineTune_i(Fl_Knob* o, void* v);
	static void cb_FineTune(Fl_Knob* o, void* v);
	inline void cb_ModAmount_i(Fl_Knob* o, void* v);
	static void cb_ModAmount(Fl_Knob* o, void* v);
	inline void cb_PulseWidth_i(Fl_PawfalSlider* o, void* v);
	static void cb_PulseWidth(Fl_PawfalSlider* o, void* v); 
	inline void cb_Portmento_i(Fl_PawfalSlider* o, void* v);
	static void cb_Portmento(Fl_PawfalSlider* o, void* v); 
	inline void cb_SHLen_i(Fl_PawfalSlider* o, void* v);
	static void cb_SHLen(Fl_PawfalSlider* o, void* v); 
	inline void cb_Square_i(Fl_Check_Button* o, void* v);
    static void cb_Square(Fl_Check_Button*, void*);
	inline void cb_Saw_i(Fl_Check_Button* o, void* v);
    static void cb_Saw(Fl_Check_Button*, void*);
	inline void cb_Noise_i(Fl_Check_Button* o, void* v);
	static void cb_Noise(Fl_Check_Button* o, void* v); 
  
};

class LFOGUI : public OscillatorGUI
{
public:
	LFOGUI(Oscillator *o);
	
	virtual void CreateGUI(int xoff=0, int yoff=0, char *name="");
	virtual void UpdateValues();

protected:

	Fl_PawfalSlider 		*Volume;

	//// Callbacks ////
	
	inline void cb_FineTune_i(Fl_Knob* o, void* v);
	static void cb_FineTune(Fl_Knob* o, void* v);  
	inline void cb_Volume_i(Fl_PawfalSlider* o, void* v);
    static void cb_Volume(Fl_PawfalSlider*, void*);	
};

#endif
