/*  SpiralSynth
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Group.H>
#include "Widgets/Fl_Knob.H"
#include <FL/Fl_Button.H>
#include "Widgets/Fl_PawfalSlider.H"

#include "GUIBase.h"
#include "../SpiralSound/Filter.h"

#ifndef FILTERGUI
#define FILTERGUI

class FilterGUI : public GUIBase
{
public:
	FilterGUI(Filter *o);
	
	virtual void CreateGUI(int xoff, int yoff, char *name);	
	virtual void UpdateValues();
	void MidiCutoff(int amount);
	
	Filter *m_filter;	
	
private:

	Fl_Group 		*GUIFilterGroup;
	Fl_PawfalSlider 		*Cutoff;
	Fl_Knob 		*Resonance;
	Fl_Button       *RevCutoff;
	Fl_Button		*RevResonance;
	
	//// Callbacks ////
	
	inline void cb_Cutoff_i(Fl_PawfalSlider* o, void* v);
    static void cb_Cutoff(Fl_PawfalSlider*, void*);
	inline void cb_Resonance_i(Fl_Knob* o, void* v);
	static void cb_Resonance(Fl_Knob* o, void* v); 
	inline void cb_RevCutoff_i(Fl_Button* o, void* v);
    static void cb_RevCutoff(Fl_Button*, void*);
	inline void cb_RevResonance_i(Fl_Button* o, void* v);
	static void cb_RevResonance(Fl_Button* o, void* v); 
};

#endif
