/*  SpiralSynth
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Group.H>
#include "Widgets/Fl_PawfalSlider.H"

#include "GUIBase.h"
#include "../SpiralSound/Envelope.h"

#ifndef ENVGUI
#define ENVGUI

class EnvelopeGUI : public GUIBase
{
public:
	EnvelopeGUI(Envelope *o);
	
	virtual void CreateGUI(int xoff, int yoff, char *name);
	virtual void UpdateValues();

	Envelope *m_env;	
	
private:

	Fl_Group 		*GUIEnvGroup;
	Fl_PawfalSlider 		*Attack;
	Fl_PawfalSlider 		*Decay;
	Fl_PawfalSlider 		*Sustain;
	Fl_PawfalSlider 		*Release;
	Fl_PawfalSlider 		*Volume;
	
	//// Callbacks ////
	
	inline void cb_Attack_i(Fl_PawfalSlider* o, void* v);
    static void cb_Attack(Fl_PawfalSlider*, void*);
	inline void cb_Decay_i(Fl_PawfalSlider* o, void* v);
	static void cb_Decay(Fl_PawfalSlider* o, void* v); 
	inline void cb_Sustain_i(Fl_PawfalSlider* o, void* v);
	static void cb_Sustain(Fl_PawfalSlider* o, void* v); 
	inline void cb_Release_i(Fl_PawfalSlider* o, void* v);
	static void cb_Release(Fl_PawfalSlider* o, void* v); 
	inline void cb_Volume_i(Fl_PawfalSlider* o, void* v);
	static void cb_Volume(Fl_PawfalSlider* o, void* v); 
};

#endif
