set(FIND_SSVENTITYSYSTEM_LIB_PATHS
  "${PROJECT_SOURCE_DIR}/../SSVEntitySystem/"
  "${PROJECT_SOURCE_DIR}/extlibs/SSVEntitySystem/"
  ${SSVENTITYSYSTEM_ROOT}
  $ENV{SSVENTITYSYSTEM_ROOT}
  ~/Library/Frameworks
  /Library/Frameworks
  /usr/local
  /usr/
  /sw/
  /opt/local
  /opt/csw
  /opt
)

FIND_PATH(SSVENTITYSYSTEM_INCLUDE_DIR
  NAMES SSVEntitySystem/SSVEntitySystem.h
  PATH_SUFFIXES include/
  PATHS ${FIND_SSVENTITYSYSTEM_LIB_PATHS}
)
MESSAGE("\nFound SSVEntitySystem include at: ${SSVENTITYSYSTEM_INCLUDE_DIR}.\n")

FIND_LIBRARY(SSVENTITYSYSTEM_LIBRARY_RELEASE
  NAMES SSVEntitySystem SSVEntitySystem-s
  PATH_SUFFIXES lib/ lib64/
  PATHS ${FIND_SSVENTITYSYSTEM_LIB_PATHS}
)
MESSAGE("\nFound SSVEntitySystem release library at: ${SSVENTITYSYSTEM_LIBRARY_RELEASE}.\n")

FIND_LIBRARY(SSVENTITYSYSTEM_LIBRARY_DEBUG
  NAMES SSVEntitySystem-d SSVEntitySystem-s-d
  PATH_SUFFIXES lib/ lib64/
  PATHS ${FIND_SSVENTITYSYSTEM_LIB_PATHS}
)
MESSAGE("\nFound SSVEntitySystem debug library at: ${SSVENTITYSYSTEM_LIBRARY_DEBUG}.\n")

if(SSVENTITYSYSTEM_LIBRARY_DEBUG OR SSVENTITYSYSTEM_LIBRARY_RELEASE)
  set(SSVENTITYSYSTEM_FOUND TRUE)
  if(SSVENTITYSYSTEM_LIBRARY_DEBUG AND SSVENTITYSYSTEM_LIBRARY_RELEASE)
    SET(SSVENTITYSYSTEM_LIBRARY debug ${SSVENTITYSYSTEM_LIBRARY_DEBUG} optimized ${SSVENTITYSYSTEM_LIBRARY_RELEASE})
  endif()
  if(SSVENTITYSYSTEM_LIBRARY_DEBUG AND NOT SSVENTITYSYSTEM_LIBRARY_RELEASE)
    set(SSVENTITYSYSTEM_LIBRARY_RELEASE ${SSVENTITYSYSTEM_LIBRARY_DEBUG})
    set(SSVENTITYSYSTEM_LIBRARY         ${SSVENTITYSYSTEM_LIBRARY_DEBUG})
  endif()
  if(SSVENTITYSYSTEM_LIBRARY_RELEASE AND NOT SSVENTITYSYSTEM_LIBRARY_DEBUG)
    set(SSVENTITYSYSTEM_LIBRARY_DEBUG ${SSVENTITYSYSTEM_LIBRARY_RELEASE})
    set(SSVENTITYSYSTEM_LIBRARY       ${SSVENTITYSYSTEM_LIBRARY_RELEASE})
  endif()
else()
  set(SSVENTITYSYSTEM_FOUND FALSE)
  set(SSVENTITYSYSTEM_LIBRARY "")
endif()

IF(SSVENTITYSYSTEM_FOUND)
  MESSAGE(STATUS "\nFound SSVENTITYSYSTEM: ${SSVENTITYSYSTEM_LIBRARY}\n")
ELSE()
  IF(SSVENTITYSYSTEM_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "\nCould not find SSVEntitySystem library\n")
  ENDIF(SSVENTITYSYSTEM_FIND_REQUIRED)
  set(SSVENTITYSYSTEM_ROOT "" CACHE PATH "SSVEntitySystem top-level directory")
  message("\n-> SSVEntitySystem directory not found. Set SSVENTITYSYSTEM_ROOT to SSVEntitySystem' top-level path (containing both \"include\" and \"lib\" directories).")
ENDIF()

MARK_AS_ADVANCED(
  SSVENTITYSYSTEM_LIBRARY_DEBUG
  SSVENTITYSYSTEM_LIBRARY_RELEASE
  SSVENTITYSYSTEM_LIBRARY
  SSVENTITYSYSTEM_INCLUDE_DIR
)
