% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster.R
\name{osm_raster}
\alias{osm_raster}
\title{Load an Open Street Map image}
\usage{
osm_raster(
  bbox,
  spec,
  zoom = osm_zoom_num_tiles(6),
  cache_spec = NULL,
  quiet = NA
)
}
\arguments{
\item{bbox}{A [wk::rct()] or object with a [wk::wk_bbox()] method.}

\item{spec}{An [osm_url_spec()]}

\item{zoom}{A zoom level or an auto zoom specifier like
[osm_zoom_num_tiles()].}

\item{cache_spec}{An optional [osm_url_spec()] or character vector to be
used as the cache.}

\item{quiet}{Use `TRUE` for fewer messages or `FALSE` for more messages.}
}
\value{
A [wk::grd_rct()] whose data member is a nativeRaster.
}
\description{
Load an Open Street Map image
}
\examples{
bounds <- wk::rct(
  -7476083, 5349058,
  -6594103, 6243203,
  crs = osm_crs_native()
)

(grd <- osm_raster(bounds, osm_url_spec()))
plot(grd)

}
