% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalebar.R
\name{scalebarparams}
\alias{scalebarparams}
\title{Get Scale Bar Parameters}
\usage{
scalebarparams(
  plotunit = NULL,
  plotepsg = NULL,
  widthhint = 0.25,
  unitcategory = "metric",
  extents = graphics::par("usr")
)
}
\arguments{
\item{plotunit}{The unit which the current plot is plotted in, one of \code{cm},
\code{m}, \code{km}, \code{in}, \code{ft}, \code{mi}. or \code{latlon}. This
parameter is optional if \code{plotepsg} is passed.}

\item{plotepsg}{The projection of the current plot. If extents are valid lat/lons,
the projection is assumed to be lat/lon (EPSG:4326), or Spherical Mercator otherwise
(EPSG:3857). This is done to work seamlessly with OpenStreetMap packages.}

\item{widthhint}{The fraction of the plottable width which the scale bar should
(mostly) occupy.}

\item{unitcategory}{One of "metric" or "imperial"}

\item{extents}{The plot extents}
}
\value{
a \code{list} of parameters: \code{$widthu} (width of the scalebar in human
readable units); \code{$unit} (the human readable unit); \code{$majordivu} (the size
of the divisions in human readable units); \code{$majordivs} (the number of divisions);
\code{$widthplotunit} (width of the scalebar in plotting units); \code{$majordivplotunit}
(the width of divisions in plotting units); \code{$labeltext} (label text); and \code{extents}
the user extents (\code{par('usr')}) that were used to calculate the parameters.
}
\description{
Get default scale bar parameters based on the current plot (i.e. \code{par("usr")}).
The algorithm attempts to detect the best equally divisable distance to use for the
scale bar, and returns a \code{list} object with attributes that allow any type of
scale bar to be drawn. The only way to manipulate the values chosen by the algorithm
is to change the \code{widthhint} argument. For generic XY plots, pass \code{plotunit}.
}
\examples{
plot(1:5, 1:5, asp=1)
scalebarparams(plotunit="m")

}
\seealso{
\link{addscalebar}
}
