% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_workbook.R
\name{buildWorkbook}
\alias{buildWorkbook}
\title{Build Workbook}
\usage{
buildWorkbook(x, asTable = FALSE, ...)
}
\arguments{
\item{x}{A data.frame or a (named) list of objects that can be handled by
\code{\link{writeData}} or \code{\link{writeDataTable}} to write to file}

\item{asTable}{If \code{TRUE} will use \code{\link{writeDataTable}} rather
than \code{\link{writeData}} to write \code{x} to the file (default: 
\code{FALSE})}

\item{...}{Additional arguments passed to \code{\link{writeData}}, 
\code{\link{writeDataTable}}, \code{\link{setColWidths}}}
}
\value{
A Workbook object
}
\description{
Build a workbook from a data.frame or named list
}
\details{
This function can be used as shortcut to create a workbook object from a 
  data.frame or named list.  If names are available in the list they will be
  used as the worksheet names.  The parameters in \code{...} are collected
  and passed to \code{\link{writeData}} or \code{\link{writeDataTable}} to
  initially create the Workbook objects then appropriate parameters are 
  passed to \code{\link{setColWidths}}.
}
\examples{
x <- data.frame(a = 1, b = 2)
wb <- buildWorkbook(x)

y <- list(a = x, b = x, c = x)
buildWorkbook(y, asTable = TRUE)
buildWorkbook(y, asTable = TRUE, tableStyle = "TableStyleLight8")

}
\seealso{
\code{\link{write.xlsx}}
}
\author{
Jordan Mark Barbone
}
