include(CheckCCompilerFlag)

macro(ADD_C_COMPILER_FLAG)
	if (NOT ${ARGC})
		message(SEND_ERROR "No arguments given to ADD_C_COMPILER_FLAG: ${ARGC}")
	else ()
		foreach(_flag ${ARGV})
			list(FIND CMAKE_C_FLAGS "${_flag}" _found)
			if (_found EQUAL -1)
				set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS${_build}} ${_flag}")
			endif()
			unset(_found)
		endforeach()
	endif ()
endmacro()

macro(ADD_SUPPORTED_C_COMPILER_FLAG VARNAME FLAG)
	if (NOT ${ARGC} EQUAL 2)
		message(SEND_ERROR "ADD_SUPPORTED_C_COMPILER_FLAG needs exactly 2 arguments")
	else ()
		CHECK_C_COMPILER_FLAG("${FLAG}" "${VARNAME}")

		if (${${VARNAME}})
			ADD_C_COMPILER_FLAG("${FLAG}")
		endif ()
	endif ()
endmacro()
