/*
    socket.cpp
    OpenAG, libOpenAG, OpenAG X
 
    Created by Eric Seidel on Wed Nov 14 2001.
 
    Copyright (c) 2001-2002 Eric Seidel. All rights reserved.
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    ************************************************************
    Parts of this file are based directly from code written by the late great 
    W. Richard Stevens -- Unix network programming god.
*/

#include "common.h"

#include <netinet/in.h> /* for sockadd_in */
#include <netdb.h>	/* for gethostbyname() */
#include <errno.h>	/* for errno */

#include <sys/wait.h>
#include <arpa/inet.h>

#include "socket.h"
#include "error.h"

int call_socket(char *hostname, unsigned short portnum)
{ 
    #if AGDEBUGLEVEL > 3
    printf("\nAttempting Connection to %s port: %i\n", hostname, portnum);
    #endif
    struct sockaddr_in sa;
    struct hostent     *hp;
    int s;
    
    if ((hp= gethostbyname(hostname)) == NULL) 
    {	/* do we know the host's */
        errno= ECONNREFUSED;                       /* address? */
        return(-1);                                /* no */
    }
    
    memset(&sa,0,sizeof(sa));
    memcpy((char *)&sa.sin_addr,hp->h_addr,hp->h_length);     /* set address */
    sa.sin_family= hp->h_addrtype;
    sa.sin_port= htons((u_short)portnum);
    
    if ((s= socket(hp->h_addrtype,SOCK_STREAM,0)) < 0)     /* get socket */
        return(-1);
    if (connect(s,(struct sockaddr *)&sa,sizeof sa) < 0)
    { /* connect */
        close(s);
        return(-1);
    }
    return(s);
}

int read_data(int s,     /* connected socket */
              char *buf, /* pointer to the buffer */
              int n      /* number of characters (bytes) we want */
             )
{
    int bcount; /* counts bytes read */
    int br;     /* bytes read this pass */
    
    bcount= 0;
    br= 0;
    while (bcount < n)
    {             /* loop until full buffer */
        if ((br = read(s,buf,n-bcount)) > 0)
        {
            bcount += br;                /* increment byte counter */
            buf += br;                   /* move buffer ptr for next read */
            //printf("read through byte %i\n", bcount);
        }
        else if (br < 0)               /* signal an error to the caller */
        {      
            printf("failed, reading byte: %i\n", bcount);
            return(-1);
        }
        else if (br == 0)
        {
            printf("got EOF when asked to read.\n");
            return (-1);
        }
    }
    return(bcount);
}

int write_data(int s,     /* connected socket */
              char *buf, /* pointer to the buffer */
              int n      /* number of characters (bytes) we want */
             )
{
    int bcount; /* counts bytes read */
    int br;     /* bytes written this pass */
    
    bcount= 0;
    br= 0;
    while (bcount < n)
    {             /* loop until empty buffer */
        if ((br= write(s,buf,n-bcount)) > 0)
        {
            bcount += br;                /* increment byte counter */
            buf += br;                   /* move buffer ptr for next write */
            //printf("written through byte %i\n", bcount);
        }
        else if (br < 0)               /* signal an error to the caller */
        {      
            printf("failed, writing byte: %i\n", bcount);
            return(-1);
        }
    }
    return(bcount);
}

/***************** LEGACY/ CONVIENCE FUNCTIONS ***********/

int read_int(int s)
{
    return *(int *)read_string(s,4);
}
short read_short(int s)
{
    return *(short *)read_string(s,2);
}

short read_byte(int s)
{
    return *(short *)read_string(s,1);
}

char* read_string(int s)
{
    return read_string( s, read_short(s) ); //reads the short first, to know how long the string is.
}

char* read_string(int s, short l)
{
    int count = 0;
    
    /* MEMORY LEEK **** FIX , where?*/
    char* MyBuff = new char[l];
    //bzero(MyBuff,IPLength); //necessary?
    
    //printf("reading string of length: %i\n", l);

    count = read_data(s,(char *)MyBuff,l);
    if (count == -1)
	err_print("read error\n");
        
    //TotalRead += count;
    ////printf("t: %i, c: %i, D: %s\n",TotalRead,count,MyBuff);
    return MyBuff;
}


