/*
    AGInit.h
    OpenAG, libOpenAG, OpenAG X
    
    Created by Eric Seidel on Fri Dec 21 2001.
    
    Copyright (c) 2001-2002 Eric Seidel. All rights reserved.
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _AGINIT_H_
#define _AGINIT_H_

#include "AGMain.h"


#define NORMAL_REDIRECTION_DNS		"garlic.audiogalaxy.com"
#define NORMAL_REDIRECTION_STATIC_IP	"64.245.59.169"

#define GOLD_REDIRECTION_DNS		"gold.audiogalaxy.com"
#define GOLD_REDIRECTION_STATIC_IP	"64.245.59.147"

#define NORMAL_WEB_DNS			"www.audiogalaxy.com"
#define NORMAL_WEB_STATIC_IP		"64.245.58.28"

#define GOLD_WEB_DNS			"fast.audiogalaxy.com"
#define GOLD_WEB_STATIC_IP		"64.245.59.146"


#ifdef __APPLE__
#define DEFAULT_DOWNLOADS_DIRECTORY	"~/Documents/iTunes/iTunes Music"
#define DATABASES_DIRECTORY		"~/Library/Application Support/OpenAG"
#define DEFAULT_TEMP_DIRECTORY		"~/Library/Caches/OpenAG"
#else
#define DEFAULT_DOWNLOADS_DIRECTORY	"~/music"
#define DATABASES_DIRECTORY		"~/.OpenAG"
#define DEFAULT_TEMP_DIRECTORY		"~/.OpenAG/temp"
#endif


/* do I really need the \0's? */
#define REDIRECTION_SERVER_HARDCODED_ADDRESSES			{"squash.audiogalaxy.com\0","squash-2.audiogalaxy.com\0"}
#define REDIRECTION_SERVER_HARDCODED_ADDRESSES_STATIC_IPS 	{"64.245.58.81","64.245.59.169"}
#define REDIRECTION_SERVER_HARDCODED_NUMBER			2
#define REDIRECTION_SERVER_PORT					21


/* CLIENT INITIALIZATION */
void clientInit(server_status &STATS);

int getMeAnInfoServer(char* redirectionDNS);  // NOT AGString
void resetRConnection(redirectionConnection &c, fd_set &rs);
int getRedirectionServers(redirectionConnection* &s, char* redirectionDNS);	//NOT AGString

/* READING FROM FILES/DATABASES */
void setBaseDirectory(server_status &STATS, const char* basePath);
void readPrefs(server_status &STATS);
void readResumes(server_status &STATS);
void readShares(server_status &STATS);
int globError(const char* epath, int errnum);

void sendLoginMessage(server_status &STATS);
void sendLogoffMessage(server_status &STATS);
void sendNewUserMessage(server_status &STATS); // just preliminary!

#endif


