/*
    error.cpp
    OpenAG
     
    Copyright (c) 2001-2002 Eric Seidel. All rights reserved.
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    ************************************************************
    Parts of this file are based directly from code written by the late great 
    W. Richard Stevens -- Unix network programming god.
*/

#include "common.h"

#include	<stdarg.h>		/* ANSI C header file */
#include	<errno.h>		/* for errno */
#include	"error.h"

#define err_print_va(a, b) vprintf(a,b); printf("\nThe error generated was %d\n", errno); printf("That means: %s\n", strerror(errno));


/* checks the debug level and prints the message  */

void print_debug(int level, const char *fmt, ...)
{
	if (level < AGDEBUGLEVEL) return;
        
        va_list		ap;
	va_start(ap, fmt);
	vprintf(fmt,ap);
	va_end(ap);
}

/* prints the error and exits  */

void err_exit(const char *fmt, ...)
{
	va_list		ap;

	va_start(ap, fmt);
	err_print_va(fmt,ap);
	va_end(ap);
	exit(1);
}

/* prints the error, core dumps, and exits  */

void err_dump(const char *fmt, ...)
{
	va_list		ap;

	va_start(ap, fmt);
	err_print_va(fmt,ap);
	va_end(ap);
        abort();
	exit(1);
}

/* simply prints the error and returns  */

void err_print(const char *fmt, ...)
{
	va_list		ap;
	va_start(ap, fmt);
        err_print_va(fmt, ap);
	va_end(ap);
        
}

