/*
 *  XScrabble - X version of the popular board game, for 1 to 4 players.
 *
 * This software comes with NO warranty whatsoever. I therefore take no
 * responsibility for any damages, losses or problems caused through use
 * or misuse of this program.
 *
 * I hereby grant permission for this program to be freely copied and
 * distributed by any means, provided no charge is made for it.
 *
 * Matt Chapman, matt@belgarath.demon.co.uk
 *    Oct 1994.
 */

/* xscrab.h - includes, defines and structures for X interface */


#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>

#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>

#include <X11/Xatom.h>
#include <X11/Shell.h>
#include <X11/xpm.h>

#include "CircPerc.h"
#include <X11/Xc/BarGraf.h>

#include <stdio.h>

/* to make sure X resources are found */
#define VERSION 100

#define SETBG(x) XtVaTypedArg,XtNbackground,XtRString,x,strlen((char *)x)+1
#define SETFG(x) XtVaTypedArg,XtNforeground,XtRString,x,strlen((char *)x)+1
#define TILECOL "lightgoldenrodyellow"
#define BRIGHTCOL "white"
#define BARCOL "forestgreen"
#define LONGBAR 13

#define NUM_TYPES 8

#define MENU_ITEMS 7
enum { KEY, LETTVAL, HISCORES, BESTGOES, MESSAGE, ABOUT, QUIT };

#define MESS_DELAY 4000

/* messages */
#define YOUR_GO			"Your go %s."
#define START_GO_ALL	"%s's go."
#define GO_ACCEPTED 	"Go accepted. You score %d point%s."
#define GO_ALL			"%s scores %d point%s."
#define WOULD_SCORE 	"That go would score %d point%s."
#define TILES_LEFT		"Tiles Left: "
#define SPAM			"*** SPAM! ***"
#define LOST_GO			"Word is not valid - you lose your go."
#define LOST_GO_ALL		"%s makes an invalid word."
#define CANNOT_CHANGE 	"Not enough tiles left to change that many."
#define PLAYER_CHANGE 	"%s changes tiles."
#define USE_CENTRE		"You must use the centre square."
#define ARRANGEMENT		"Incorrect arrangement of tiles."
#define BLANK			" "
#define FIXED_TILE		"That tile can't be moved."
#define OCCUPIED		"Square is occupied."
#define PASS			"%s passes."
#define NOT_ON_BOARD	"Cannot access board - it is not your go."
#define GAME_OVER_LOSE	"Game Over. You lose %d point%s."
#define GAME_OVER_WIN	"Game Over. You get %d bonus point%s."
#define WINNER			"%s is the winner!"
#define DRAWN2			"%s and %s draw!"
#define DRAWN3			"%s, %s and %s draw!"
#define DRAW_ALL		"It is a complete draw!"
#define COMP_SCORE		"%s scores %d point%s."
#define OUT_TIME_ALL	"%s runs out of time."
#define OUT_TIME		"You are out of time."
#define TO_END			"Select quit to end."
#define MESS_PING		"%s sends message. See Extras Menu."
