;;##########################################################################
;; systmobj.lsp
;; Copyright (c) 1991-98 by Forrest W. Young
;; defproto, isnew and slot accessors for ViSta system object
;;##########################################################################

(defproto vista-system-object-proto 
  '(var-window-object obs-window-object mat-window-object 
                      cells-window-object help-window-object expert
                      guidemap guidemap-name guidemap-number
                      need-new-guidemap guidemap-slots long-menus
                      button-down delay-update delay-return instant-return
                      vis-window-status help-window-status full-screen
                      guide-window-location guide-window-size show-load-vista
                      show-guidemap hide-workmap show-toolbar show-varobs
                      show-listener show-open-data show-long-menus
                      report-window-id-list vars-showing obs-showing
                      redraw-active postponed-redraw-list menu-states
                      background-color color-values-list configure
                      applet-name show-help show-first-help directory-list
                      show-menu-help-again help-showing show-welcome
                      internal-map applets desktop-sizes help-layout-sizeloc
                      workmap-layout-sizeloc save-desktop font))

(defmeth vista-system-object-proto :isnew ()
  (let ((var-window (name-list '("dummy")
                               :show nil
                               :size var-obs-window-size
                               :location var-window-location 
                               :title "Vars"))
        (cancel-var-selection
              (send menu-item-proto :new "Cancel Selection" :enabled nil
                    :action #'(lambda ()
                                (send *var-window* :unselect-all-points)
                                (send (fourth (send (send *var-window* :menu) 
                                                    :items)) :enabled nil))))
        (obs-window (name-list '("dummy")
                               :show nil
                               :size var-obs-window-size
                               :location obs-window-location 
                               :title "Obs"))
        (cancel-obs-selection
              (send menu-item-proto :new "Cancel Selection" :enabled nil
                    :action #'(lambda ()
                                (send *obs-window* :unselect-all-points)
                                (send (fourth (send (send *obs-window* :menu) 
                                                    :items)) :enabled nil))))
        )
    (when *full-screen* (send self :full-screen t))
    (send self :expert nil)
    (send self :guidemap nil)
    (send self :guidemap-name "load-dat")
    (send self :vis-window-status nil)
    (send self :help-window-object nil)
    (send self :help-window-status nil)
    (send self :need-new-guidemap t)
    (send var-window :clear-points)
    (send var-window :new-menu "Var"
          :items '(ERASE-SELECTION FOCUS-ON-SELECTION SHOW-ALL))
    (send (send var-window :menu) :append-items cancel-var-selection)
    (defmeth var-window :close () 
      (send self :hide-window)
      (send *vista* :vars-showing nil))
    (send self :var-window-object var-window)
    (defmeth var-window :unselect-all-points ()
      (call-next-method)
      (send current-data :var-states
            (send self :point-state (iseq (send self :num-points)))))
    (defmeth var-window :do-select-click (x y m1 m2)
      (when (> (send self :num-points) 0)
            (call-next-method x y m1 m2)
            (send (fourth (send (send self :menu) :items)) :enabled t)
            (send current-data :var-states
                  (send self :point-state (iseq (send self :num-points))))))
    (defmeth var-window :erase-selection ()
      (call-next-method)
      (send (fourth (send (send self :menu) :items)) :enabled nil)
      (send current-data :var-states
            (send self :point-state (iseq (send self :num-points)))))
    (defmeth var-window :focus-on-selection ()
      (call-next-method)
      (send current-data :var-states
            (send self :point-state (iseq (send self :num-points)))))
    (defmeth var-window :show-all-points ()
      (call-next-method)
      (send current-data :var-states
            (send self :point-state (iseq (send self :num-points)))))
    (send var-window :fix-name-list)
    ;(send var-window :has-h-scroll (max (screen-size)))
    ;(send var-window :has-v-scroll (max (screen-size)))
    (send obs-window :clear-points)
    (send obs-window :new-menu "Obs"
          :items '(ERASE-SELECTION FOCUS-ON-SELECTION SHOW-ALL))
    (send (send obs-window :menu) :append-items cancel-obs-selection)
    (defmeth obs-window :close () 
      (send self :hide-window)
      (send *vista* :obs-showing nil))
    (send self :obs-window-object obs-window)
    (send self :mat-window-object obs-window)
    (send self :cells-window-object obs-window)
    (defmeth obs-window :unselect-all-points ()
      (call-next-method)
      (send *vista* :set-obs-mats-states obs-window))
    (defmeth obs-window :do-select-click (x y m1 m2)
      (when (> (send self :num-points) 0)
            (call-next-method x y m1 m2)
            (send (fourth (send (send self :menu) :items)) :enabled t)
            (send *vista* :set-obs-mats-states obs-window)))
    (defmeth obs-window :erase-selection ()
      (call-next-method)
      (send (fourth (send (send self :menu) :items)) :enabled nil)
      (send *vista* :set-obs-mats-states obs-window))
    (defmeth obs-window :focus-on-selection ()
      (call-next-method)
      (send *vista* :set-obs-mats-states obs-window))
    (defmeth obs-window :show-all-points ()
      (call-next-method)
      (send *vista* :set-obs-mats-states obs-window))
    (defmeth obs-window :redraw ()
      (when (send *vista* :ready-to-redraw self)
            (call-next-method)
            (send *vista* :finished-redraw self)))
    (defmeth var-window :redraw ()
      (when (send *vista* :ready-to-redraw self)
            (call-next-method)
            (send *vista* :finished-redraw self)))
    (send obs-window :fix-name-list)
    ;(send obs-window :has-h-scroll (max (screen-size)))
    ;(send obs-window :has-v-scroll (max (screen-size)))
    (send self :menu-states "Disabled")
    (send self :desktop-sizes screen-size)
    (send self :color-values-list 
          (list *workmap-background* *toolbar-background* *data-icon-color* 
                *model-icon-color* *tool-icon-color* *guide-icon-color* 
                *button-on-color* *button-off-color*))
    ))

(defmeth vista-system-object-proto :set-obs-mats-states (w)
  (if (send current-data :matrices)
          (send current-data :mat-states 
                (send w :point-state (iseq (send w :num-points))))
          (send current-data :obs-states
                (send w :point-state (iseq (send w :num-points))))))

(defmeth vista-system-object-proto :show-labels ()
  (let ((n (send current-data :nvar))
        (w (send self :var-window-object))
        )
#+msdos(send w :clear)
#-msdos(send w :clear :draw nil)
    (send w :add-points n :draw nil :point-labels
          (mapcar #'concatenate (repeat 'string n) 
                  (send current-data :variables) 
                  (repeat " (" n) (send current-data :types) 
                  (repeat ")" n)))
    (send w :point-state (iseq n) (send current-data :var-states))
    (send w :fix-name-list)
    ;(send w :has-h-scroll (max (screen-size)))
    ;(send w :has-v-scroll (max (screen-size)))
    (send w :scroll 0 0)
    (send w :redraw)
    ))

(defmeth vista-system-object-proto :show-obs ()
  (let* ((n (send current-data :nobs))
         (w (send self :obs-window-object))
         (m (send w :menu)))
#+msdos(send w :clear)
#-msdos(send w :clear :draw nil)
    (send w :title "Obs")
    (send w :add-points n :draw nil :point-labels (send current-data :labels))
    (send w :point-state (iseq n) (send current-data :obs-states))
    (send w :fix-name-list)
    ;(send w :has-h-scroll (max (screen-size)))
    ;(send w :has-v-scroll (max (screen-size)))
    (send w :scroll 0 0)
    (send w :redraw)
    (send show-obs-menu-item :title "List Observations")
    (send show-obs-popup-menu-item :title "List Observations")
    (send m :remove)
    (send m :title "Obs")))         

(defmeth vista-system-object-proto :show-mats ()
  (let* ((n (send current-data :nmat))
         (w (send self :mat-window-object))
         (m (send w :menu)))
#+msdos(send w :clear)
#-msdos(send w :clear :draw nil)
    (send w :title "Mats")
    (send w :add-points n :draw nil 
            :point-labels (send current-data :matrices))
    (send w :point-state (iseq n) (send current-data :mat-states))
    (send w :fix-name-list)
    ;(send w :has-h-scroll (max (screen-size)))
    ;(send w :has-v-scroll (max (screen-size)))
    (send w :scroll 0 0)
    (send w :redraw)
    (send show-obs-menu-item :title "List Matrices")
    (send show-obs-popup-menu-item :title "List Matrices")
    (send m :remove)
    (send m :title "Mats")))

(defmeth vista-system-object-proto :show-cells ()
  (let* ((n (send current-data :ncells))
         (w (send self :cells-window-object))
         (m (send w :menu)))
#+msdos(send w :clear)
#-msdos(send w :clear :draw nil)
    (send w :title "Cells")
    (send w :add-points n :draw nil 
            :point-labels (send current-data :labels))
    (send w :fix-name-list)
    ;(send w :has-h-scroll (max (screen-size)))
    ;(send w :has-v-scroll (max (screen-size)))
    (send w :scroll 0 0)
    (send w :redraw)
    (send show-obs-menu-item :title "List Cells")
    (send show-obs-popup-menu-item :title "List Cells")
    (send m :remove)
    (send m :title "Cells")))

(defmeth vista-system-object-proto :store-slot-info (slot-list)
  (send self :guidemap-slots 
        (append (send self :guidemap-slots) slot-list)))

(defmeth vista-system-object-proto :store-return-info 
  (instant-return guidemap-number)
  (if (not guidemap-number)
      (send self :instant-return
            (append (send self :instant-return) (list instant-return)))
      (setf (select (send *vista* :instant-return) guidemap-number) 
             instant-return)))

(defun vista-system ()
  (send vista-system-object-proto :new))

(defmeth vista-system-object-proto :expert 
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves the expert mode of the system."
  (if set (setf (slot-value 'expert) logical))
  (slot-value 'expert))

(defmeth vista-system-object-proto :guidemap 
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves the guidemap mode of the system."
  (if set (setf (slot-value 'guidemap) logical))
  (slot-value 'guidemap))

(defmeth vista-system-object-proto :show-help 
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves the show-help mode of the system."
  (if set (setf (slot-value 'show-help) logical))
  (slot-value 'show-help))

(defmeth vista-system-object-proto :show-first-help 
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves the show-first-help mode of the system."
  (if set (setf (slot-value 'show-first-help) logical))
  (slot-value 'show-first-help))

(defmeth vista-system-object-proto :show-menu-help-again
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves the show-menu-help-again mode of the system."
  (if set (setf (slot-value 'show-menu-help-again) logical))
  (slot-value 'show-menu-help-again))

(defmeth vista-system-object-proto :full-screen
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves the full-screen mode of the system."
  (if set (setf (slot-value 'full-screen) logical))
  (slot-value 'full-screen))

(defmeth vista-system-object-proto :button-down 
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether a guidemap button is down."
  (if set (setf (slot-value 'button-down) logical))
  (slot-value 'button-down))

(defmeth vista-system-object-proto :delay-update 
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether the updating of the guidemap window has been delayed."
  (if set (setf (slot-value 'delay-update) logical))
  (slot-value 'delay-update))

(defmeth vista-system-object-proto :long-menus
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether the data and model menus show object names."
  (if set (setf (slot-value 'long-menus) logical))
  (slot-value 'long-menus))

(defmeth vista-system-object-proto :menu-states
  (&optional (string nil set))
"Message args: (&optional string)
 Sets or retrieves states of the menus. States can be a string that is Table, Matrix, MV, Enabled or Disabled."
  (if set (setf (slot-value 'menu-states) string))
  (slot-value 'menu-states))

(defmeth vista-system-object-proto :delay-return 
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether returning to the parent guidemap window has been delayed."
  (if set (setf (slot-value 'delay-return) logical))
  (slot-value 'delay-return))

(defmeth vista-system-object-proto :instant-return 
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether returning to the parent guidemap window is to instantly occur before map is displayed."
  (if set (setf (slot-value 'instant-return) logical))
  (slot-value 'instant-return))

(defmeth vista-system-object-proto :guidemap-name 
  (&optional (string nil set))
"Message args: (&optional string)
 Sets or retrieves the current guidemap name."
  (if set (setf (slot-value 'guidemap-name) string))
  (slot-value 'guidemap-name))

(defmeth vista-system-object-proto :guidemap-number 
  (&optional (number nil set))
"Message args: (&optional number)
 Sets or retrieves the current guidemap load sequence number."
  (if set (setf (slot-value 'guidemap-number) number))
  (slot-value 'guidemap-number))

(defmeth vista-system-object-proto :need-new-guidemap 
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether a new guidemap needs to be loaded."
  (if set (setf (slot-value 'need-new-guidemap) logical))
  (slot-value 'need-new-guidemap))

(defmeth vista-system-object-proto :guidemap-slots 
  (&optional (list nil set))
"Message args: (&optional list)
 Sets or retrieves list of guidemap slot values."
  (if set (setf (slot-value 'guidemap-slots) list))
  (slot-value 'guidemap-slots))

(defmeth vista-system-object-proto :show-guidemap
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to show the guidemap at startup."
  (if set (setf (slot-value 'show-guidemap) logical))
  (slot-value 'show-guidemap))

(defmeth vista-system-object-proto :hide-workmap
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to hide the workmap at startup."
  (if set (setf (slot-value 'hide-workmap) logical))
  (slot-value 'hide-workmap))

(defmeth vista-system-object-proto :show-toolbar
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to show the toolbar at startup."
  (if set (setf (slot-value 'show-toolbar) logical))
  (slot-value 'show-toolbar))

(defmeth vista-system-object-proto :show-welcome
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to show the welcome message at startup."
  (if set (setf (slot-value 'show-welcome) logical))
  (slot-value 'show-welcome))

(defmeth vista-system-object-proto :show-varobs
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to show the variable and observation windows at startup."
  (if set (setf (slot-value 'show-varobs) logical))
  (slot-value 'show-varobs))

(defmeth vista-system-object-proto :show-long-menus
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to show long-menus at startup."
  (if set (setf (slot-value 'show-long-menus) logical))
  (slot-value 'show-long-menus))

(defmeth vista-system-object-proto :show-listener
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to show the listener at startup."
  (if set (setf (slot-value 'show-listener) logical))
  (slot-value 'show-listener))

(defmeth vista-system-object-proto :show-load-vista
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to show the load vista dialog at startup."
  (if set (setf (slot-value 'show-load-vista) logical))
  (slot-value 'show-load-vista))

(defmeth vista-system-object-proto :show-open-data
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to show the open-data-dialog at startup."
  (if set (setf (slot-value 'show-open-data) logical))
  (slot-value 'show-open-data))

(defmeth vista-system-object-proto :report-window-id-list
  (&optional (list nil set))
"Message args: (&optional list)
 Sets or retrieves the list of report-window object ids."
  (if set (setf (slot-value 'report-window-id-list) list))
  (slot-value 'report-window-id-list))

(defmeth vista-system-object-proto :directory-list
  (&optional (list nil set))
"Message args: (&optional list)
 Sets or retrieves the list of directories last used."
  (if set (setf (slot-value 'directory-list) list))
  (slot-value 'directory-list))

(defmeth vista-system-object-proto :vars-showing
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves the showing status of the vars window."
  (if set (setf (slot-value 'vars-showing) logical))
  (slot-value 'vars-showing))

(defmeth vista-system-object-proto :obs-showing
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves the showing status of the obs window."
  (if set (setf (slot-value 'obs-showing) logical))
  (slot-value 'obs-showing))

(defmeth vista-system-object-proto :help-showing
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether the help window is showing."
  (if set (setf (slot-value 'help-showing) logical))
  (slot-value 'help-showing))

(defmeth vista-system-object-proto :background-color
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether background color is on."
  (if set (setf (slot-value 'background-color) logical))
  (slot-value 'background-color))

(defmeth vista-system-object-proto :color-values-list
  (&optional (list nil set))
"Message args: (&optional list)
 Sets or retrieves color-values-list."
  (if set (setf (slot-value 'color-values-list) list))
  (slot-value 'color-values-list))

(defmeth vista-system-object-proto :applet-name
  (&optional (string nil set))
"Message args: (&optional string)
 Nil if not a guided applet, applet name otherwise."
  (if set (setf (slot-value 'applet-name) string))
  (slot-value 'applet-name))

(defmeth vista-system-object-proto :internal-map
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether to read guidemap from file or internally."
  (if set (setf (slot-value 'internal-map) logical))
  (slot-value 'internal-map))

(defmeth vista-system-object-proto :applets
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether in applet mode."
  (if set (setf (slot-value 'applets) logical))
  (slot-value 'applets))

(defmeth vista-system-object-proto :redraw-active
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether a window is redrawing."
  (if set (setf (slot-value 'redraw-active) logical))
  (slot-value 'redraw-active))

(defmeth vista-system-object-proto :postponed-redraw-list
  (&optional (list nil set))
"Message args: (&optional list)
 Sets or retrieves the list of windows with postponed redraw requests."
  (if set (setf (slot-value 'postponed-redraw-list) list))
  (slot-value 'postponed-redraw-list))

(defmeth vista-system-object-proto :configure
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether in configuring mode."
  (if set (setf (slot-value 'configure) logical))
  (slot-value 'configure))

(defmeth vista-system-object-proto :vis-window-status
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves the visualization windows status: t=open, nil=closed." 
  (if set (setf (slot-value 'vis-window-status ) logical))
  (slot-value 'vis-window-status ))

(defmeth vista-system-object-proto :help-window-status
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves the help window status: t=open, nil=closed." 
  (if set (setf (slot-value 'help-window-status ) logical))
  (slot-value 'help-window-status ))

(defmeth vista-system-object-proto :var-window-object 
  (&optional (objid nil set))
"Message args: (&optional objid)
 Sets or retrieves the object identification of the variable window."
  (if set (setf (slot-value 'var-window-object) objid))
  (slot-value 'var-window-object))

(defmeth vista-system-object-proto :obs-window-object 
  (&optional (objid nil set))
"Message args: (&optional objid)
 Sets or retrieves the object identification of the observation window."
  (if set (setf (slot-value 'obs-window-object) objid))
  (slot-value 'obs-window-object))

(defmeth vista-system-object-proto :mat-window-object 
  (&optional (objid nil set))
"Message args: (&optional objid)
 Sets or retrieves the object identification of the matrix window."
  (if set (setf (slot-value 'mat-window-object) objid))
  (slot-value 'mat-window-object))

(defmeth vista-system-object-proto :cells-window-object 
  (&optional (objid nil set))
"Message args: (&optional objid)
 Sets or retrieves the object identification of the table cells window."
  (if set (setf (slot-value 'cells-window-object) objid))
  (slot-value 'cells-window-object))

(defmeth vista-system-object-proto :help-window-object 
  (&optional (objid nil set))
"Message args: (&optional objid)
 Sets or retrieves the object identification of the help window."
  (if set (setf (slot-value 'help-window-object) objid))
  (slot-value 'help-window-object))

(defmeth vista-system-object-proto :guide-window-size 
  (&optional (size-list nil set))
"Message args: (&optional size-list)
 Sets or retrieves the size of the guidemap window."
  (if set (setf (slot-value 'guide-window-size) size-list))
  (slot-value 'guide-window-size))

(defmeth vista-system-object-proto :guide-window-location 
  (&optional (location-list nil set))
"Message args: (&optional location-list)
 Sets or retrieves the locationof the guidemap window."
  (if set (setf (slot-value 'guide-window-location) location-list))
  (slot-value 'guide-window-location))

(defmeth vista-system-object-proto :desktop-sizes 
  (&optional (number-list nil set))
"Message args: (&optional number-list)
 Sets or retrieves the current guidemap width and height."
  (if set (setf (slot-value 'desktop-sizes) number-list))
  (slot-value 'desktop-sizes))

(defmeth vista-system-object-proto :help-layout-sizeloc
  (&optional (number-list nil set))
"Message args: (&optional number-list)
 Sets or retrieves the help size and location layout."
  (if set (setf (slot-value 'help-layout-sizeloc) number-list))
  (slot-value 'help-layout-sizeloc))

(defmeth vista-system-object-proto :workmap-layout-sizeloc 
  (&optional (number-list nil set))
"Message args: (&optional number-list)
 Sets or retrieves the workmap size and location layout."
  (if set (setf (slot-value 'workmap-layout-sizeloc) number-list))
  (slot-value 'workmap-layout-sizeloc))

(defmeth vista-system-object-proto :save-desktop 
  (&optional (logical nil set))
"Message args: (&optional logical)
 Sets or retrieves whether desktop sizes being saved for next startup."
  (if set (setf (slot-value 'save-desktop) logical))
  (slot-value 'save-desktop))

(defmeth vista-system-object-proto :font (&optional (string nil set))
  (if set (setf (slot-value 'font) string))
  (slot-value 'font))

(defmeth vista-system-object-proto :list-vars ()
"Alias for list-variables"
  (send self :list-variables))

(defmeth vista-system-object-proto :list-var ()
"Alias for list-variables"
  (send self :list-variables))

(defmeth vista-system-object-proto :list-variables ()
"Args: none
Lists the variable names in the vars window."
  (when (not (equal *current-data* *current-object*))
        (setcd *current-data*))
  (send self :vars-showing t)
  (send (send self :var-window-object) :show-window))

(defmeth vista-system-object-proto :list-obs ()
"Alias for list-observations" 
  (send self :list-observations))

(defmeth vista-system-object-proto :list-observations () 
"Args: none
Lists the observations labels in the obs window."
  (when (not (equal *current-data* *current-object*))
        (setcd *current-data*))
  (send self :obs-showing t)
  (send (send self :obs-window-object) :show-window))

(defmeth vista-system-object-proto :list-mat ()
"Alias for list-matrices" 
  (send self :list-matrices))

(defmeth vista-system-object-proto :list-mats ()
"Alias for list-matrices" 
  (send self :list-matrices))

(defmeth vista-system-object-proto :list-matrices () 
"Args: None
Lists the matrix names in the mats window."
  (when (not (equal *current-data* *current-object*))
        (setcd *current-data*))
  (send self :obs-showing t)
  (send (send self :mat-window-object) :show-window))

(defmeth vista-system-object-proto :list-cells () 
  (when (not (equal *current-data* *current-object*))
        (setcd *current-data*))
  (send self :obs-showing t)
  (send (send self :cells-window-object) :show-window))

(provide "systmobj")
