;;########################################################################
;; modelobj.lsp
;; contains code to implement prototype model object
;; includes model load-on-demand functions
;; Copyright (c) 1991-98 by Forrest W. Young
;;########################################################################

;;------------------------------------------------------------------------
;;define prototype multivariate model object 
;;inheriting from  multivariate data  object
;;------------------------------------------------------------------------

(defproto mv-model-object-proto 
  '(save-menu-item create-menu-item visualize-menu-item 
   report-menu-item model-abbrev dialog data-object) ()
  mv-data-object-proto)

#|Pre 4.28 version
(defmeth mv-model-object-proto :isnew 
                   (tool-number data-obj title name dialog)
  (let ((data-list (send data-obj :active-data '(numeric)))
        (variables (send data-obj :active-variables '(numeric)))
        (types     (send data-obj :active-types '(numeric)))
        (labels    (send data-obj :active-labels))
        )
    (if (not (eq current-object data-obj)) (setcd data-obj))
    (if (not name) (setf name (strcat (send self :model-abbrev) "-"
                                      (send data-obj :name))))
    (if (not title) (setf title (send data-obj :title)))
    (call-next-method data-list variables title labels types name)
    (send *toolbox* :copy-tool-icon tool-number)
    (send self :dialog dialog)
    (let ((go-for-it (send self :options)))
      (when (and (send self :dialog) (not go-for-it) (< tool-number 9))
            (send *toolbox* :reset-button tool-number))
      (when (or (not (send self :dialog)) go-for-it) 
            (send self :data-object data-obj)
            (send self :analysis)
            (send self :new-object)
;tool-number=9 for transformations, <9 for models
            (when (< tool-number 9) (setcm self))
            ))))|#

;preceeding pre4.28 version was changed to following by fwy4.28
;this allows multivariate analyses on non-numeric data (sorting, ranking)
;and presents dialog boxes when guidemaps are being used

(defmeth mv-model-object-proto :isnew 
                   (tool-number data-obj title name dialog 
                                &optional (ok-types '(numeric)));fwy4.28
  (let ((data-list (send data-obj :active-data ok-types));fwy4.28
        (variables (send data-obj :active-variables ok-types));fwy4.28
        (types     (send data-obj :active-types ok-types));fwy4.28
        (labels    (send data-obj :active-labels))
        )
    (if (not (eq current-object data-obj)) (setcd data-obj))
    (if (not name) (setf name (strcat (send self :model-abbrev) "-"
                                      (send data-obj :name))))
    (if (not title) (setf title (send data-obj :title)))
    (call-next-method data-list variables title labels types name)
    (send *toolbox* :copy-tool-icon tool-number)
    (when (send *vista* :guidemap) (setf dialog t));fwy4.28
    (send self :dialog dialog)
    (let ((go-for-it (send self :options)))
      (when (and (send self :dialog) (not go-for-it) (< tool-number 9))
            (send *toolbox* :reset-button tool-number)
            (setcd data-obj)
            (send *workmap* :redraw))
      (when (or (not (send self :dialog)) go-for-it) 
            (send self :data-object data-obj)
            (send self :analysis)
            (send self :new-object)
;tool-number=9 for transformations, <9 for models
;fwy4.28 7/20/97 following statment modified to work with guidemaps
            (when (and (not (send *vista* :guidemap)) (< tool-number 9)) 
                  (setcm self))
            ))))

(defmeth mv-model-object-proto :new-object ()
  (setf current-model self)
  (setf *current-model* self)
  (setf current-object self)
  (setf *current-object* self)
  (send *model-menu* :enabled t)
  (send (send *vista* :var-window-object) :clear)
  (send (send *vista* :obs-window-object) :clear)
  (send self :add-model-menu-item (send self :model-abbrev))
  )

(defmeth mv-model-object-proto :save-menu-item 
  (&optional (state nil set))
    (if set (setf (slot-value 'save-menu-item) state))
    (slot-value 'save-menu-item))

(defmeth mv-model-object-proto :create-menu-item 
  (&optional (state nil set))
    (if set (setf (slot-value 'create-menu-item) state))
    (slot-value 'create-menu-item))

(defmeth mv-model-object-proto :visualize-menu-item 
  (&optional (state nil set))
    (if set (setf (slot-value 'visualize-menu-item) state))
    (slot-value 'visualize-menu-item))

(defmeth mv-model-object-proto :report-menu-item 
  (&optional (state nil set))
    (if set (setf (slot-value 'report-menu-item) state))
    (slot-value 'report-menu-item))

(defmeth mv-model-object-proto :model-abbrev 
  (&optional (state nil set))
    (if set (setf (slot-value 'model-abbrev) state))
    (slot-value 'model-abbrev))

(defmeth mv-model-object-proto :dialog (&optional (value nil set))
    (if set (setf (slot-value  'dialog) value))
    (slot-value 'dialog))

(defmeth mv-model-object-proto :data-object (&optional (object-id nil set))
    (if set (setf (slot-value  'data-object) object-id))
    (slot-value 'data-object))

(defmeth  mv-model-object-proto :add-model-menu-item (model-abbrev)
  (let* ((object current-model)
         (current-menu-length (length (send (eval *model-menu*) :items)))
         (menu-name 
          (concatenate 'string  model-abbrev "-" (send current-data :name)))
         (selected-icon (send *desktop* :selected-icon))
         (current-model-icon-objid nil)
         )
    (send object :add-parent current-data)
    (send current-data :add-child object)
    (send *desktop* :add-connected-icon selected-icon menu-name 3)
    (set (intern (string-upcase menu-name)) current-model)
    (setf current-model-icon-objid
          (first (last (send *workmap* :model-icon-list))))
    (send current-model-icon-objid :object object)
    (cond ((send *vista* :long-menus)
           (send object :menu-length current-menu-length)
           (send *desktop* :no-menu-marks *model-menu*)
           (send *model-menu* :append-items 
                 (send menu-item-proto :new menu-name :mark t
                       :action #'(lambda () (set-current-model object)))))
      (t (send object :menu-length 
               (+ current-menu-length
                  (length (send *workmap* :model-icon-list))))))
    (setf current-model-menu-item-number current-menu-length)
    (when (send *vista* :guidemap) (setcd current-data))
    ))

(defun setcm (object) (set-current-model object))

(defun set-current-model (object)
  (let* ((menu-length (send object :menu-length))
         (long-menus (send *vista* :long-menus))
         (current-icon nil))
    (when (not long-menus) (setf menu-length (1- menu-length)))
    (setf current-icon (select (send *workmap* :model-icon-number-list)
                  (- menu-length (send *workmap* :num-model-menu-items))))
    (setf current-model  object)
    (setf current-object object)
    (setf *current-model* object)
    (setf *current-object* object)
    (send *workmap* :initialize-model-menu)
    (send *workmap* :select-icon current-icon)
    (send (send *vista* :var-window-object) :clear)
    (send (send *vista* :obs-window-object) :clear)
    (cond 
      ((equal "UNI" (send current-model :model-abbrev))
       (send create-dataobjects-model-popup-menu-item :enabled nil)
       (send create-dataobjects-model-menu-item :enabled nil))
      (t
       (send create-dataobjects-model-popup-menu-item :enabled t)
       (send create-dataobjects-model-menu-item :enabled t)))
    (when long-menus
          (send *workmap* :no-menu-marks *model-menu*)
          (send (select (send *model-menu* :items) menu-length) :mark t))
    (when (send *vista* :guidemap) 
          (when investigate 
                (format t "Calling Guidance from SETCModel."))
          (guidance "model"))
    object))

(setf *current-model* nil)

(defun save-model (&optional name)
"Args: (&optional name)
Saves the current model to a file named NAME"
  (if name (send current-model :save-model name)
      (send current-model :save-model)))

(defmeth mv-model-object-proto :save-model (&optional file)
"Args: (&optional file)
FILE is a string. The model-object is written to the file FILE.lsp in a form suitable for use with the load-model command.  The template for this form
is supplied by the specific model object by a save-model-template method."
  (when (not (eq current-object self)) (setcm self))
  (let* ((name (send current-model :name))
         (L (min 8 (length name)))
         (suggest (strcat (subseq name 0 L) ".lsp")))
    (set-working-directory *user-dir-name*)
    (when (not file) 
            (setf file 
#+macintosh (set-file-dialog  "Save Model as File:" suggest t)
#+msdos     (set-file-dialog  "Save Model as File:" suggest)
#+X11       (file-save-dialog "Save Model as File:" "*.lsp" ".")
                           ))
    (when file
          (setf file (string-downcase-if-not-X11 file))
          (when (and (> (length file) 3)
                     (string= ".lsp" file
                              :start2 (- (length file) 4)))
                (setf file (string-right-trim "lsp" 
                              (string-downcase-if-not-X11 file)))
                (setf file (string-right-trim "." file)))
          (format t "; saving ~s~%" file)
          (let ((f (open (strcat (string file) ".lsp") :direction :output))
                (data-object (send self :data-object))
                (oldbreak *breakenable*))
            (setq *breakenable* nil)
            (unwind-protect 
             (print (send self :save-model-template data-object) f))
            (setq *breakenable* oldbreak)
            (close f)
            (format t "; finished saving ~s~%" file)
            f))))

(defmeth mv-model-object-proto :create-input-data-object 
  (model-abbrev creator)
  (data  (concatenate 'string "Input-" (send self :name))
   :title (concatenate 'string model-abbrev (send self :title))
   :created creator
   :creator-object self
   :labels (send self :labels)
   :data (send self :data)
   :variables (send self :variables)
   :types (send self :types))
  )

(defmeth mv-model-object-proto :interpret-model ()
  (error-message "Interpretation Not Yet Defined for This Model") t)

(defun select-current-model-icon ()
  (send *desktop* :select-icon 
        (select (send *desktop* :model-icon-number-list)
                (- current-model-menu-item-number 7))))

(defmeth mv-model-object-proto :use-new-tip (vector xvar yvar x y)
  (format t 
          "Moved Vector Tip ~g to x=~g on variable ~g, y=~g on variable ~g~%" 
          vector x xvar y yvar))

(defun load-model (&optional file)
"Args: (&optional file)
Loads a model object contained in a file.  The file's name must end with .lsp.
If the optional string argument FILE is included, the model object is loaded 
from FILE, otherwise a dialog is presented to select the file. The string 
need not end with .lsp.  Returns the object-id of the model object."
  (when (not file) 
        (setf file (open-file-dialog t)))
  (when file
        (let ((object (send *desktop* :load-object file))
              (previous-previous-data previous-data)
              )
          (cond ((objectp object)
                 (when (not previous-data)
                       (send *desktop* :initialize-data-menu)
                       (send *desktop* :initialize-model-menu)))
            (t (error "File does not contain an object.")
               (setf current-data previous-data)
               (setf previous-data previous-previous-data)))
          object)))

#|This code removed in 4.31. Appropriate (renamed) files loaded in vista.lsp
(defun visualize-model ()
"Function Args: None
Load-on-demand function for model visualization."
;real function is in graphics file
  (load (strcat *vista-dir-name* "graphics"))
  (load (strcat *vista-dir-name* "graphobj"))
  (send current-model :visualize))|#

;;########################################################################
;;Define code loading functions for each model object.
;;These functions load the code for the model object,
;;then they evoke the model object.
;;########################################################################

;;Analyis of Variance code loading function

(defun analysis-of-variance (&rest args)
"ViSta function to perform Analysis of Variance.  
With no arguments the current data are analyzed. Keyword arguments are
:INTERACTION followed by t (calculate interaction) or nil (do not calculate);
:DATA followed by the name of the data to be analyzed (default: current-data);
:TITLE followed by a character string (default: Analysis of Variance);
:DIALOG followed by t (to display parameters dialog box) or nil (default)."
(princ ";Analysis of Variance code Copyright (c) 1994-6, by Forrest W. Young")
  (terpri)
  (load (strcat *vista-dir-name* "anovamob"))
  (apply #'analysis-of-variance args))

;;Correspondence Analysis program loading function

(defun correspondence-analysis (&rest args)
"ViSta function to perform Correspondence Analysis.  
With no arguments, performs a 3-dimensional, row and column normalized correspondence analysis of the active variables in the current data, results being printed to a precision of 4 decimal places. 
Keyword arguments are
:DIMENSIONS followed by an integer to specify the dimensionality of the analysis (default is 3);
:PROFILE followed by one of the following character strings: 
         BOTH (default) to analyze both row and column profiles,
         ROW to analyze row profiles,
         COLUMN to analyze column profiles;
:PRECISION followed by an integer specifying the number of printed decimals;
:DATA followed by the name of the data to be analyzed (default: current-data);
:TITLE followed by a character string (default: Correspondence Analysis);
:DIALOG followed by t (to display parameters dialog box) or nil (default)."
  (princ ";Correspondance Analysis code Copyright (c) 1992-4, by Lee Bee Leng")
  (terpri)
  (load (strcat *vista-dir-name* "crspmob1"))
  (load (strcat *vista-dir-name* "crspmob2"))
  (apply #'correspondence-analysis args))

;;Factor Analysis program loading function

(defun factor-analysis (&rest args)
(error-message "The Factor Analysis module is not yet available."))

;;Multidimensional Scaling program loading function

(defun multidimensional-scaling (&rest args)
"ViSta function to perform Multidimensional Scaling.  
With no arguments, performs a 3-dimensional scaling using all active data matrices in the current data. Keyword arguments are:
:DIMENSIONS followed by an integer to specify the dimensionality of the analysis (default is 3);
:DATA followed by the name of the data to be analyzed (default: current-data);
:TITLE followed by a character string (default: Multidimensional Scaling);
:DIALOG followed by t (to display parameters dialog box) or nil (default)."
  (princ "; mdsmob1, mdsmob2 Copyright (c) 1992-4, by Mary M. McFarlane")
  (terpri)
  (load (strcat *vista-dir-name* "mdsmob1"))
  (load (strcat *vista-dir-name* "mdsmob2"))
  (apply #'multidimensional-scaling args))

;;Multivariate Regression program loading function

(defun multivariate-regression (&rest args)
"ViSta function to perform Multivariate Regression analysis.  
With no arguments the current data are analyzed, with the first active numeric variable as the response, and the remaining active numeric variables as the predictors. Keyword arguments are
:RESPONSES followed by a list of the response variables 
      (if there is more than one response variable then several separate
       multiple regressions are performed, each with the same predictors);
:PREDICTORS followed by a list of the predictor variables;
:INTERCEPT followed by t if an intercept is to be computed (default) or 
       nil if an intercept is not to be computed;
:DATA followed by the name of the data to be analyzed (default: current-data);
:TITLE followed by a character string (default: Multivariate Regression);
:DIALOG followed by t (to display parameters dialog box) or nil (default)."
	(princ ";Multivariate Regression code Copyright (c) 1992-6, by Forrest W. Young")
  (terpri)
  (load (strcat *vista-dir-name* "mmrmob1"))
  (load (strcat *vista-dir-name* "mmrmob2"))
  (apply #'multivariate-regression args))

(defun multiple-regression (&rest args)
"Former ViSta function to perform multivariate regression. Please use the current multivariate-regression function."
  (apply #'multivariate-regression args))

;;Principal Components program loading function

(defun principal-components (&rest args)
"ViSta function to perform Principal Components analysis.  
With no arguments, calculate correlations among all active numeric variables in the current data and perform a principal components analysis.
Keyword arguments are:
:COVARIANCES followed by t (analyze covariances) or nil (_analyze correlations, the default).
:DATA followed by the name of the data to be analyzed (default: current-data);
:TITLE followed by a character string (default: Principal Components);
:DIALOG followed by t (to display parameters dialog box) or nil (default)."
	(princ ";Principal Components code Copyright (c) 1992-6, by Forrest W. Young")
  (terpri)
  (load (strcat *vista-dir-name* "pcamob"))
  (apply #'principal-components args))

;;Univariate Regression program loading function

(defun regression-analysis (&rest args)
"ViSta function to perform Univariate Regression analysis.  
With no arguments the current data are analyzed, with the first active numeric variable as the response, and the remaining active numeric variables as the predictors. Keyword arguments are
:DATA followed by the name of the data to be analyzed (default: current-data);
:TITLE followed by a character string (default: Univariate Regression);
:DIALOG followed by t (to display parameters dialog box) or nil (default);
:RESPONSE followed by a string which is the name of the response variable (default, first active numeric variable);
:PREDICTORS followed by a list of the predictor variables (default, all active numeric variables except the first);
:ITERATIONS followed by a positive number (default 20);
:METHOD followed by a string which is either ols (the default), robust, or monotonic;
:MIN-RSQ-IMPROVE followed by a postive number near, but not less than, 0 (default is .001)
:MAX-RSQ followed by a positive number near, but not greater than, 1 (default is 1)."
  (princ ";Univariate Regression code Copyright (c) 1995-6, by Carla M. Bann")
  (terpri)
  (load (strcat *vista-dir-name* "regmob"))
  (apply #'regression-analysis args))

;;Univariate Analysis code loading function

(defun univariate-analysis (&rest args)
"ViSta function to perform Univariate Analysis.  
With no arguments the first active numeric variable of the current data are analyzed, with the remaining variables being ignored. Keyword arguments are:
:DATA followed by the name of the data to be analyzed (default: current-data);
:TITLE followed by a character string (default: Univariate Analysis);
:DIALOG followed by t (to display parameters dialog box) or nil (default);
:VARIABLE followed by a string which is the name of the variable to be analyzed (default is the first active numeric variable);
:MU followed by a number specifying the population mean under the null hypothesis (default is 0);
:SIGMA followed by a number specifying the population standard deviation, if known (default is nil, implying SIGMA is unknown);
:T-DIRECTION followed by -1 (negative 1-tailed), 0 (default, two-tailed), or 1 (positive one-tailed) specifying the type of t-test.
:T-CI-LEVEL followed by a positive number near 1 specifing the confidence interval level (default is .95)."
  (princ ";Univariate Analysis code Copyright (c) 1995-6, by Forrest W. Young")
  (terpri)
  (load (strcat *vista-dir-name* "unimob")) 
  (apply #'univariate-analysis args))

(provide "modelobj")