/* $Header: /home/agc/src/ssam-1.9/RCS/agc.h,v 1.2 1997/10/21 10:06:16 agc Exp agc $ */

/*
 * Copyright © 1996-1997 Alistair G. Crooks.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Alistair G. Crooks.
 * 4. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef AGC_H_
#define AGC_H_

/*************************************************************************/
/* useful definitions */

#ifndef NEWARRAY
#define NEWARRAY(t, ptr, size, action)					\
	do { 								\
		ptr = (t *) calloc(size, sizeof(t));			\
		if (ptr == (t *) NULL) { 				\
			(void) fprintf(stderr,				\
				"NEWARRAY: %s %d can't alloc %d bytes\n",\
				__FILE__,				\
				__LINE__,				\
				(int)(size * sizeof(t)));		\
			action; 					\
		}							\
	} while (0)
#endif

#ifndef RENEW
#define RENEW(t, ptr, size, action)					\
	do { 								\
		ptr = (t *) realloc(ptr, (size * sizeof(t)));		\
		if (ptr == (t *) NULL) { 				\
			(void) fprintf(stderr,				\
				"RENEW: %s %d can't alloc %d bytes\n",	\
				__FILE__,				\
				__LINE__,				\
				(int)(size * sizeof(t)));		\
			action; 					\
		}							\
	} while (0)
#endif

#ifndef NEW
#define NEW(type, ptr, action)	NEWARRAY(type, ptr, 1, action)
#endif

#ifndef FREE
#define FREE(ptr)	free(ptr)
#endif

#ifndef MAX
#define MAX(a, b)	(((a) > (b)) ? (a) : (b))
#endif

#ifndef MIN
#define MIN(a, b)	(((a) < (b)) ? (a) : (b))
#endif

#ifndef ABS
#define ABS(a)		(((a) < 0) ? -(a) : (a))
#endif


#endif /* !AGC_H_ */
