/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.util.ArrayList;
import java.util.LinkedList;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.applet.PluginDebug;
import sun.applet.PluginMessageHandlerWorker;
import sun.applet.PluginStreamHandler;

class PluginMessageConsumer {
    private static final int MAX_PARALLEL_INITS = 1;
    private static final int MAX_WORKERS = 4;
    private static final int PRIORITY_WORKERS = 2;
    private static LinkedList<String> priorityWaitQueue = new LinkedList();
    private LinkedList<String> readQueue = new LinkedList();
    private ArrayList<PluginMessageHandlerWorker> workers = new ArrayList();
    private PluginStreamHandler streamHandler;
    private ConsumerThread consumerThread = new ConsumerThread();

    public PluginMessageConsumer(PluginStreamHandler pluginStreamHandler) {
        this.streamHandler = pluginStreamHandler;
        this.consumerThread.start();
    }

    public static void registerPriorityWait(Long l) {
        PluginDebug.debug("Registering priority for reference ", l);
        PluginMessageConsumer.registerPriorityWait("reference " + l.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerPriorityWait(String string) {
        PluginDebug.debug("Registering priority for string ", string);
        LinkedList<String> linkedList = priorityWaitQueue;
        synchronized (linkedList) {
            if (!priorityWaitQueue.contains(string)) {
                priorityWaitQueue.add(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unRegisterPriorityWait(String string) {
        LinkedList<String> linkedList = priorityWaitQueue;
        synchronized (linkedList) {
            priorityWaitQueue.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPriorityStrIfPriority(String string) {
        if (string.endsWith("destroy")) {
            return "destroy";
        }
        LinkedList<String> linkedList = priorityWaitQueue;
        synchronized (linkedList) {
            for (String string2 : priorityWaitQueue) {
                if (string.indexOf(string2) <= 0) continue;
                return string2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(String string) {
        LinkedList<String> linkedList = this.readQueue;
        synchronized (linkedList) {
            this.readQueue.addLast(string);
        }
        this.consumerThread.notifyHasWork();
    }

    private PluginMessageHandlerWorker getFreeWorker(boolean bl) {
        for (PluginMessageHandlerWorker pluginMessageHandlerWorker : this.workers) {
            if (!pluginMessageHandlerWorker.isFree(bl)) continue;
            PluginDebug.debug("Found free worker (", pluginMessageHandlerWorker.isPriority(), ") with id ", pluginMessageHandlerWorker.getWorkerId());
            pluginMessageHandlerWorker.busy();
            return pluginMessageHandlerWorker;
        }
        if (this.workers.size() <= 4) {
            Object object = null;
            if (this.workers.size() < 2) {
                PluginDebug.debug("Cannot find free worker, creating worker ", this.workers.size());
                object = new PluginMessageHandlerWorker(this, this.streamHandler, this.workers.size(), false);
            } else if (bl) {
                PluginDebug.debug("Cannot find free worker, creating priority worker ", this.workers.size());
                object = new PluginMessageHandlerWorker(this, this.streamHandler, this.workers.size(), true);
            } else {
                return null;
            }
            ((Thread)object).start();
            ((PluginMessageHandlerWorker)object).busy();
            this.workers.add((PluginMessageHandlerWorker)object);
            return object;
        }
        return null;
    }

    protected class ConsumerThread
    extends Thread {
        public ConsumerThread() {
            super("PluginMessageConsumer.ConsumerThread");
        }

        public synchronized void notifyHasWork() {
            this.notifyAll();
        }

        public synchronized void waitForWork() {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, interruptedException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bringPriorityMessagesToFront() {
            LinkedList linkedList = PluginMessageConsumer.this.readQueue;
            synchronized (linkedList) {
                for (int i = 0; i < PluginMessageConsumer.this.readQueue.size(); ++i) {
                    String string = (String)PluginMessageConsumer.this.readQueue.remove(i);
                    if (PluginMessageConsumer.getPriorityStrIfPriority(string) != null) {
                        PluginMessageConsumer.this.readQueue.addFirst(string);
                        continue;
                    }
                    PluginMessageConsumer.this.readQueue.add(i, string);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                String string = null;
                Object object = PluginMessageConsumer.this.readQueue;
                synchronized (object) {
                    string = (String)PluginMessageConsumer.this.readQueue.poll();
                }
                if (string != null) {
                    object = PluginMessageConsumer.getPriorityStrIfPriority(string);
                    boolean bl = object != null;
                    PluginMessageHandlerWorker pluginMessageHandlerWorker = PluginMessageConsumer.this.getFreeWorker(bl);
                    if (pluginMessageHandlerWorker == null) {
                        LinkedList linkedList = PluginMessageConsumer.this.readQueue;
                        synchronized (linkedList) {
                            PluginMessageConsumer.this.readQueue.addFirst(string);
                        }
                        this.bringPriorityMessagesToFront();
                        continue;
                    }
                    if (bl) {
                        PluginMessageConsumer.unRegisterPriorityWait((String)object);
                    }
                    pluginMessageHandlerWorker.setmessage(string);
                    pluginMessageHandlerWorker.notifyHasWork();
                    continue;
                }
                this.waitForWork();
            }
        }
    }
}

