/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import com.sun.jndi.toolkit.url.UrlUtil;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.NetxPanel;
import net.sourceforge.jnlp.PluginParameters;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.appletextendedsecurity.AppletSecurityLevel;
import net.sourceforge.jnlp.security.appletextendedsecurity.AppletStartupSecuritySettings;
import net.sourceforge.jnlp.splashscreen.SplashController;
import net.sourceforge.jnlp.splashscreen.SplashErrorPanel;
import net.sourceforge.jnlp.splashscreen.SplashPanel;
import net.sourceforge.jnlp.splashscreen.SplashUtils;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.applet.AppletAudioClip;
import sun.applet.AppletEvent;
import sun.applet.AppletImageRef;
import sun.applet.AppletListener;
import sun.applet.AppletMessageHandler;
import sun.applet.AppletPanel;
import sun.applet.AppletSecurityContextManager;
import sun.applet.PluginAppletPanelFactory;
import sun.applet.PluginAppletSecurityContext;
import sun.applet.PluginCallRequest;
import sun.applet.PluginCallRequestFactory;
import sun.applet.PluginDebug;
import sun.applet.PluginMessageConsumer;
import sun.applet.PluginParameterParser;
import sun.applet.PluginStreamHandler;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.X11.XEmbeddedFrame;
import sun.misc.Ref;

public class PluginAppletViewer
extends XEmbeddedFrame
implements AppletContext,
Printable,
SplashController {
    private NetxPanel panel;
    static final ReentrantLock panelLock = new ReentrantLock();
    static final Condition panelLive = panelLock.newCondition();
    private int identifier;
    private static ConcurrentMap<Integer, PluginAppletViewer> applets = new ConcurrentHashMap<Integer, PluginAppletViewer>();
    private static final ReentrantLock appletsLock = new ReentrantLock();
    private static final Condition appletAdded = appletsLock.newCondition();
    private static PluginStreamHandler streamhandler;
    private static PluginCallRequestFactory requestFactory;
    private static ConcurrentMap<Integer, PAV_INIT_STATUS> status;
    private static final ReentrantLock statusLock;
    private static final Condition initComplete;
    private WindowListener windowEventListener = null;
    private AppletEventListener appletEventListener = null;
    public static final long APPLET_TIMEOUT = 180000000000L;
    private static final Object requestMutex;
    private static long requestIdentityCounter;
    private Image bufFrameImg;
    private Graphics bufFrameImgGraphics;
    private SplashPanel splashPanel;
    private static long REQUEST_TIMEOUT;
    private static Map<URL, AudioClip> audioClips;
    private static Map<URL, AppletImageRef> imageRefs;
    private static Vector<NetxPanel> appletPanels;
    static Hashtable<String, String> systemParam;

    private static void waitForRequestCompletion(PluginCallRequest pluginCallRequest) {
        try {
            if (!pluginCallRequest.isDone()) {
                pluginCallRequest.wait(REQUEST_TIMEOUT);
            }
            if (!pluginCallRequest.isDone()) {
                throw new RuntimeException("Possible deadlock, releasing");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted waiting for call request.", interruptedException);
        }
    }

    public PluginAppletViewer() {
    }

    public static PluginAppletViewer framePanel(int n, long l, int n2, int n3, NetxPanel netxPanel) {
        PluginDebug.debug("Framing ", netxPanel);
        System.getSecurityManager().checkPermission(new AllPermission());
        PluginAppletViewer pluginAppletViewer = new PluginAppletViewer(l, n, netxPanel);
        pluginAppletViewer.setSize(n2, n3);
        pluginAppletViewer.appletEventListener = new AppletEventListener(pluginAppletViewer, pluginAppletViewer);
        netxPanel.addAppletListener(pluginAppletViewer.appletEventListener);
        if (applets.containsKey(n)) {
            PluginAppletViewer pluginAppletViewer2 = (PluginAppletViewer)applets.get(n);
            pluginAppletViewer2.remove(netxPanel);
            netxPanel.removeAppletListener(pluginAppletViewer2.appletEventListener);
        }
        appletsLock.lock();
        applets.put(n, pluginAppletViewer);
        appletAdded.signalAll();
        appletsLock.unlock();
        PluginDebug.debug(netxPanel, " framed");
        return pluginAppletViewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginAppletViewer(long l, final int n, NetxPanel netxPanel) {
        super(l, true);
        this.identifier = n;
        this.panel = netxPanel;
        Serializable serializable = appletPanels;
        synchronized (serializable) {
            if (!appletPanels.contains(this.panel)) {
                appletPanels.addElement(this.panel);
            }
        }
        this.windowEventListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PluginAppletViewer.destroyApplet(n);
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                PluginAppletViewer.this.appletStop();
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
                PluginAppletViewer.this.appletStart();
            }
        };
        this.addWindowListener(this.windowEventListener);
        serializable = this.panel;
        try {
            SwingUtilities.invokeAndWait(new SplashCreator((AppletPanel)serializable));
        }
        catch (Exception exception) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
        }
    }

    @Override
    public void replaceSplash(final SplashPanel splashPanel) {
        if (this.splashPanel == null) {
            return;
        }
        if (splashPanel == null) {
            this.removeSplash();
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    PluginAppletViewer.this.splashPanel.getSplashComponent().setVisible(false);
                    PluginAppletViewer.this.splashPanel.stopAnimation();
                    PluginAppletViewer.this.remove(PluginAppletViewer.this.splashPanel.getSplashComponent());
                    splashPanel.setPercentage(PluginAppletViewer.this.splashPanel.getPercentage());
                    splashPanel.setSplashWidth(PluginAppletViewer.this.splashPanel.getSplashWidth());
                    splashPanel.setSplashHeight(PluginAppletViewer.this.splashPanel.getSplashHeight());
                    splashPanel.adjustForSize();
                    PluginAppletViewer.this.splashPanel = splashPanel;
                    PluginAppletViewer.this.add("Center", PluginAppletViewer.this.splashPanel.getSplashComponent());
                    PluginAppletViewer.this.pack();
                }
            });
        }
        catch (Exception exception) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
        }
    }

    @Override
    public void removeSplash() {
        if (this.splashPanel == null) {
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    PluginAppletViewer.this.splashPanel.getSplashComponent().setVisible(false);
                    PluginAppletViewer.this.splashPanel.stopAnimation();
                    PluginAppletViewer.this.removeAll();
                    PluginAppletViewer.this.setLayout(new BorderLayout());
                    PluginAppletViewer.this.splashPanel = null;
                    PluginAppletViewer.this.add(PluginAppletViewer.this.panel);
                    PluginAppletViewer.this.panel.setVisible(true);
                    PluginAppletViewer.this.pack();
                }
            });
        }
        catch (Exception exception) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
        }
    }

    @Override
    public int getSplashWidth() {
        if (this.splashPanel != null) {
            return this.splashPanel.getSplashWidth();
        }
        return -1;
    }

    @Override
    public int getSplashHeigth() {
        if (this.splashPanel != null) {
            return this.splashPanel.getSplashHeight();
        }
        return -1;
    }

    public static void setStreamhandler(PluginStreamHandler pluginStreamHandler) {
        streamhandler = pluginStreamHandler;
    }

    public static void setPluginCallRequestFactory(PluginCallRequestFactory pluginCallRequestFactory) {
        requestFactory = pluginCallRequestFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleInitializationMessage(int n, String string) throws IOException, LaunchException {
        long l;
        if (AppletStartupSecuritySettings.getInstance().getSecurityLevel() == AppletSecurityLevel.DENY_ALL) {
            throw new LaunchException(null, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LUnsignedApplet"), Translator.R("LUnsignedAppletPolicyDenied"));
        }
        if (PluginAppletViewer.updateStatus(n, PAV_INIT_STATUS.PRE_INIT) != null) {
            return;
        }
        String[] stringArray = new String[4];
        for (int i = 0; i < 3; ++i) {
            int n2 = string.indexOf(32);
            int n3 = string.indexOf(32, n2 + 1);
            stringArray[i] = string.substring(n2 + 1, n3);
            string = string.substring(n3 + 1);
        }
        long l2 = Long.parseLong(stringArray[0]);
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        int n4 = string.indexOf(32, "tag".length() + 1);
        String string4 = string.substring("tag".length() + 1, n4);
        String string5 = string.substring(n4 + 1);
        PluginDebug.debug("Handle = ", l2, "\n", "Width = ", string2, "\n", "Height = ", string3, "\n", "DocumentBase = ", string4, "\n", "Params = ", string5);
        PluginAppletPanelFactory pluginAppletPanelFactory = new PluginAppletPanelFactory();
        AppletMessageHandler appletMessageHandler = new AppletMessageHandler("appletviewer");
        URL uRL = new URL(string4);
        URLConnection uRLConnection = uRL.openConnection();
        uRL = uRLConnection.getURL();
        PluginParameters pluginParameters = new PluginParameterParser().parse(string2, string3, string5);
        streamhandler.write("instance " + n + " status " + appletMessageHandler.getMessage("status.start"));
        pluginAppletPanelFactory.createPanel(streamhandler, n, l2, uRL, pluginParameters);
        appletsLock.lock();
        try {
            for (l = 180000000000L; !applets.containsKey(n) && l > 0L; l -= PluginAppletViewer.waitTillTimeout(appletsLock, appletAdded, l)) {
            }
        }
        finally {
            appletsLock.unlock();
        }
        if (l <= 0L) {
            throw new RuntimeException("Applet initialization timeout");
        }
        PluginAppletViewer.waitForAppletInit(((PluginAppletViewer)PluginAppletViewer.applets.get((Object)Integer.valueOf((int)n))).panel);
        PluginDebug.debug("Init complete");
        if (PluginAppletViewer.updateStatus(n, PAV_INIT_STATUS.REFRAME_COMPLETE).equals((Object)PAV_INIT_STATUS.INACTIVE)) {
            PluginAppletViewer.destroyApplet(n);
            return;
        }
    }

    public static void handleMessage(int n, int n2, String string) {
        PluginDebug.debug("PAV handling: ", string);
        try {
            if (string.startsWith("handle")) {
                PluginAppletViewer.handleInitializationMessage(n, string);
            } else if (string.startsWith("destroy")) {
                PAV_INIT_STATUS pAV_INIT_STATUS = PluginAppletViewer.updateStatus(n, PAV_INIT_STATUS.INACTIVE);
                PluginDebug.debug("Destroy status set for ", n);
                if (pAV_INIT_STATUS != null && pAV_INIT_STATUS.equals((Object)PAV_INIT_STATUS.REFRAME_COMPLETE)) {
                    PluginAppletViewer.destroyApplet(n);
                }
            } else {
                PluginDebug.debug("Handling message: ", string, " instance ", n, " ", Thread.currentThread());
                while (!(applets.containsKey(n) || status.containsKey(n) && !((PAV_INIT_STATUS)((Object)status.get(n))).equals((Object)PAV_INIT_STATUS.PRE_INIT))) {
                }
                if (((PAV_INIT_STATUS)((Object)status.get(n))).equals((Object)PAV_INIT_STATUS.INACTIVE)) {
                    return;
                }
                ((PluginAppletViewer)applets.get(n)).handleMessage(n2, string);
            }
        }
        catch (Exception exception) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
            PluginAppletViewer.updateStatus(n, PAV_INIT_STATUS.INACTIVE);
            throw new RuntimeException("Failed to handle message: " + string + " for instance " + n, exception);
        }
    }

    private static synchronized PAV_INIT_STATUS updateStatus(int n, PAV_INIT_STATUS pAV_INIT_STATUS) {
        PAV_INIT_STATUS pAV_INIT_STATUS2 = (PAV_INIT_STATUS)((Object)status.get(n));
        if (status.containsKey(n)) {
            if (((PAV_INIT_STATUS)((Object)status.get(n))).equals((Object)PAV_INIT_STATUS.DESTROYED)) {
                return pAV_INIT_STATUS2;
            }
            if (((PAV_INIT_STATUS)((Object)status.get(n))).equals((Object)PAV_INIT_STATUS.INACTIVE) && !pAV_INIT_STATUS.equals((Object)PAV_INIT_STATUS.DESTROYED)) {
                return pAV_INIT_STATUS2;
            }
        }
        statusLock.lock();
        status.put(n, pAV_INIT_STATUS);
        initComplete.signalAll();
        statusLock.unlock();
        return pAV_INIT_STATUS2;
    }

    private static synchronized void destroyApplet(int n) {
        PluginAppletViewer.waitForAppletInit(((PluginAppletViewer)PluginAppletViewer.applets.get((Object)Integer.valueOf((int)n))).panel);
        PluginDebug.debug("DestroyApplet called for ", n);
        PAV_INIT_STATUS pAV_INIT_STATUS = PluginAppletViewer.updateStatus(n, PAV_INIT_STATUS.DESTROYED);
        if (pAV_INIT_STATUS.equals((Object)PAV_INIT_STATUS.DESTROYED)) {
            PluginDebug.debug(n, " already destroyed. Returning.");
            return;
        }
        PluginDebug.debug("Attempting to destroy frame ", n);
        final PluginAppletViewer pluginAppletViewer = (PluginAppletViewer)applets.get(n);
        if (pluginAppletViewer != null) {
            pluginAppletViewer.dispose();
            if (pluginAppletViewer.panel.applet == null) {
                PluginDebug.debug(n, " panel inactive. Returning.");
                return;
            }
            PluginDebug.debug("Attempting to destroy panel ", n);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    pluginAppletViewer.appletClose();
                }
            });
        }
        PluginDebug.debug(n, " destroyed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForAppletInit(NetxPanel netxPanel) {
        PluginDebug.debug("Waiting for applet init");
        panelLock.lock();
        try {
            for (long i = 180000000000L; !netxPanel.isInitialized() && i > 0L; i -= PluginAppletViewer.waitTillTimeout(panelLock, panelLive, i)) {
                PluginDebug.debug("Waiting for applet panel ", netxPanel, " to initialize...");
            }
        }
        finally {
            panelLock.unlock();
        }
        PluginDebug.debug("Applet panel ", netxPanel, " initialized");
    }

    private void resizeAppletPanel(final int n, final int n2) {
        PluginAppletViewer.waitForAppletInit(this.panel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PluginAppletViewer.this.panel.updateSizeInAtts(n2, n);
                PluginAppletViewer.this.setSize(n, n2);
                PluginAppletViewer.this.panel.setSize(1, 1);
                PluginAppletViewer.this.panel.validate();
                PluginAppletViewer.this.panel.setSize(n, n2);
                PluginAppletViewer.this.panel.validate();
                ((PluginAppletViewer)PluginAppletViewer.this).panel.applet.resize(n, n2);
                ((PluginAppletViewer)PluginAppletViewer.this).panel.applet.validate();
            }
        });
    }

    public void handleMessage(int n, String string) {
        if (string.startsWith("width")) {
            String[] stringArray = string.split(" ");
            final int n2 = Integer.parseInt(stringArray[1]);
            final int n3 = Integer.parseInt(stringArray[3]);
            Thread thread = new Thread("resizeAppletThread"){

                @Override
                public void run() {
                    PluginAppletViewer.this.resizeAppletPanel(n2, n3);
                }
            };
            thread.start();
        } else if (string.startsWith("GetJavaObject")) {
            PluginAppletViewer.waitForAppletInit(this.panel);
            PluginDebug.debug(this.panel, " -- ", this.panel.getApplet(), " -- initialized: ", this.panel.isInitialized());
            if (this.panel.getApplet() == null) {
                streamhandler.write("instance " + this.identifier + " reference " + -1 + " fatalError: " + "Initialization failed");
                streamhandler.write("context 0 reference " + n + " Error");
                return;
            }
            Applet applet = this.panel.getApplet();
            PluginDebug.debug("Looking for object ", applet, " panel is ", this.panel);
            AppletSecurityContextManager.getSecurityContext(0).store(applet);
            PluginDebug.debug("WRITING 1: ", "context 0 reference ", n, " GetJavaObject ", AppletSecurityContextManager.getSecurityContext(0).getIdentifier(applet));
            streamhandler.write("context 0 reference " + n + " GetJavaObject " + AppletSecurityContextManager.getSecurityContext(0).getIdentifier(applet));
            PluginDebug.debug("WRITING 1 DONE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioClip getAudioClip(URL uRL) {
        PluginAppletViewer.checkConnect(uRL);
        Map<URL, AudioClip> map = audioClips;
        synchronized (map) {
            AudioClip audioClip = audioClips.get(uRL);
            if (audioClip == null) {
                audioClip = new AppletAudioClip(uRL);
                audioClips.put(uRL, audioClip);
            }
            return audioClip;
        }
    }

    @Override
    public Image getImage(URL uRL) {
        return this.getCachedImage(uRL);
    }

    private Image getCachedImage(URL uRL) {
        return (Image)this.getCachedImageRef(uRL).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Ref getCachedImageRef(URL uRL) {
        PluginDebug.debug("getCachedImageRef() searching for ", uRL);
        try {
            Object object;
            Object object2;
            String string = uRL.toString();
            String string2 = this.panel.getCodeBase().toString();
            if (string.startsWith(string2)) {
                PluginDebug.debug("getCachedImageRef() got URL = ", uRL);
                PluginDebug.debug("getCachedImageRef() plugin codebase = ", string2);
                object2 = string.substring(string2.length());
                object = (JNLPClassLoader)this.panel.getAppletClassLoader();
                URL uRL2 = null;
                if (((JNLPClassLoader)object).resourceAvailableLocally((String)object2)) {
                    uRL = ((ClassLoader)object).getResource((String)object2);
                }
                uRL = uRL2 != null ? uRL2 : uRL;
            }
            PluginDebug.debug("getCachedImageRef() getting img from URL = ", uRL);
            object2 = imageRefs;
            synchronized (object2) {
                object = imageRefs.get(uRL);
                if (object == null) {
                    object = new AppletImageRef(uRL);
                    imageRefs.put(uRL, (AppletImageRef)object);
                }
                return object;
            }
        }
        catch (Exception exception) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Error occurred when trying to fetch image:");
            OutputController.getLogger().log(exception);
            return null;
        }
    }

    static void flushImageCache() {
        imageRefs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Applet getApplet(String string) {
        string = string.toLowerCase();
        SocketPermission socketPermission = new SocketPermission(this.panel.getCodeBase().getHost(), "connect");
        Vector<NetxPanel> vector = appletPanels;
        synchronized (vector) {
            Enumeration<NetxPanel> enumeration = appletPanels.elements();
            while (enumeration.hasMoreElements()) {
                SocketPermission socketPermission2;
                AppletPanel appletPanel = enumeration.nextElement();
                String string2 = appletPanel.getParameter("name");
                if (string2 != null) {
                    string2 = string2.toLowerCase();
                }
                if (!string.equals(string2) || !appletPanel.getDocumentBase().equals(this.panel.getDocumentBase()) || !socketPermission.implies(socketPermission2 = new SocketPermission(appletPanel.getCodeBase().getHost(), "connect"))) continue;
                return appletPanel.applet;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<Applet> getApplets() {
        Vector<Applet> vector = new Vector<Applet>();
        SocketPermission socketPermission = new SocketPermission(this.panel.getCodeBase().getHost(), "connect");
        Vector<NetxPanel> vector2 = appletPanels;
        synchronized (vector2) {
            Enumeration<NetxPanel> enumeration = appletPanels.elements();
            while (enumeration.hasMoreElements()) {
                SocketPermission socketPermission2;
                AppletPanel appletPanel = enumeration.nextElement();
                if (!appletPanel.getDocumentBase().equals(this.panel.getDocumentBase()) || !socketPermission.implies(socketPermission2 = new SocketPermission(appletPanel.getCodeBase().getHost(), "connect"))) continue;
                vector.addElement(appletPanel.applet);
            }
        }
        return vector.elements();
    }

    @Override
    public void showDocument(URL uRL) {
        PluginDebug.debug("Showing document...");
        this.showDocument(uRL, "_self");
    }

    @Override
    public void showDocument(URL uRL, String string) {
        if ("javascript".equals(uRL.getProtocol())) {
            String string2 = uRL.toString().substring("javascript:".length());
            PluginAppletViewer.eval(this.getWindow(), string2);
            return;
        }
        try {
            Long l = PluginAppletViewer.getRequestIdentifier();
            this.write("reference " + l + " LoadURL " + UrlUtil.encode(uRL.toString(), "UTF-8") + " " + string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void showStatus(String string) {
        try {
            string = string.replace("\n", " ");
            this.write("status " + string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getRequestIdentifier() {
        Object object = requestMutex;
        synchronized (object) {
            if (requestIdentityCounter == Long.MAX_VALUE) {
                requestIdentityCounter = 0L;
            }
            long l = requestIdentityCounter++;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWindow() {
        PluginDebug.debug("STARTING getWindow");
        Long l = PluginAppletViewer.getRequestIdentifier();
        PluginCallRequest pluginCallRequest = requestFactory.getPluginCallRequest("window", "instance " + this.identifier + " reference " + l + " " + "GetWindow", l);
        PluginDebug.debug("STARTING postCallRequest");
        streamhandler.postCallRequest(pluginCallRequest);
        PluginDebug.debug("STARTING postCallRequest done");
        streamhandler.write(pluginCallRequest.getMessage());
        try {
            PluginDebug.debug("wait request 1");
            PluginCallRequest pluginCallRequest2 = pluginCallRequest;
            synchronized (pluginCallRequest2) {
                PluginDebug.debug("wait request 2");
                while ((Long)pluginCallRequest.getObject() == 0L) {
                    pluginCallRequest.wait();
                }
                PluginDebug.debug("wait request 3");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted waiting for call request.", interruptedException);
        }
        PluginDebug.debug("STARTING getWindow DONE");
        return (Long)pluginCallRequest.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getMember(long l, String string) {
        AppletSecurityContextManager.getSecurityContext(0).store(string);
        int n = AppletSecurityContextManager.getSecurityContext(0).getIdentifier(string);
        Long l2 = PluginAppletViewer.getRequestIdentifier();
        PluginCallRequest pluginCallRequest = requestFactory.getPluginCallRequest("member", "instance 0 reference " + l2 + " GetMember " + l + " " + n, l2);
        streamhandler.postCallRequest(pluginCallRequest);
        streamhandler.write(pluginCallRequest.getMessage());
        try {
            PluginDebug.debug("wait getMEM request 1");
            PluginCallRequest pluginCallRequest2 = pluginCallRequest;
            synchronized (pluginCallRequest2) {
                PluginDebug.debug("wait getMEM request 2");
                while (!pluginCallRequest.isDone()) {
                    pluginCallRequest.wait();
                }
                PluginDebug.debug("wait getMEM request 3 GOT: ", pluginCallRequest.getObject().getClass());
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted waiting for call request.", interruptedException);
        }
        PluginDebug.debug(" getMember DONE");
        return pluginCallRequest.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMember(long l, String string, Object object) {
        PluginDebug.debug("Setting to class " + object.getClass() + ":" + object.getClass().isPrimitive());
        PluginAppletSecurityContext pluginAppletSecurityContext = AppletSecurityContextManager.getSecurityContext(0);
        pluginAppletSecurityContext.store(string);
        int n = pluginAppletSecurityContext.getIdentifier(string);
        Long l2 = PluginAppletViewer.getRequestIdentifier();
        String string2 = pluginAppletSecurityContext.toObjectIDString(object, object.getClass(), true);
        PluginCallRequest pluginCallRequest = requestFactory.getPluginCallRequest("void", "instance 0 reference " + l2 + " SetMember " + l + " " + n + " " + string2, l2);
        streamhandler.postCallRequest(pluginCallRequest);
        streamhandler.write(pluginCallRequest.getMessage());
        try {
            PluginDebug.debug("wait setMem request: ", pluginCallRequest.getMessage());
            PluginDebug.debug("wait setMem request 1");
            PluginCallRequest pluginCallRequest2 = pluginCallRequest;
            synchronized (pluginCallRequest2) {
                PluginDebug.debug("wait setMem request 2");
                while (!pluginCallRequest.isDone()) {
                    pluginCallRequest.wait();
                }
                PluginDebug.debug("wait setMem request 3");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted waiting for call request.", interruptedException);
        }
        PluginDebug.debug(" setMember DONE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSlot(long l, int n, Object object) {
        PluginAppletSecurityContext pluginAppletSecurityContext = AppletSecurityContextManager.getSecurityContext(0);
        pluginAppletSecurityContext.store(object);
        Long l2 = PluginAppletViewer.getRequestIdentifier();
        String string = pluginAppletSecurityContext.toObjectIDString(object, object.getClass(), true);
        PluginCallRequest pluginCallRequest = requestFactory.getPluginCallRequest("void", "instance 0 reference " + l2 + " SetSlot " + l + " " + n + " " + string, l2);
        streamhandler.postCallRequest(pluginCallRequest);
        streamhandler.write(pluginCallRequest.getMessage());
        try {
            PluginDebug.debug("wait setSlot request 1");
            PluginCallRequest pluginCallRequest2 = pluginCallRequest;
            synchronized (pluginCallRequest2) {
                PluginDebug.debug("wait setSlot request 2");
                while (!pluginCallRequest.isDone()) {
                    pluginCallRequest.wait();
                }
                PluginDebug.debug("wait setSlot request 3");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted waiting for call request.", interruptedException);
        }
        PluginDebug.debug(" setSlot DONE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getSlot(long l, int n) {
        Long l2 = PluginAppletViewer.getRequestIdentifier();
        PluginCallRequest pluginCallRequest = requestFactory.getPluginCallRequest("member", "instance 0 reference " + l2 + " GetSlot " + l + " " + n, l2);
        streamhandler.postCallRequest(pluginCallRequest);
        streamhandler.write(pluginCallRequest.getMessage());
        try {
            PluginDebug.debug("wait getSlot request 1");
            PluginCallRequest pluginCallRequest2 = pluginCallRequest;
            synchronized (pluginCallRequest2) {
                PluginDebug.debug("wait getSlot request 2");
                while (!pluginCallRequest.isDone()) {
                    pluginCallRequest.wait();
                }
                PluginDebug.debug("wait getSlot request 3");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted waiting for call request.", interruptedException);
        }
        PluginDebug.debug(" getSlot DONE");
        return pluginCallRequest.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object eval(long l, String string) {
        AppletSecurityContextManager.getSecurityContext(0).store(string);
        int n = AppletSecurityContextManager.getSecurityContext(0).getIdentifier(string);
        Long l2 = PluginAppletViewer.getRequestIdentifier();
        PluginCallRequest pluginCallRequest = requestFactory.getPluginCallRequest("member", "instance 0 reference " + l2 + " Eval " + l + " " + n, l2);
        streamhandler.postCallRequest(pluginCallRequest);
        streamhandler.write(pluginCallRequest.getMessage());
        try {
            PluginDebug.debug("wait eval request 1");
            PluginCallRequest pluginCallRequest2 = pluginCallRequest;
            synchronized (pluginCallRequest2) {
                PluginDebug.debug("wait eval request 2");
                while (!pluginCallRequest.isDone()) {
                    pluginCallRequest.wait();
                }
                PluginDebug.debug("wait eval request 3");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted waiting for call request.", interruptedException);
        }
        PluginDebug.debug(" getSlot DONE");
        return pluginCallRequest.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMember(long l, String string) {
        AppletSecurityContextManager.getSecurityContext(0).store(string);
        int n = AppletSecurityContextManager.getSecurityContext(0).getIdentifier(string);
        Long l2 = PluginAppletViewer.getRequestIdentifier();
        PluginCallRequest pluginCallRequest = requestFactory.getPluginCallRequest("void", "instance 0 reference " + l2 + " RemoveMember " + l + " " + n, l2);
        streamhandler.postCallRequest(pluginCallRequest);
        streamhandler.write(pluginCallRequest.getMessage());
        try {
            PluginDebug.debug("wait removeMember request 1");
            PluginCallRequest pluginCallRequest2 = pluginCallRequest;
            synchronized (pluginCallRequest2) {
                PluginDebug.debug("wait removeMember request 2");
                while (!pluginCallRequest.isDone()) {
                    pluginCallRequest.wait();
                }
                PluginDebug.debug("wait removeMember request 3");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted waiting for call request.", interruptedException);
        }
        PluginDebug.debug(" RemoveMember DONE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object call(long l, String string, Object[] objectArray) {
        AppletSecurityContextManager.getSecurityContext(0).store(string);
        int n = AppletSecurityContextManager.getSecurityContext(0).getIdentifier(string);
        Long l2 = PluginAppletViewer.getRequestIdentifier();
        String string2 = "";
        for (Object object : objectArray) {
            AppletSecurityContextManager.getSecurityContext(0).store(object);
            string2 = string2 + AppletSecurityContextManager.getSecurityContext(0).getIdentifier(object) + " ";
        }
        string2 = string2.trim();
        PluginCallRequest pluginCallRequest = requestFactory.getPluginCallRequest("member", "instance 0 reference " + l2 + " Call " + l + " " + n + " " + string2, l2);
        streamhandler.postCallRequest(pluginCallRequest);
        streamhandler.write(pluginCallRequest.getMessage());
        try {
            PluginDebug.debug("wait call request 1");
            Object object = pluginCallRequest;
            synchronized (object) {
                PluginDebug.debug("wait call request 2");
                while (!pluginCallRequest.isDone()) {
                    pluginCallRequest.wait();
                }
                PluginDebug.debug("wait call request 3");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted waiting for call request.", interruptedException);
        }
        PluginDebug.debug(" Call DONE");
        return pluginCallRequest.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object requestPluginCookieInfo(URI uRI) {
        PluginCallRequest pluginCallRequest;
        Object object;
        Long l = PluginAppletViewer.getRequestIdentifier();
        try {
            object = UrlUtil.encode(uRI.toString(), "UTF-8");
            pluginCallRequest = requestFactory.getPluginCallRequest("cookieinfo", "plugin PluginCookieInfo reference " + l + " " + (String)object, l);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, unsupportedEncodingException);
            return null;
        }
        PluginMessageConsumer.registerPriorityWait(l);
        streamhandler.postCallRequest(pluginCallRequest);
        streamhandler.write(pluginCallRequest.getMessage());
        try {
            PluginDebug.debug("wait cookieinfo request 1");
            object = pluginCallRequest;
            synchronized (object) {
                PluginDebug.debug("wait cookieinfo request 2");
                while (!pluginCallRequest.isDone()) {
                    pluginCallRequest.wait();
                }
                PluginDebug.debug("wait cookieinfo request 3");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted waiting for cookieinfo request.", interruptedException);
        }
        PluginDebug.debug(" Cookieinfo DONE");
        return pluginCallRequest.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object requestPluginProxyInfo(String string) {
        Long l = PluginAppletViewer.getRequestIdentifier();
        PluginCallRequest pluginCallRequest = requestFactory.getPluginCallRequest("proxyinfo", "plugin PluginProxyInfo reference " + l + " " + string, l);
        PluginMessageConsumer.registerPriorityWait(l);
        streamhandler.postCallRequest(pluginCallRequest);
        streamhandler.write(pluginCallRequest.getMessage());
        try {
            PluginDebug.debug("wait call request 1");
            PluginCallRequest pluginCallRequest2 = pluginCallRequest;
            synchronized (pluginCallRequest2) {
                PluginDebug.debug("wait call request 2");
                while (!pluginCallRequest.isDone()) {
                    pluginCallRequest.wait();
                }
                PluginDebug.debug("wait call request 3");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted waiting for call request.", interruptedException);
        }
        PluginDebug.debug(" Call DONE");
        return pluginCallRequest.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void JavaScriptFinalize(long l) {
        Long l2 = PluginAppletViewer.getRequestIdentifier();
        PluginCallRequest pluginCallRequest = requestFactory.getPluginCallRequest("void", "instance 0 reference " + l2 + " Finalize " + l, l2);
        streamhandler.postCallRequest(pluginCallRequest);
        streamhandler.write(pluginCallRequest.getMessage());
        try {
            PluginDebug.debug("wait finalize request 1");
            PluginCallRequest pluginCallRequest2 = pluginCallRequest;
            synchronized (pluginCallRequest2) {
                PluginDebug.debug("wait finalize request 2");
                while (!pluginCallRequest.isDone()) {
                    pluginCallRequest.wait();
                }
                PluginDebug.debug("wait finalize request 3");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted waiting for call request.", interruptedException);
        }
        PluginDebug.debug(" finalize DONE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String javascriptToString(long l) {
        Long l2 = PluginAppletViewer.getRequestIdentifier();
        PluginCallRequest pluginCallRequest = requestFactory.getPluginCallRequest("member", "instance 0 reference " + l2 + " ToString " + l, l2);
        streamhandler.postCallRequest(pluginCallRequest);
        streamhandler.write(pluginCallRequest.getMessage());
        PluginDebug.debug("wait ToString request 1");
        PluginCallRequest pluginCallRequest2 = pluginCallRequest;
        synchronized (pluginCallRequest2) {
            PluginDebug.debug("wait ToString request 2");
            PluginAppletViewer.waitForRequestCompletion(pluginCallRequest);
            PluginDebug.debug("wait ToString request 3");
        }
        PluginDebug.debug(" ToString DONE");
        return (String)pluginCallRequest.getObject();
    }

    private void write(String string) throws IOException {
        PluginDebug.debug("WRITING 2: ", "instance ", this.identifier, " " + string);
        streamhandler.write("instance " + this.identifier + " " + string);
        PluginDebug.debug("WRITING 2 DONE");
    }

    @Override
    public void setStream(String string, InputStream inputStream) throws IOException {
    }

    @Override
    public InputStream getStream(String string) {
        return null;
    }

    @Override
    public Iterator<String> getStreamKeys() {
        return null;
    }

    public void updateAtts() {
        Dimension dimension = this.panel.getSize();
        Insets insets = this.panel.getInsets();
        int n = dimension.width - (insets.left + insets.right);
        int n2 = dimension.height - (insets.top + insets.bottom);
        this.panel.updateSizeInAtts(n2, n);
    }

    void appletRestart() {
        this.panel.sendEvent(4);
        this.panel.sendEvent(5);
        this.panel.sendEvent(2);
        this.panel.sendEvent(3);
    }

    void appletReload() {
        this.panel.sendEvent(4);
        this.panel.sendEvent(5);
        this.panel.sendEvent(0);
        AppletPanel.flushClassLoader(this.panel.getClassLoaderCacheKey());
        try {
            this.panel.joinAppletThread();
            this.panel.release();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ((AppletPanel)PluginAppletViewer.this.panel).createAppletThread();
                return null;
            }
        });
        this.panel.sendEvent(1);
        this.panel.sendEvent(2);
        this.panel.sendEvent(3);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        return 1;
    }

    void appletStart() {
        this.panel.sendEvent(3);
    }

    void appletStop() {
        this.panel.sendEvent(4);
    }

    private void appletShutdown(AppletPanel appletPanel) {
        appletPanel.sendEvent(4);
        appletPanel.sendEvent(5);
        appletPanel.sendEvent(0);
        appletPanel.sendEvent(6);
    }

    void appletClose() {
        final NetxPanel netxPanel = this.panel;
        new Thread(new Runnable(){

            @Override
            public void run() {
                ClassLoader classLoader = netxPanel.applet.getClass().getClassLoader();
                if (classLoader instanceof JNLPClassLoader.CodeBaseClassLoader) {
                    classLoader = ((JNLPClassLoader.CodeBaseClassLoader)classLoader).getParentJNLPClassLoader();
                }
                PluginAppletViewer.this.appletShutdown(netxPanel);
                appletPanels.removeElement(netxPanel);
                ((JNLPClassLoader)classLoader).decrementLoaderUseCount();
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            PluginAppletViewer.this.dispose();
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (PluginAppletViewer.countApplets() == 0) {
                    PluginAppletViewer.this.appletSystemExit();
                }
                PluginAppletViewer.updateStatus(PluginAppletViewer.this.identifier, PAV_INIT_STATUS.DESTROYED);
            }
        }).start();
    }

    private void appletSystemExit() {
    }

    public static int countApplets() {
        return appletPanels.size();
    }

    private static void checkConnect(URL uRL) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                Permission permission = uRL.openConnection().getPermission();
                if (permission != null) {
                    securityManager.checkPermission(permission);
                } else {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
            }
            catch (IOException iOException) {
                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.bufFrameImg == null || this.bufFrameImgGraphics == null) {
            this.bufFrameImg = this.createImage(Math.max(1, this.getWidth()), Math.max(1, this.getHeight()));
            this.bufFrameImgGraphics = this.bufFrameImg.getGraphics();
        }
        for (Component component : this.getComponents()) {
            component.paint(this.bufFrameImgGraphics);
        }
        graphics.drawImage(this.bufFrameImg, 0, 0, this);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public static long waitTillTimeout(ReentrantLock reentrantLock, Condition condition, long l) {
        if (reentrantLock == null) {
            return 0L;
        }
        assert (reentrantLock.isHeldByCurrentThread());
        long l2 = 0L;
        try {
            l2 = System.nanoTime();
            condition.await(l, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return System.nanoTime() - l2;
    }

    static {
        status = new ConcurrentHashMap<Integer, PAV_INIT_STATUS>();
        statusLock = new ReentrantLock();
        initComplete = statusLock.newCondition();
        requestMutex = new Object();
        requestIdentityCounter = 0L;
        REQUEST_TIMEOUT = 60000L;
        audioClips = new HashMap<URL, AudioClip>();
        imageRefs = new HashMap<URL, AppletImageRef>();
        appletPanels = new Vector();
        systemParam = new Hashtable();
        systemParam.put("codebase", "codebase");
        systemParam.put("code", "code");
        systemParam.put("alt", "alt");
        systemParam.put("width", "width");
        systemParam.put("height", "height");
        systemParam.put("align", "align");
        systemParam.put("vspace", "vspace");
        systemParam.put("hspace", "hspace");
    }

    private class SplashCreator
    implements Runnable {
        private final AppletPanel fPanel;

        public SplashCreator(AppletPanel appletPanel) {
            this.fPanel = appletPanel;
        }

        @Override
        public void run() {
            PluginAppletViewer.this.add("Center", this.fPanel);
            this.fPanel.setVisible(false);
            PluginAppletViewer.this.splashPanel = SplashUtils.getSplashScreen(this.fPanel.getWidth(), this.fPanel.getHeight());
            if (PluginAppletViewer.this.splashPanel != null) {
                PluginAppletViewer.this.splashPanel.startAnimation();
                PluginDebug.debug("Added splash " + PluginAppletViewer.this.splashPanel);
                PluginAppletViewer.this.add("Center", PluginAppletViewer.this.splashPanel.getSplashComponent());
            }
            PluginAppletViewer.this.pack();
        }
    }

    private static class AppletEventListener
    implements AppletListener {
        final Frame frame;
        final PluginAppletViewer appletViewer;

        public AppletEventListener(Frame frame, PluginAppletViewer pluginAppletViewer) {
            this.frame = frame;
            this.appletViewer = pluginAppletViewer;
        }

        @Override
        public void appletStateChanged(AppletEvent appletEvent) {
            AppletPanel appletPanel = (AppletPanel)appletEvent.getSource();
            panelLock.lock();
            panelLive.signalAll();
            panelLock.unlock();
            switch (appletEvent.getID()) {
                case 51234: {
                    if (appletPanel == null) break;
                    this.appletViewer.setSize(this.appletViewer.getPreferredSize());
                    this.appletViewer.validate();
                    break;
                }
                case 51236: {
                    Applet applet = appletPanel.getApplet();
                    if (applet != null) {
                        AppletPanel.changeFrameAppContext(this.frame, SunToolkit.targetToAppContext(applet));
                    } else {
                        AppletPanel.changeFrameAppContext(this.frame, AppContext.getAppContext());
                    }
                    PluginAppletViewer.updateStatus(this.appletViewer.identifier, PAV_INIT_STATUS.INIT_COMPLETE);
                    break;
                }
                case 3: {
                    if (appletPanel.status == 2 || appletPanel.status == 4) break;
                    String string = "Applet started, but but reached invalid state";
                    PluginDebug.debug(string);
                    SplashErrorPanel splashErrorPanel = SplashUtils.getErrorSplashScreen(this.appletViewer.panel.getWidth(), this.appletViewer.panel.getHeight(), new Exception(string));
                    this.appletViewer.replaceSplash(splashErrorPanel);
                    break;
                }
                case 7: {
                    String string = "Undefined error causing applet not to staart appeared";
                    PluginDebug.debug(string);
                    SplashErrorPanel splashErrorPanel = SplashUtils.getErrorSplashScreen(this.appletViewer.panel.getWidth(), this.appletViewer.panel.getHeight(), new Exception(string));
                    this.appletViewer.replaceSplash(splashErrorPanel);
                    break;
                }
            }
        }
    }

    private static enum PAV_INIT_STATUS {
        PRE_INIT,
        INIT_COMPLETE,
        REFRAME_COMPLETE,
        INACTIVE,
        DESTROYED;

    }
}

