/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import sun.applet.PluginDebug;

public class MethodOverloadResolver {
    static final int NUMERIC_SAME_COST = 1;
    static final int NULL_TO_OBJECT_COST = 2;
    static final int CLASS_SAME_COST = 3;
    static final int NUMERIC_CAST_COST = 4;
    static final int NUMERIC_BOOLEAN_COST = 5;
    static final int STRING_NUMERIC_CAST_COST = 5;
    static final int CLASS_SUPERCLASS_COST = 6;
    static final int CLASS_STRING_COST = 7;
    static final int ARRAY_CAST_COST = 8;

    public static ResolvedMethod getBestMatchMethod(Class<?> clazz, String string, Object[] objectArray) {
        AccessibleObject[] accessibleObjectArray = MethodOverloadResolver.getMatchingMethods(clazz, string, objectArray.length);
        if (PluginDebug.DEBUG) {
            PluginDebug.debug("getMatchingMethod called with: " + Arrays.toString(objectArray));
        }
        return MethodOverloadResolver.getBestOverloadMatch(clazz, objectArray, accessibleObjectArray);
    }

    public static ResolvedMethod getBestMatchConstructor(Class<?> clazz, Object[] objectArray) {
        AccessibleObject[] accessibleObjectArray = MethodOverloadResolver.getMatchingConstructors(clazz, objectArray.length);
        if (PluginDebug.DEBUG) {
            PluginDebug.debug("getMatchingConstructor called with: " + Arrays.toString(objectArray));
        }
        return MethodOverloadResolver.getBestOverloadMatch(clazz, objectArray, accessibleObjectArray);
    }

    static ResolvedMethod getBestOverloadMatch(Class<?> clazz, Object[] objectArray, AccessibleObject[] accessibleObjectArray) {
        int n = Integer.MAX_VALUE;
        AccessibleObject accessibleObject = null;
        Object[] objectArray2 = null;
        boolean bl = false;
        block0: for (AccessibleObject accessibleObject2 : accessibleObjectArray) {
            int n2 = 0;
            Class<?>[] classArray = MethodOverloadResolver.getParameterTypesFor(accessibleObject2);
            Object[] objectArray3 = new Object[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                Object object;
                Class<?> clazz2 = classArray[i];
                Object object2 = objectArray[i];
                Class<?> clazz3 = object2 != null ? object2.getClass() : null;
                WeightedCast weightedCast = MethodOverloadResolver.getCostAndCastedObject(object2, clazz2);
                if (weightedCast == null) continue block0;
                n2 += weightedCast.getCost();
                objectArray3[i] = object = clazz2.isPrimitive() ? weightedCast.getCastedObject() : clazz2.cast(weightedCast.getCastedObject());
                if (!PluginDebug.DEBUG) continue;
                Class<?> clazz4 = object == null ? null : object.getClass();
                boolean bl2 = object == null ? false : object.getClass().isPrimitive();
                PluginDebug.debug("Param " + i + " of method " + accessibleObject2 + " has cost " + weightedCast.getCost() + " original param type " + clazz3 + " casted to " + clazz4 + " isPrimitive=" + bl2 + " value " + object);
            }
            if (n2 > n) continue;
            if (n2 < n || MethodOverloadResolver.argumentsAreSubclassesOf(objectArray3, objectArray2)) {
                n = n2;
                objectArray2 = objectArray3;
                accessibleObject = accessibleObject2;
                bl = false;
                continue;
            }
            bl = true;
        }
        if (bl) {
            PluginDebug.debug("*** Warning: Ambiguous overload of ", clazz.getClass(), "#", accessibleObject, "!");
        }
        if (accessibleObject == null) {
            return null;
        }
        return new ResolvedMethod(n, accessibleObject, objectArray2);
    }

    public static WeightedCast getCostAndCastedObject(Object object, Class<?> clazz) {
        boolean bl;
        boolean bl2;
        Class<?> clazz2 = object != null ? object.getClass() : null;
        boolean bl3 = bl2 = clazz2 != null && clazz2.isArray();
        if (bl2) {
            if (clazz.isArray()) {
                return MethodOverloadResolver.getArrayToArrayCastWeightedCost(object, clazz);
            }
            if (clazz != String.class && clazz != Object.class) {
                return null;
            }
            if (clazz.equals(String.class)) {
                return new WeightedCast(8, MethodOverloadResolver.arrayToJavascriptStyleString(object));
            }
        }
        if (clazz2 == null) {
            if (!clazz.isPrimitive()) {
                return new WeightedCast(2, null);
            }
            return null;
        }
        if (clazz.isPrimitive() && clazz == MethodOverloadResolver.getPrimitiveType(object.getClass())) {
            return new WeightedCast(1, object);
        }
        if (clazz2 == clazz) {
            return new WeightedCast(3, object);
        }
        boolean bl4 = bl = MethodOverloadResolver.getPrimitiveType(object.getClass()) != null;
        if (bl && clazz.isPrimitive()) {
            Object object2;
            double d = object.equals(Boolean.TRUE) ? 1.0 : (object.equals(Boolean.FALSE) ? 0.0 : (object instanceof Character ? (double)((Character)object).charValue() : ((Number)object).doubleValue()));
            int n = 4;
            if (clazz.equals(Boolean.TYPE)) {
                object2 = d != 0.0 && !Double.isNaN(d);
                if (object.getClass() != Boolean.class) {
                    n = 5;
                }
            } else {
                object2 = MethodOverloadResolver.toBoxedPrimitiveType(d, clazz);
            }
            return new WeightedCast(n, object2);
        }
        if (MethodOverloadResolver.isNumericString(object) && clazz.isPrimitive()) {
            Object object3 = clazz.equals(Character.TYPE) ? Character.valueOf((char)Short.decode((String)object).shortValue()) : MethodOverloadResolver.stringAsPrimitiveType((String)object, clazz);
            return new WeightedCast(5, object3);
        }
        if (object instanceof String && (clazz == Boolean.class || clazz == Boolean.TYPE)) {
            return new WeightedCast(5, !object.equals(""));
        }
        if (clazz.isAssignableFrom(clazz2)) {
            return new WeightedCast(6, clazz.cast(object));
        }
        if (clazz.equals(String.class)) {
            return new WeightedCast(7, object.toString());
        }
        return null;
    }

    private static WeightedCast getArrayToArrayCastWeightedCost(Object object, Class<?> clazz) {
        int n = Array.getLength(object);
        Class<?> clazz2 = clazz.getComponentType();
        Object object2 = Array.newInstance(clazz2, n);
        for (int i = 0; i < n; ++i) {
            WeightedCast weightedCast;
            Object object3 = Array.get(object, i);
            if (object3 == null && clazz2.isPrimitive()) {
                object3 = 0;
            }
            if ((weightedCast = MethodOverloadResolver.getCostAndCastedObject(object3, clazz.getComponentType())) == null) {
                return null;
            }
            Array.set(object2, i, weightedCast.getCastedObject());
        }
        return new WeightedCast(8, object2);
    }

    private static Method[] getMatchingMethods(Class<?> clazz, String string, int n) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(string) || method.getParameterTypes().length != n) continue;
            arrayList.add(method);
        }
        return arrayList.toArray(new Method[0]);
    }

    private static Constructor<?>[] getMatchingConstructors(Class<?> clazz, int n) {
        ArrayList arrayList = new ArrayList();
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != n) continue;
            arrayList.add(constructor);
        }
        return arrayList.toArray(new Constructor[0]);
    }

    private static Class<?> getPrimitiveType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        return null;
    }

    private static boolean isNumericString(Object object) {
        if (!(object instanceof String)) {
            return false;
        }
        try {
            Long.parseLong((String)object);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Float.parseFloat((String)object);
                return true;
            }
            catch (NumberFormatException numberFormatException2) {
                return false;
            }
        }
    }

    private static Object toBoxedPrimitiveType(double d, Class<?> clazz) {
        Class<?> clazz2 = MethodOverloadResolver.getPrimitiveType(clazz);
        if (clazz2 == Integer.TYPE) {
            return (int)d;
        }
        if (clazz2 == Long.TYPE) {
            return (long)d;
        }
        if (clazz2 == Short.TYPE) {
            return (short)d;
        }
        if (clazz2 == Float.TYPE) {
            return Float.valueOf((float)d);
        }
        if (clazz2 == Double.TYPE) {
            return d;
        }
        if (clazz2 == Byte.TYPE) {
            return (byte)d;
        }
        if (clazz2 == Character.TYPE) {
            return Character.valueOf((char)d);
        }
        return d;
    }

    private static Object stringAsPrimitiveType(String string, Class<?> clazz) throws NumberFormatException {
        double d = Double.parseDouble(string);
        return MethodOverloadResolver.toBoxedPrimitiveType(d, clazz);
    }

    private static boolean argumentsAreSubclassesOf(Object[] objectArray, Object[] objectArray2) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray2[i].getClass().isAssignableFrom(objectArray[i].getClass())) continue;
            return false;
        }
        return true;
    }

    static Class<?>[] getParameterTypesFor(AccessibleObject accessibleObject) {
        if (accessibleObject instanceof Method) {
            return ((Method)accessibleObject).getParameterTypes();
        }
        return ((Constructor)accessibleObject).getParameterTypes();
    }

    private static String arrayToJavascriptStyleString(Object object) {
        int n = Array.getLength(object);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            if (object2 != null) {
                if (object2.getClass().isArray()) {
                    stringBuilder.append(MethodOverloadResolver.arrayToJavascriptStyleString(object2));
                } else {
                    stringBuilder.append(object2);
                }
            }
            stringBuilder.append(',');
        }
        if (n > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    static class WeightedCast {
        private int cost;
        private Object castedObject;

        public WeightedCast(int n, Object object) {
            this.cost = n;
            this.castedObject = object;
        }

        public Object getCastedObject() {
            return this.castedObject;
        }

        public int getCost() {
            return this.cost;
        }
    }

    static class ResolvedMethod {
        private AccessibleObject method;
        private Object[] castedParameters;
        private int cost;

        public ResolvedMethod(int n, AccessibleObject accessibleObject, Object[] objectArray) {
            this.cost = n;
            this.method = accessibleObject;
            this.castedParameters = objectArray;
        }

        AccessibleObject getAccessibleObject() {
            return this.method;
        }

        public Method getMethod() {
            return (Method)this.method;
        }

        public Constructor<?> getConstructor() {
            return (Constructor)this.method;
        }

        public Object[] getCastedParameters() {
            return this.castedParameters;
        }

        public int getCost() {
            return this.cost;
        }
    }
}

