/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.logging;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.logging.FileLog;
import net.sourceforge.jnlp.util.logging.JavaConsole;
import net.sourceforge.jnlp.util.logging.LogConfig;
import net.sourceforge.jnlp.util.logging.PrintStreamLogger;
import net.sourceforge.jnlp.util.logging.SingleStreamLogger;
import net.sourceforge.jnlp.util.logging.UnixSystemLog;
import net.sourceforge.jnlp.util.logging.WinSystemLog;
import net.sourceforge.jnlp.util.logging.headers.Header;
import net.sourceforge.jnlp.util.logging.headers.JavaMessage;
import net.sourceforge.jnlp.util.logging.headers.MessageWithHeader;

public class OutputController {
    private static final String NULL_OBJECT = "Trying to log null object";
    private PrintStreamLogger outLog;
    private PrintStreamLogger errLog;
    private List<MessageWithHeader> messageQue = new LinkedList<MessageWithHeader>();
    private MessageQueConsumer messageQueConsumer = new MessageQueConsumer();
    Thread consumerThread;

    public synchronized void flush() {
        while (!this.messageQue.isEmpty()) {
            this.consume();
        }
    }

    public void close() {
        this.flush();
        if (LogConfig.getLogConfig().isLogToFile()) {
            this.getFileLog().close();
        }
    }

    private void consume() {
        MessageWithHeader messageWithHeader = this.messageQue.get(0);
        this.messageQue.remove(0);
        if (LogConfig.getLogConfig().isLogToConsole()) {
            JavaConsole.getConsole().addMessage(messageWithHeader);
        }
        if (!(JNLPRuntime.isDebug() || messageWithHeader.getHeader().level != Level.MESSAGE_DEBUG && messageWithHeader.getHeader().level != Level.WARNING_DEBUG && messageWithHeader.getHeader().level != Level.ERROR_DEBUG)) {
            return;
        }
        String string = messageWithHeader.getMessage();
        if (LogConfig.getLogConfig().isEnableHeaders()) {
            string = string.contains("\n") ? messageWithHeader.getHeader().toString() + "\n" + string : messageWithHeader.getHeader().toString() + " " + string;
        }
        if (LogConfig.getLogConfig().isLogToStreams()) {
            if (messageWithHeader.getHeader().level.isOutput()) {
                this.outLog.log(string);
            }
            if (messageWithHeader.getHeader().level.isError()) {
                this.errLog.log(string);
            }
        }
        if (LogConfig.getLogConfig().isLogToFile()) {
            this.getFileLog().log(string);
        }
        if (LogConfig.getLogConfig().isLogToSysLog()) {
            this.getSystemLog().log(string);
        }
    }

    private OutputController() {
        this(System.out, System.err);
    }

    public static OutputController getLogger() {
        return OutputControllerHolder.INSTANCE;
    }

    public OutputController(PrintStream printStream, PrintStream printStream2) {
        if (printStream == null || printStream2 == null) {
            throw new IllegalArgumentException("No stream can be null");
        }
        this.outLog = new PrintStreamLogger(printStream);
        this.errLog = new PrintStreamLogger(printStream2);
        this.consumerThread = new Thread((Runnable)this.messageQueConsumer, "Output controller consumer daemon");
        this.consumerThread.setDaemon(true);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                OutputController.this.flush();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startConsumer() {
        this.consumerThread.start();
        OutputController outputController = this;
        synchronized (outputController) {
            this.notifyAll();
        }
    }

    public PrintStream getOut() {
        this.flush();
        return this.outLog.getStream();
    }

    public PrintStream getErr() {
        this.flush();
        return this.errLog.getStream();
    }

    public void setOut(PrintStream printStream) {
        this.flush();
        this.outLog.setStream(printStream);
    }

    public void setErr(PrintStream printStream) {
        this.flush();
        this.errLog.setStream(printStream);
    }

    public static String exceptionToString(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        String string = "Error during processing of exception";
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            string = stringWriter.toString();
            printWriter.close();
            stringWriter.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return string;
    }

    public void log(Level level, String string) {
        this.log(level, (Object)string);
    }

    public void log(Level level, Throwable throwable) {
        this.log(level, (Object)throwable);
    }

    public void log(String string) {
        this.log(Level.MESSAGE_DEBUG, (Object)string);
    }

    public void log(Throwable throwable) {
        this.log(Level.ERROR_DEBUG, (Object)throwable);
    }

    private void log(Level level, Object object) {
        String string = "";
        string = object == null ? NULL_OBJECT : (object instanceof Throwable ? OutputController.exceptionToString((Throwable)object) : object.toString());
        this.log(new JavaMessage(new Header(level, false), string));
    }

    synchronized void log(MessageWithHeader messageWithHeader) {
        this.messageQue.add(messageWithHeader);
        this.notifyAll();
    }

    private FileLog getFileLog() {
        return FileLogHolder.INSTANCE;
    }

    private SingleStreamLogger getSystemLog() {
        return SystemLogHolder.INSTANCE;
    }

    public void printErrorLn(String string) {
        this.getErr().println(string);
    }

    public void printOutLn(String string) {
        this.getOut().println(string);
    }

    public void printWarningLn(String string) {
        this.printOutLn(string);
        this.printErrorLn(string);
    }

    public void printError(String string) {
        this.getErr().print(string);
    }

    public void printOut(String string) {
        this.getOut().print(string);
    }

    public void printWarning(String string) {
        this.printOut(string);
        this.printError(string);
    }

    void setErrLog(PrintStreamLogger printStreamLogger) {
        this.errLog = printStreamLogger;
    }

    void setFileLog(FileLog fileLog) {
        FileLogHolder.INSTANCE = fileLog;
    }

    void setOutLog(PrintStreamLogger printStreamLogger) {
        this.outLog = printStreamLogger;
    }

    void setSysLog(SingleStreamLogger singleStreamLogger) {
        SystemLogHolder.INSTANCE = singleStreamLogger;
    }

    private static class SystemLogHolder {
        private static volatile SingleStreamLogger INSTANCE = SystemLogHolder.initSystemLogger();

        private SystemLogHolder() {
        }

        private static SingleStreamLogger initSystemLogger() {
            if (JNLPRuntime.isWindows()) {
                return new WinSystemLog();
            }
            return new UnixSystemLog();
        }
    }

    private static class FileLogHolder {
        private static volatile FileLog INSTANCE = new FileLog();

        private FileLogHolder() {
        }
    }

    private static class OutputControllerHolder {
        private static final OutputController INSTANCE = new OutputController();

        private OutputControllerHolder() {
        }
    }

    private class MessageQueConsumer
    implements Runnable {
        private MessageQueConsumer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        OutputController outputController = OutputController.this;
                        synchronized (outputController) {
                            OutputController.this.wait(1000L);
                            if (OutputController.this != null && !OutputController.this.messageQue.isEmpty()) {
                                OutputController.this.flush();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    OutputController.getLogger().log(throwable);
                    continue;
                }
                break;
            }
        }
    }

    public static enum Level {
        MESSAGE_ALL,
        MESSAGE_DEBUG,
        WARNING_ALL,
        WARNING_DEBUG,
        ERROR_ALL,
        ERROR_DEBUG;


        public boolean isOutput() {
            return this == MESSAGE_ALL || this == MESSAGE_DEBUG || this == WARNING_ALL || this == WARNING_DEBUG;
        }

        public boolean isError() {
            return this == ERROR_ALL || this == ERROR_DEBUG || this == WARNING_ALL || this == WARNING_DEBUG;
        }

        public boolean isWarning() {
            return this == WARNING_ALL || this == WARNING_DEBUG;
        }

        public boolean isDebug() {
            return this == ERROR_DEBUG || this == MESSAGE_DEBUG || this == WARNING_DEBUG;
        }

        public boolean isInfo() {
            return this == ERROR_ALL || this == WARNING_ALL || this == MESSAGE_ALL;
        }
    }
}

