/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.logging;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatter;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.ImageResources;
import net.sourceforge.jnlp.util.logging.ConsoleOutputPane;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.jnlp.util.logging.headers.MessageWithHeader;
import net.sourceforge.jnlp.util.logging.headers.ObservableMessagesProvider;
import net.sourceforge.jnlp.util.logging.headers.PluginMessage;

public class JavaConsole
implements ObservableMessagesProvider {
    private List<MessageWithHeader> rawData = Collections.synchronizedList(new ArrayList());
    private List<ConsoleOutputPane> outputs = new ArrayList<ConsoleOutputPane>();
    private static JavaConsole console;
    private Dimension lastSize;
    private JDialog consoleWindow;
    private JPanel contentPanel;
    private JPanel outputsPanel;
    private ClassLoaderInfoProvider classLoaderInfoProvider;
    private JSpinner numberOfOutputs;
    private PublicObservable observable = new PublicObservable();
    private boolean initialized = false;

    private void refreshOutputs() {
        this.refreshOutputs(this.outputsPanel, (Integer)this.numberOfOutputs.getValue());
    }

    private void refreshOutputs(JPanel jPanel, int n) {
        JComponent jComponent;
        jPanel.removeAll();
        while (this.outputs.size() > n) {
            this.getObservable().deleteObserver(this.outputs.get(this.outputs.size() - 1));
            this.outputs.remove(this.outputs.size() - 1);
        }
        while (this.outputs.size() < n) {
            jComponent = new ConsoleOutputPane(this);
            this.observable.addObserver((Observer)((Object)jComponent));
            this.outputs.add((ConsoleOutputPane)jComponent);
        }
        if (n == 0) {
            jPanel.add(new JPanel());
        } else if (this.outputs.size() == 1) {
            jPanel.add(this.outputs.get(0));
        } else {
            jComponent = new JSplitPane(1, this.outputs.get(this.outputs.size() - 2), this.outputs.get(this.outputs.size() - 1));
            ((JSplitPane)jComponent).setDividerLocation(0.5);
            ((JSplitPane)jComponent).setResizeWeight(0.5);
            for (int i = this.outputs.size() - 3; i >= 0; --i) {
                JSplitPane jSplitPane = new JSplitPane(1, this.outputs.get(i), jComponent);
                jSplitPane.setDividerLocation(0.5);
                jSplitPane.setResizeWeight(0.5);
                jComponent = jSplitPane;
            }
            jPanel.add(jComponent);
        }
        jPanel.validate();
    }

    public static JavaConsole getConsole() {
        return JavaConsoleHolder.INSTANCE;
    }

    public static boolean isEnabled() {
        return JavaConsole.isEnabled(JNLPRuntime.getConfiguration());
    }

    public static boolean isEnabled(DeploymentConfiguration deploymentConfiguration) {
        return !"DISABLE".equals(deploymentConfiguration.getProperty("deployment.console.startup.mode")) && !JNLPRuntime.isHeadless();
    }

    public static boolean canShowOnStartup(boolean bl) {
        return JavaConsole.canShowOnStartup(bl, JNLPRuntime.getConfiguration());
    }

    public static boolean canShowOnStartup(boolean bl, DeploymentConfiguration deploymentConfiguration) {
        if (!JavaConsole.isEnabled(deploymentConfiguration)) {
            return false;
        }
        return "SHOW".equals(deploymentConfiguration.getProperty("deployment.console.startup.mode")) || "SHOW_PLUGIN_ONLY".equals(deploymentConfiguration.getProperty("deployment.console.startup.mode")) && !bl || "SHOW_JAVAWS_ONLY".equals(deploymentConfiguration.getProperty("deployment.console.startup.mode")) && bl;
    }

    private void initializeWindow() {
        if (!this.initialized) {
            this.initialize();
        }
        this.initializeWindow(this.lastSize, this.contentPanel);
    }

    private void initializeWindow(Dimension dimension, JPanel jPanel) {
        this.consoleWindow = new JDialog((Frame)null, Translator.R("DPJavaConsole"));
        this.consoleWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                JavaConsole.this.lastSize = JavaConsole.this.consoleWindow.getSize();
            }
        });
        this.consoleWindow.setIconImages(ImageResources.INSTANCE.getApplicationImages());
        this.refreshOutputs();
        this.consoleWindow.add(jPanel);
        this.consoleWindow.setDefaultCloseOperation(2);
        this.consoleWindow.pack();
        if (dimension != null) {
            this.consoleWindow.setSize(dimension);
        } else {
            this.consoleWindow.setSize(new Dimension(900, 600));
        }
        this.consoleWindow.setMinimumSize(new Dimension(300, 300));
    }

    private void initialize() {
        this.contentPanel = new JPanel();
        this.outputsPanel = new JPanel();
        this.outputsPanel.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.weighty = 1.0;
        this.contentPanel.add((Component)this.outputsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 0, 0, 0));
        this.contentPanel.add((Component)jPanel, gridBagConstraints);
        JButton jButton = new JButton(Translator.R("CONSOLErungc"));
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaConsole.this.printMemoryInfo();
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "Performing Garbage Collection....");
                System.gc();
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("ButDone"));
                JavaConsole.this.printMemoryInfo();
                JavaConsole.this.updateModel();
            }
        });
        JButton jButton2 = new JButton(Translator.R("CONSOLErunFinalizers"));
        jPanel.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaConsole.this.printMemoryInfo();
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CONSOLErunningFinalizers"));
                Runtime.getRuntime().runFinalization();
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("ButDone"));
                JavaConsole.this.printMemoryInfo();
                JavaConsole.this.updateModel();
            }
        });
        JButton jButton3 = new JButton(Translator.R("CONSOLEmemoryInfo"));
        jPanel.add(jButton3);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaConsole.this.printMemoryInfo();
                JavaConsole.this.updateModel();
            }
        });
        JButton jButton4 = new JButton(Translator.R("CONSOLEsystemProperties"));
        jPanel.add(jButton4);
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaConsole.this.printSystemProperties();
                JavaConsole.this.updateModel();
            }
        });
        JButton jButton5 = new JButton(Translator.R("CONSOLEclassLoaders"));
        jPanel.add(jButton5);
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaConsole.this.printClassLoaders();
                JavaConsole.this.updateModel();
            }
        });
        JButton jButton6 = new JButton(Translator.R("CONSOLEthreadList"));
        jPanel.add(jButton6);
        jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaConsole.this.printThreadInfo();
                JavaConsole.this.updateModel();
            }
        });
        JLabel jLabel = new JLabel("  Number of outputs: ");
        jPanel.add(jLabel);
        this.numberOfOutputs = new JSpinner(new SpinnerNumberModel(1, 0, 10, 1));
        JComponent jComponent = this.numberOfOutputs.getEditor();
        JFormattedTextField jFormattedTextField = (JFormattedTextField)jComponent.getComponent(0);
        DefaultFormatter defaultFormatter = (DefaultFormatter)jFormattedTextField.getFormatter();
        defaultFormatter.setCommitsOnValidEdit(true);
        this.numberOfOutputs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JavaConsole.this.refreshOutputs();
            }
        });
        jPanel.add(this.numberOfOutputs);
        JButton jButton7 = new JButton(Translator.R("ButClose"));
        jPanel.add(jButton7);
        jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JavaConsole.this.hideConsole();
                    }
                });
            }
        });
        this.initialized = true;
    }

    public void showConsole() {
        this.showConsole(false);
    }

    public void showConsole(boolean bl) {
        if (this.consoleWindow == null || !this.consoleWindow.isVisible()) {
            this.initializeWindow();
            this.consoleWindow.setModal(bl);
            this.consoleWindow.setVisible(true);
        }
    }

    public void hideConsole() {
        this.outputsPanel.removeAll();
        this.getObservable().deleteObservers();
        this.consoleWindow.setModal(false);
        this.consoleWindow.setVisible(false);
        this.consoleWindow.dispose();
    }

    public void showConsoleLater() {
        this.showConsoleLater(false);
    }

    public void showConsoleLater(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JavaConsole.getConsole().showConsole(bl);
            }
        });
    }

    public void hideConsoleLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JavaConsole.getConsole().hideConsole();
            }
        });
    }

    protected void printSystemProperties() {
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, " ----");
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CONSOLEsystemProperties") + ":");
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "");
        Properties properties = System.getProperties();
        Set set = properties.keySet();
        for (Object k : set) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, k.toString() + ": " + properties.get(k));
        }
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, " ----");
    }

    public void setClassLoaderInfoProvider(ClassLoaderInfoProvider classLoaderInfoProvider) {
        this.classLoaderInfoProvider = classLoaderInfoProvider;
    }

    private void printClassLoaders() {
        if (this.classLoaderInfoProvider == null) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CONSOLEnoClassLoaders"));
        } else {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, " ----");
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CONSOLEclassLoaders") + ": ");
            Set<String> set = this.classLoaderInfoProvider.getLoaderInfo().keySet();
            for (String string : set) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, string + "\n" + "  codebase = " + this.classLoaderInfoProvider.getLoaderInfo().get(string));
            }
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, " ----");
        }
    }

    private void printMemoryInfo() {
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, " ----- ");
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "  " + Translator.R("CONSOLEmemoryInfo") + ":");
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "   " + Translator.R("CONSOLEmemoryMax") + ":   " + String.format("%1$10d", Runtime.getRuntime().maxMemory()));
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "    " + Translator.R("CONSOLEmemoryTotal") + ": " + String.format("%1$10d", Runtime.getRuntime().totalMemory()));
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "    " + Translator.R("CONSOLEmemoryFree") + ":  " + String.format("%1$10d", Runtime.getRuntime().freeMemory()));
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, " ----");
    }

    private void printThreadInfo() {
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        Set<Thread> set = map.keySet();
        for (Thread thread : set) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CONSOLEthread") + " " + thread.getId() + ": " + thread.getName());
            for (StackTraceElement stackTraceElement : map.get(thread)) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "  " + stackTraceElement);
            }
        }
    }

    public static void main(String[] stringArray) {
        JavaConsole javaConsole = new JavaConsole();
        boolean bl = true;
        for (String string : stringArray) {
            if (!"--show-console".equals(string)) continue;
            bl = true;
        }
        if (bl) {
            javaConsole.showConsoleLater();
        }
    }

    synchronized void addMessage(MessageWithHeader messageWithHeader) {
        this.rawData.add(messageWithHeader);
        this.updateModel();
    }

    private synchronized void updateModel() {
        this.observable.setChanged();
        this.observable.notifyObservers();
    }

    private void processPluginMessage(String string) {
        PluginMessage pluginMessage = new PluginMessage(string);
        OutputController.getLogger().log(pluginMessage);
    }

    @Override
    public List<MessageWithHeader> getData() {
        return this.rawData;
    }

    @Override
    public Observable getObservable() {
        return this.observable;
    }

    public void createPluginReader(final File file) {
        OutputController.getLogger().log("Starting processing of plugin-debug-to-console " + file.getAbsolutePath());
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block8: {
                    BufferedReader bufferedReader = null;
                    try {
                        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8")));
                        while (true) {
                            try {
                                String string;
                                while ((string = bufferedReader.readLine()) != null) {
                                    JavaConsole.this.processPluginMessage(string);
                                }
                            }
                            catch (Exception exception) {
                                OutputController.getLogger().log(exception);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        OutputController.getLogger().log(exception);
                        if (bufferedReader == null) break block8;
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception2) {
                            OutputController.getLogger().log(exception2);
                        }
                    }
                }
                OutputController.getLogger().log("Ended processing of plugin-debug-to-console " + file.getAbsolutePath());
            }
        }, "plugin-debug-to-console reader thread");
        thread.setDaemon(true);
        thread.start();
        OutputController.getLogger().log("Started processing of plugin-debug-to-console " + file.getAbsolutePath());
    }

    private static class JavaConsoleHolder {
        private static final JavaConsole INSTANCE = new JavaConsole();

        private JavaConsoleHolder() {
        }
    }

    public static interface ClassLoaderInfoProvider {
        public Map<String, String> getLoaderInfo();
    }

    private static class PublicObservable
    extends Observable {
        private PublicObservable() {
        }

        @Override
        public synchronized void setChanged() {
            super.setChanged();
        }
    }
}

