/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class WeakList<E>
extends AbstractList<E> {
    private ArrayList<WeakReference<E>> refs = new ArrayList();

    private E deref(WeakReference<E> weakReference) {
        if (weakReference != null) {
            return (E)weakReference.get();
        }
        return null;
    }

    @Override
    public E get(int n) {
        return this.deref(this.refs.get(n));
    }

    @Override
    public int size() {
        return this.refs.size();
    }

    @Override
    public E set(int n, E e) {
        return this.deref(this.refs.set(n, new WeakReference<E>(e)));
    }

    @Override
    public void add(int n, E e) {
        this.refs.add(n, new WeakReference<E>(e));
    }

    @Override
    public E remove(int n) {
        return this.deref(this.refs.remove(n));
    }

    public List<E> hardList() {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (int i = 0; i < this.size(); ++i) {
            E e = this.get(i);
            if (e == null) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public void trimToSize() {
        int n = this.size();
        while (n-- > 0) {
            if (this.get(n) != null) continue;
            this.remove(n);
        }
    }
}

