/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import net.sourceforge.jnlp.util.logging.OutputController;

public class StreamUtils {
    public static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                OutputController.getLogger().log(iOException);
            }
        }
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static String readStreamAsString(InputStream inputStream) throws IOException {
        return StreamUtils.readStreamAsString(inputStream, false);
    }

    public static String readStreamAsString(InputStream inputStream, boolean bl) throws IOException {
        String string;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
            if (!bl) continue;
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

