/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.splashscreen.parts;

import net.sourceforge.jnlp.InformationDesc;
import net.sourceforge.jnlp.runtime.Translator;

public class InfoItem {
    public static final String SPLASH = "SPLASH";
    public static final String title = "title";
    public static final String vendor = "vendor";
    public static final String homepage = "homepage";
    public static final String homepageHref = "href";
    public static final String description = "description";
    public static final String descriptionKind = "kind";
    public static final String descriptionKindOneLine = (String)InformationDesc.ONE_LINE;
    public static final String descriptionKindShort = (String)InformationDesc.SHORT;
    public static final String descriptionKindToolTip = (String)InformationDesc.TOOLTIP;
    protected String type;
    protected String value;

    public InfoItem(String string, String string2) {
        this.type = string;
        this.value = string2;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public boolean isofSameType(InfoItem infoItem) {
        return this.getType().equals(infoItem.getType());
    }

    public boolean equals(Object object) {
        if (!(object instanceof InfoItem)) {
            return false;
        }
        InfoItem infoItem = (InfoItem)object;
        return this.isofSameType(infoItem) && this.getValue().equals(infoItem.getValue());
    }

    public String toString() {
        return this.type + ": " + this.value;
    }

    public String toNiceString() {
        String string = SPLASH + this.type;
        return InfoItem.localise(string, this.value);
    }

    public static String localise(String string, String string2) {
        return Translator.R(string) + ": " + string2;
    }

    public int hashCode() {
        int n = 7;
        n = 59 * n + (this.getType() != null ? this.getType().hashCode() : 0);
        n = 59 * n + (this.getValue() != null ? this.getValue().hashCode() : 0);
        return n;
    }
}

