/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.services.ServiceUtil;
import net.sourceforge.jnlp.services.XFileContents;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

class XPersistenceService
implements PersistenceService {
    protected XPersistenceService() {
    }

    protected void checkLocation(URL uRL) throws MalformedURLException {
        ApplicationInstance applicationInstance = JNLPRuntime.getApplication();
        if (applicationInstance == null) {
            throw new MalformedURLException("Cannot determine the current application.");
        }
        URL uRL2 = applicationInstance.getJNLPFile().getCodeBase();
        if (!uRL2.getHost().equalsIgnoreCase(uRL.getHost()) && !ServiceUtil.isSigned(applicationInstance)) {
            throw new MalformedURLException("Untrusted application cannot access data from a different host.");
        }
        String string = uRL.getFile();
        string = -1 != string.lastIndexOf("/") ? string.substring(0, string.lastIndexOf("/")) : "";
        OutputController.getLogger().log("codebase path: " + uRL2.getFile());
        OutputController.getLogger().log("request path: " + string);
        if (!uRL2.getFile().startsWith(string) && !ServiceUtil.isSigned(applicationInstance)) {
            throw new MalformedURLException("Cannot access data below source URL path.");
        }
    }

    protected File toCacheFile(URL uRL) throws MalformedURLException {
        String string = JNLPRuntime.getConfiguration().getProperty("deployment.user.pcachedir");
        return CacheUtil.urlToPath(uRL, string);
    }

    @Override
    public long create(URL uRL, long l) throws MalformedURLException, IOException {
        this.checkLocation(uRL);
        File file = this.toCacheFile(uRL);
        FileUtils.createParentDir(file, "Persistence store for " + uRL.toString());
        if (file.exists()) {
            throw new IOException("File already exists.");
        }
        FileUtils.createRestrictedFile(file, true);
        return l;
    }

    @Override
    public void delete(URL uRL) throws MalformedURLException, IOException {
        this.checkLocation(uRL);
        FileUtils.deleteWithErrMesg(this.toCacheFile(uRL), " tocache");
    }

    @Override
    public FileContents get(URL uRL) throws MalformedURLException, IOException, FileNotFoundException {
        this.checkLocation(uRL);
        File file = this.toCacheFile(uRL);
        if (!file.exists()) {
            throw new FileNotFoundException("Persistence store for " + uRL.toString() + " is not found.");
        }
        FileUtils.createParentDir(file, "Persistence store for " + uRL.toString());
        return (FileContents)ServiceUtil.createPrivilegedProxy(FileContents.class, new XFileContents(file));
    }

    @Override
    public String[] getNames(URL uRL) throws MalformedURLException, IOException {
        this.checkLocation(uRL);
        File file = this.toCacheFile(uRL);
        if (!file.isDirectory()) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isFile()) continue;
            arrayList.add(fileArray[i].getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public int getTag(URL uRL) throws MalformedURLException, IOException {
        this.checkLocation(uRL);
        if (this.toCacheFile(uRL).exists()) {
            return 0;
        }
        return 0;
    }

    @Override
    public void setTag(URL uRL, int n) throws MalformedURLException, IOException {
        this.checkLocation(uRL);
    }
}

