/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jnlp.FileContents;
import javax.jnlp.FileSaveService;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.services.ServiceUtil;
import net.sourceforge.jnlp.services.XFileContents;
import net.sourceforge.jnlp.util.FileUtils;

class XFileSaveService
implements FileSaveService {
    protected XFileSaveService() {
    }

    @Override
    public FileContents saveFileDialog(String string, String[] stringArray, InputStream inputStream, String string2) throws IOException {
        if (ServiceUtil.checkAccess(SecurityDialogs.AccessType.WRITE_FILE, new Object[0])) {
            JFileChooser jFileChooser = new JFileChooser();
            int n = jFileChooser.showSaveDialog(null);
            if (n == 0) {
                this.writeToFile(inputStream, jFileChooser.getSelectedFile());
                return (FileContents)ServiceUtil.createPrivilegedProxy(FileContents.class, new XFileContents(jFileChooser.getSelectedFile()));
            }
            return null;
        }
        return null;
    }

    @Override
    public FileContents saveAsFileDialog(String string, String[] stringArray, FileContents fileContents) throws IOException {
        if (ServiceUtil.checkAccess(SecurityDialogs.AccessType.WRITE_FILE, new Object[0])) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setSelectedFile(new File(fileContents.getName()));
            int n = jFileChooser.showSaveDialog(null);
            if (n == 0) {
                this.writeToFile(fileContents.getInputStream(), jFileChooser.getSelectedFile());
                return (FileContents)ServiceUtil.createPrivilegedProxy(FileContents.class, new XFileContents(jFileChooser.getSelectedFile()));
            }
            return null;
        }
        return null;
    }

    private void writeToFile(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream;
        if (!file.createNewFile()) {
            boolean bl;
            boolean bl2 = bl = JOptionPane.showConfirmDialog(null, file.getAbsolutePath() + " already exists.\n" + "Do you want to replace it?", "Warning - File Exists", 0) == 0;
            if (!bl) {
                return;
            }
        } else {
            FileUtils.createRestrictedFile(file, true);
        }
        if (file.canWrite()) {
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[256];
            int n = 0;
            while ((n = inputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
        } else {
            throw new IOException("Unable to open file for writing");
        }
        fileOutputStream.flush();
        fileOutputStream.close();
    }
}

