/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.io.File;
import java.io.IOException;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.swing.JFileChooser;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.services.ServiceUtil;
import net.sourceforge.jnlp.services.XFileContents;

class XFileOpenService
implements FileOpenService {
    protected XFileOpenService() {
    }

    @Override
    public FileContents openFileDialog(String string, String[] stringArray) throws IOException {
        if (ServiceUtil.checkAccess(SecurityDialogs.AccessType.READ_FILE, new Object[0])) {
            JFileChooser jFileChooser = new JFileChooser();
            int n = jFileChooser.showOpenDialog(null);
            if (n == 0) {
                return (FileContents)ServiceUtil.createPrivilegedProxy(FileContents.class, new XFileContents(jFileChooser.getSelectedFile()));
            }
            return null;
        }
        return null;
    }

    @Override
    public FileContents[] openMultiFileDialog(String string, String[] stringArray) throws IOException {
        if (ServiceUtil.checkAccess(SecurityDialogs.AccessType.WRITE_FILE, new Object[0])) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setMultiSelectionEnabled(true);
            int n = jFileChooser.showOpenDialog(null);
            if (n == 0) {
                File[] fileArray = jFileChooser.getSelectedFiles();
                int n2 = fileArray.length;
                FileContents[] fileContentsArray = new FileContents[n2];
                for (int i = 0; i < n2; ++i) {
                    XFileContents xFileContents = new XFileContents(fileArray[i]);
                    fileContentsArray[i] = (FileContents)ServiceUtil.createPrivilegedProxy(FileContents.class, xFileContents);
                }
                return fileContentsArray;
            }
            return null;
        }
        return null;
    }
}

