/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.appletextendedsecurity;

import net.sourceforge.jnlp.runtime.Translator;

public enum AppletSecurityLevel {
    DENY_ALL,
    DENY_UNSIGNED,
    ASK_UNSIGNED,
    ALLOW_UNSIGNED;


    public static String allToString() {
        return DENY_ALL.toChars() + " " + DENY_UNSIGNED.toChars() + " " + ASK_UNSIGNED.toChars() + " " + ALLOW_UNSIGNED.toChars();
    }

    public String toChars() {
        return this.name();
    }

    public String toExplanation() {
        switch (this) {
            case DENY_ALL: {
                return Translator.R("APPEXTSECappletSecurityLevelExtraHighId") + " - " + Translator.R("APPEXTSECappletSecurityLevelExtraHighExplanation");
            }
            case DENY_UNSIGNED: {
                return Translator.R("APPEXTSECappletSecurityLevelVeryHighId") + " - " + Translator.R("APPEXTSECappletSecurityLevelVeryHighExplanation");
            }
            case ASK_UNSIGNED: {
                return Translator.R("APPEXTSECappletSecurityLevelHighId") + " - " + Translator.R("APPEXTSECappletSecurityLevelHighExplanation");
            }
            case ALLOW_UNSIGNED: {
                return Translator.R("APPEXTSECappletSecurityLevelLowId") + " - " + Translator.R("APPEXTSECappletSecurityLevelLowExplanation");
            }
        }
        throw new RuntimeException("Unknown AppletSecurityLevel");
    }

    public static AppletSecurityLevel fromString(String string) {
        return AppletSecurityLevel.valueOf(string.toUpperCase());
    }

    public String toString() {
        return this.toExplanation();
    }

    public static AppletSecurityLevel getDefault() {
        return ASK_UNSIGNED;
    }
}

