/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.MessageDigest;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.SecurityDialogPanel;
import net.sourceforge.jnlp.security.SecurityUtil;
import sun.misc.HexDumpEncoder;
import sun.security.x509.CertificateValidity;

public class CertsInfoPane
extends SecurityDialogPanel {
    private CertPath certPath;
    protected JTree tree;
    private JTable table;
    private JTextArea output;
    private ListSelectionModel listSelectionModel;
    private ListSelectionModel tableSelectionModel;
    protected String[] certNames;
    private String[] columnNames = new String[]{Translator.R("Field"), Translator.R("Value")};
    protected ArrayList<String[][]> certsData;

    public CertsInfoPane(SecurityDialog securityDialog, CertVerifier certVerifier) {
        super(securityDialog, certVerifier);
        this.addComponents();
    }

    void buildTree() {
        this.certPath = this.parent.getCertVerifier().getCertPath(null);
        X509Certificate x509Certificate = (X509Certificate)this.certPath.getCertificates().get(0);
        String string = SecurityUtil.getCN(x509Certificate.getSubjectX500Principal().getName());
        String string2 = SecurityUtil.getCN(x509Certificate.getIssuerX500Principal().getName());
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string + " (" + string2 + ")");
        if (!x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN()) && this.certPath.getCertificates().size() > 1) {
            X509Certificate x509Certificate2 = (X509Certificate)this.certPath.getCertificates().get(1);
            string = SecurityUtil.getCN(x509Certificate2.getSubjectX500Principal().getName());
            string2 = SecurityUtil.getCN(x509Certificate2.getIssuerX500Principal().getName());
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(string + " (" + string2 + ")"));
        }
        this.tree = new JTree(defaultMutableTreeNode);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(new TreeSelectionHandler());
    }

    protected void populateTable() {
        this.certNames = new String[this.certPath.getCertificates().size()];
        this.certsData = new ArrayList();
        for (int i = 0; i < this.certPath.getCertificates().size(); ++i) {
            X509Certificate x509Certificate = (X509Certificate)this.certPath.getCertificates().get(i);
            this.certsData.add(this.parseCert(x509Certificate));
            this.certNames[i] = SecurityUtil.getCN(x509Certificate.getSubjectX500Principal().getName()) + " (" + SecurityUtil.getCN(x509Certificate.getIssuerX500Principal().getName()) + ")";
        }
    }

    protected String[][] parseCert(X509Certificate x509Certificate) {
        String[][] stringArray;
        String string = "" + x509Certificate.getVersion();
        String string2 = x509Certificate.getSerialNumber().toString();
        String string3 = x509Certificate.getSigAlgName();
        String string4 = x509Certificate.getIssuerX500Principal().toString();
        String string5 = new CertificateValidity(x509Certificate.getNotBefore(), x509Certificate.getNotAfter()).toString();
        String string6 = x509Certificate.getSubjectX500Principal().toString();
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string7 = hexDumpEncoder.encodeBuffer(x509Certificate.getSignature());
        String string8 = "";
        String string9 = "";
        try {
            stringArray = MessageDigest.getInstance("MD5");
            stringArray.update(x509Certificate.getEncoded());
            string8 = this.makeFingerprint(stringArray.digest());
            stringArray = MessageDigest.getInstance("SHA-1");
            stringArray.update(x509Certificate.getEncoded());
            string9 = this.makeFingerprint(stringArray.digest());
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringArray = new String[][]{{Translator.R("Version"), string}, {Translator.R("SSerial"), string2}, {Translator.R("SSignatureAlgorithm"), string3}, {Translator.R("SIssuer"), string4}, {Translator.R("SValidity"), string5}, {Translator.R("SSubject"), string6}, {Translator.R("SSignature"), string7}, {Translator.R("SMD5Fingerprint"), string8}, {Translator.R("SSHA1Fingerprint"), string9}};
        return stringArray;
    }

    private void addComponents() {
        this.buildTree();
        this.populateTable();
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        DefaultTableModel defaultTableModel = new DefaultTableModel(this.certsData.get(0), this.columnNames);
        this.table = new JTable(defaultTableModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.tableSelectionModel = this.table.getSelectionModel();
        this.tableSelectionModel.addListSelectionListener(new TableSelectionHandler());
        this.table.setFillsViewportHeight(true);
        JScrollPane jScrollPane2 = new JScrollPane(this.table);
        jScrollPane2.setPreferredSize(new Dimension(500, 200));
        this.output = new JTextArea();
        this.output.setEditable(false);
        JScrollPane jScrollPane3 = new JScrollPane(this.output, 20, 30);
        jScrollPane3.setPreferredSize(new Dimension(500, 200));
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane2, jScrollPane3);
        jSplitPane.setDividerLocation(0.5);
        jSplitPane.setResizeWeight(0.5);
        JSplitPane jSplitPane2 = new JSplitPane(1, jScrollPane, jSplitPane);
        jSplitPane2.setDividerLocation(0.3);
        jSplitPane2.setResizeWeight(0.3);
        JPanel jPanel = new JPanel(new BorderLayout());
        JButton jButton = new JButton(Translator.R("ButClose"));
        JButton jButton2 = new JButton(Translator.R("ButCopy"));
        jButton.addActionListener(this.createSetValueListener(this.parent, 0));
        jButton2.addActionListener(new CopyToClipboardHandler());
        jPanel.add((Component)jButton, "East");
        jPanel.add((Component)jButton2, "West");
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jSplitPane2, "Center");
        this.add((Component)jPanel, "South");
    }

    private String makeFingerprint(byte[] byArray) {
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            if (!string.equals("")) {
                string = string + ":";
            }
            string = string + Integer.toHexString(byArray[i] & 0xFF | 0x100).substring(1, 3);
        }
        return string.toUpperCase();
    }

    private class TableSelectionHandler
    implements ListSelectionListener {
        private TableSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            int n = listSelectionModel.getMinSelectionIndex();
            int n2 = listSelectionModel.getMaxSelectionIndex();
            for (int i = n; i <= n2; ++i) {
                if (!listSelectionModel.isSelectedIndex(i)) continue;
                CertsInfoPane.this.output.setText((String)CertsInfoPane.this.table.getValueAt(i, 1));
            }
        }
    }

    private class ListSelectionHandler
    implements ListSelectionListener {
        private ListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            int n = listSelectionModel.getMinSelectionIndex();
            int n2 = listSelectionModel.getMaxSelectionIndex();
            for (int i = n; i <= n2; ++i) {
                if (!listSelectionModel.isSelectedIndex(i)) continue;
                CertsInfoPane.this.table.setModel(new DefaultTableModel(CertsInfoPane.this.certsData.get(i), CertsInfoPane.this.columnNames));
            }
        }
    }

    protected class TreeSelectionHandler
    implements TreeSelectionListener {
        protected TreeSelectionHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)CertsInfoPane.this.tree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode == null) {
                return;
            }
            if (defaultMutableTreeNode.isRoot()) {
                CertsInfoPane.this.table.setModel(new DefaultTableModel(CertsInfoPane.this.certsData.get(0), CertsInfoPane.this.columnNames));
            } else if (defaultMutableTreeNode.isLeaf()) {
                CertsInfoPane.this.table.setModel(new DefaultTableModel(CertsInfoPane.this.certsData.get(1), CertsInfoPane.this.columnNames));
            }
        }
    }

    private class CopyToClipboardHandler
    implements ActionListener {
        private CopyToClipboardHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            int n = 0;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)CertsInfoPane.this.tree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode == null) {
                return;
            }
            if (defaultMutableTreeNode.isRoot()) {
                n = 0;
            } else if (defaultMutableTreeNode.isLeaf()) {
                n = 1;
            }
            String[][] stringArray = CertsInfoPane.this.certsData.get(n);
            int n2 = stringArray.length;
            int n3 = stringArray[0].length;
            String string = "";
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    string = string + stringArray[i][j];
                    string = string + " ";
                }
                string = string + "\n";
            }
            clipboard.setContents(new StringSelection(string), null);
        }
    }
}

