/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import net.sourceforge.jnlp.util.UrlUtils;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.net.www.protocol.jar.URLJarFile;
import sun.net.www.protocol.jar.URLJarFileCallBack;

final class CachedJarFileCallback
implements URLJarFileCallBack {
    private static final CachedJarFileCallback INSTANCE = new CachedJarFileCallback();
    private final Map<URL, URL> mapping = new ConcurrentHashMap<URL, URL>();

    public static synchronized CachedJarFileCallback getInstance() {
        return INSTANCE;
    }

    private CachedJarFileCallback() {
    }

    protected void addMapping(URL uRL, URL uRL2) {
        this.mapping.put(uRL, uRL2);
    }

    @Override
    public JarFile retrieve(URL uRL) throws IOException {
        URL uRL2 = this.mapping.get(uRL);
        if (uRL2 == null) {
            return this.cacheJarFile(uRL);
        }
        if (UrlUtils.isLocalFile(uRL2)) {
            net.sourceforge.jnlp.util.JarFile jarFile = new net.sourceforge.jnlp.util.JarFile(uRL2.getPath());
            try {
                jarFile.getManifest().getMainAttributes().putValue("Class-Path", "");
                OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Class-Path attribute cleared for " + jarFile.getName());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return jarFile;
        }
        return null;
    }

    private JarFile cacheJarFile(URL uRL) throws IOException {
        JarFile jarFile = null;
        final InputStream inputStream = uRL.openConnection().getInputStream();
        try {
            jarFile = AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){

                @Override
                public JarFile run() throws IOException {
                    OutputStream outputStream = null;
                    File file = null;
                    try {
                        file = File.createTempFile("jar_cache", null);
                        file.deleteOnExit();
                        outputStream = new FileOutputStream(file);
                        int n = 0;
                        byte[] byArray = new byte[2048];
                        while ((n = inputStream.read(byArray)) != -1) {
                            outputStream.write(byArray, 0, n);
                        }
                        outputStream.close();
                        outputStream = null;
                        URLJarFile uRLJarFile = new URLJarFile(file, null);
                        return uRLJarFile;
                    }
                    catch (IOException iOException) {
                        if (file != null) {
                            file.delete();
                        }
                        throw iOException;
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return jarFile;
    }
}

