/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import net.sourceforge.jnlp.DownloadOptions;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.CacheEntry;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.IllegalResourceDescriptorException;
import net.sourceforge.jnlp.cache.Resource;
import net.sourceforge.jnlp.cache.ResourceUrlCreator;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.event.DownloadEvent;
import net.sourceforge.jnlp.event.DownloadListener;
import net.sourceforge.jnlp.util.HttpUtils;
import net.sourceforge.jnlp.util.UrlUtils;
import net.sourceforge.jnlp.util.WeakList;
import net.sourceforge.jnlp.util.logging.OutputController;

public class ResourceTracker {
    private static final Object lock = new Object();
    private static final int UNINITIALIZED = 0;
    private static final int CONNECT = 1;
    private static final int CONNECTING = 2;
    private static final int CONNECTED = 4;
    private static final int DOWNLOAD = 8;
    private static final int DOWNLOADING = 16;
    private static final int DOWNLOADED = 32;
    private static final int ERROR = 64;
    private static final int STARTED = 128;
    private static final int maxThreads = 5;
    private static final String[] requestMethods = new String[]{"HEAD", "GET"};
    private static int threads = 0;
    private static WeakList<ResourceTracker> prefetchTrackers = new WeakList();
    private static ArrayList<Resource> queue = new ArrayList();
    private static ConcurrentHashMap<Resource, DownloadOptions> downloadOptions = new ConcurrentHashMap();
    private static ArrayList<ResourceTracker> active = new ArrayList();
    private List<Resource> resources = new ArrayList<Resource>();
    private List<DownloadListener> listeners = new ArrayList<DownloadListener>();
    private boolean prefetch;

    public ResourceTracker() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceTracker(boolean bl) {
        this.prefetch = bl;
        if (bl) {
            WeakList<ResourceTracker> weakList = prefetchTrackers;
            synchronized (weakList) {
                prefetchTrackers.add(this);
                prefetchTrackers.trimToSize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(URL uRL, Version version, DownloadOptions downloadOptions, UpdatePolicy updatePolicy) {
        if (uRL == null) {
            throw new IllegalResourceDescriptorException("location==null");
        }
        try {
            uRL = UrlUtils.normalizeUrl(uRL);
        }
        catch (Exception exception) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Normalization of " + uRL.toString() + " have failed");
            OutputController.getLogger().log(exception);
        }
        Resource resource = Resource.getResource(uRL, version, updatePolicy);
        boolean bl = false;
        Object object = this.resources;
        synchronized (object) {
            if (this.resources.contains(resource)) {
                return;
            }
            resource.addTracker(this);
            this.resources.add(resource);
        }
        if (downloadOptions == null) {
            downloadOptions = new DownloadOptions(false, false);
        }
        ResourceTracker.downloadOptions.put(resource, downloadOptions);
        bl = this.checkCache(resource, updatePolicy);
        object = lock;
        synchronized (object) {
            if (!bl && this.prefetch && threads == 0) {
                this.startThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResource(URL uRL) {
        List<Resource> list = this.resources;
        synchronized (list) {
            Resource resource = this.getResource(uRL);
            if (resource != null) {
                this.resources.remove(resource);
                resource.removeTracker(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkCache(Resource resource, UpdatePolicy updatePolicy) {
        CacheEntry cacheEntry;
        if (!CacheUtil.isCacheable(resource.location, resource.downloadVersion)) {
            Resource resource2 = resource;
            synchronized (resource2) {
                resource.changeStatus(0, 164);
            }
            this.fireDownloadEvent(resource);
            return true;
        }
        if (updatePolicy != UpdatePolicy.ALWAYS && updatePolicy != UpdatePolicy.FORCE && (cacheEntry = new CacheEntry(resource.location, resource.downloadVersion)).isCached() && !updatePolicy.shouldUpdate(cacheEntry)) {
            OutputController.getLogger().log("not updating: " + resource.location);
            Resource resource3 = resource;
            synchronized (resource3) {
                resource.localFile = CacheUtil.getCacheFile(resource.location, resource.downloadVersion);
                resource.size = resource.localFile.length();
                resource.transferred = resource.localFile.length();
                resource.changeStatus(0, 164);
            }
            this.fireDownloadEvent(resource);
            return true;
        }
        if (updatePolicy == UpdatePolicy.FORCE) {
            resource.changeStatus(Integer.MAX_VALUE, 0);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownloadListener(DownloadListener downloadListener) {
        List<DownloadListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(downloadListener)) {
                this.listeners.add(downloadListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadListener(DownloadListener downloadListener) {
        List<DownloadListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(downloadListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDownloadEvent(Resource resource) {
        int n;
        DownloadListener[] downloadListenerArray = null;
        List<DownloadListener> list = this.listeners;
        synchronized (list) {
            downloadListenerArray = this.listeners.toArray(new DownloadListener[0]);
        }
        Object object = resource;
        synchronized (object) {
            n = resource.status;
        }
        object = new DownloadEvent(this, resource);
        for (DownloadListener downloadListener : downloadListenerArray) {
            if (0 != (0x60 & n)) {
                downloadListener.downloadCompleted((DownloadEvent)object);
                continue;
            }
            if (0 != (0x10 & n)) {
                downloadListener.downloadStarted((DownloadEvent)object);
                continue;
            }
            if (0 == (2 & n)) continue;
            downloadListener.updateStarted((DownloadEvent)object);
        }
    }

    public URL getCacheURL(URL uRL) {
        try {
            File file = this.getCacheFile(uRL);
            if (file != null) {
                return file.toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            OutputController.getLogger().log(malformedURLException);
        }
        return uRL;
    }

    public File getCacheFile(URL uRL) {
        try {
            File file;
            Resource resource = this.getResource(uRL);
            if (!resource.isSet(96)) {
                this.waitForResource(uRL, 0L);
            }
            if (resource.isSet(64)) {
                return null;
            }
            if (resource.localFile != null) {
                return resource.localFile;
            }
            if (uRL.getProtocol().equalsIgnoreCase("file") && (file = UrlUtils.decodeUrlAsFile(uRL)).exists()) {
                return file;
            }
            return null;
        }
        catch (InterruptedException interruptedException) {
            OutputController.getLogger().log(interruptedException);
            return null;
        }
    }

    public InputStream getInputStream(URL uRL) throws IOException {
        try {
            Resource resource = this.getResource(uRL);
            if (!resource.isSet(96)) {
                this.waitForResource(uRL, 0L);
            }
            if (resource.localFile != null) {
                return new FileInputStream(resource.localFile);
            }
            return resource.location.openStream();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("wait was interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForResources(URL[] uRLArray, long l) throws InterruptedException {
        Resource[] resourceArray;
        Resource[] resourceArray2 = resourceArray = new Resource[uRLArray.length];
        synchronized (resourceArray) {
            for (int i = 0; i < uRLArray.length; ++i) {
                resourceArray[i] = this.getResource(uRLArray[i]);
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (resourceArray.length > 0) {
                return this.wait(resourceArray, l);
            }
            return true;
        }
    }

    public boolean waitForResource(URL uRL, long l) throws InterruptedException {
        return this.wait(new Resource[]{this.getResource(uRL)}, l);
    }

    public long getAmountRead(URL uRL) {
        return this.getResource((URL)uRL).transferred;
    }

    public boolean checkResource(URL uRL) {
        return this.getResource(uRL).isSet(96);
    }

    public boolean startResource(URL uRL) {
        Resource resource = this.getResource(uRL);
        return this.startResource(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startResource(Resource resource) {
        boolean bl = false;
        Resource resource2 = resource;
        synchronized (resource2) {
            if (resource.isSet(64)) {
                return true;
            }
            boolean bl2 = bl = !resource.isSet(128);
            if (!resource.isSet(6)) {
                resource.changeStatus(0, 129);
            }
            if (!resource.isSet(48)) {
                resource.changeStatus(0, 136);
            }
            if (!resource.isSet(9)) {
                bl = false;
            }
        }
        if (bl) {
            this.queueResource(resource);
        }
        return !bl;
    }

    public long getTotalSize(URL uRL) {
        return this.getResource((URL)uRL).size;
    }

    protected void startThread() {
        if (threads < 5) {
            Thread thread = new Thread((Runnable)new Downloader(), "DownloaderThread" + ++threads);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endThread() {
        if (--threads < 0) {
            threads = 0;
            if (queue.size() > 0) {
                this.startThread();
            }
            throw new RuntimeException("tracker threads < 0");
        }
        if (threads == 0) {
            WeakList<ResourceTracker> weakList = prefetchTrackers;
            synchronized (weakList) {
                queue.trimToSize();
                active.clear();
                active.trimToSize();
                prefetchTrackers.trimToSize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueResource(Resource resource) {
        Object object = lock;
        synchronized (object) {
            if (!resource.isSet(9)) {
                throw new IllegalResourceDescriptorException("Invalid resource state (resource: " + resource + ")");
            }
            queue.add(resource);
            this.startThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResource(Resource resource) {
        boolean bl = false;
        boolean bl2 = false;
        Resource resource2 = resource;
        synchronized (resource2) {
            if (resource.isSet(2)) {
                bl = true;
            }
        }
        if (bl) {
            this.initializeResource(resource);
        }
        resource2 = resource;
        synchronized (resource2) {
            if (resource.isSet(8)) {
                this.queueResource(resource);
            }
            if (resource.isSet(16)) {
                bl2 = true;
            }
        }
        if (bl2) {
            this.downloadResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadResource(Resource resource) {
        resource.fireDownloadEvent();
        CacheEntry cacheEntry = new CacheEntry(resource.location, resource.downloadVersion);
        cacheEntry.lock();
        try {
            Object object;
            URL uRL = resource.getDownloadLocation();
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.addRequestProperty("Accept-Encoding", "pack200-gzip, gzip");
            uRLConnection.connect();
            URL uRL2 = resource.location;
            String string = uRLConnection.getContentEncoding();
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Downloading" + resource.location + " using " + uRL + " (encoding : " + string + ")");
            boolean bl = "pack200-gzip".equals(string) || uRL.getPath().endsWith(".pack.gz");
            boolean bl2 = "gzip".equals(string);
            if (bl) {
                uRL2 = new URL(uRL2.toString() + ".pack.gz");
            } else if (bl2) {
                uRL2 = new URL(uRL2.toString() + ".gz");
            }
            File file = CacheUtil.getCacheFile(uRL2, resource.downloadVersion);
            CacheEntry cacheEntry2 = new CacheEntry(uRL2, resource.downloadVersion);
            File file2 = CacheUtil.getCacheFile(resource.location, resource.downloadVersion);
            if (!cacheEntry2.isCurrent(uRLConnection)) {
                int n;
                object = new byte[1024];
                BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
                OutputStream outputStream = CacheUtil.getOutputStream(uRL2, resource.downloadVersion);
                while (-1 != (n = ((InputStream)bufferedInputStream).read((byte[])object))) {
                    resource.transferred += (long)n;
                    outputStream.write((byte[])object, 0, n);
                }
                ((InputStream)bufferedInputStream).close();
                outputStream.close();
                if (uRLConnection instanceof HttpURLConnection) {
                    ((HttpURLConnection)uRLConnection).disconnect();
                }
                if (bl) {
                    cacheEntry2.initialize(uRLConnection);
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(new FileInputStream(CacheUtil.getCacheFile(uRL2, resource.downloadVersion)));
                    BufferedInputStream bufferedInputStream2 = new BufferedInputStream(gZIPInputStream);
                    JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(CacheUtil.getCacheFile(resource.location, resource.downloadVersion)));
                    Pack200.Unpacker unpacker = Pack200.newUnpacker();
                    unpacker.unpack(bufferedInputStream2, jarOutputStream);
                    jarOutputStream.close();
                    ((InputStream)bufferedInputStream2).close();
                    gZIPInputStream.close();
                } else if (bl2) {
                    cacheEntry2.initialize(uRLConnection);
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(new FileInputStream(CacheUtil.getCacheFile(uRL2, resource.downloadVersion)));
                    BufferedInputStream bufferedInputStream3 = new BufferedInputStream(gZIPInputStream);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(CacheUtil.getCacheFile(resource.location, resource.downloadVersion)));
                    while (-1 != (n = ((InputStream)bufferedInputStream3).read((byte[])object))) {
                        bufferedOutputStream.write((byte[])object, 0, n);
                    }
                    bufferedOutputStream.close();
                    ((InputStream)bufferedInputStream3).close();
                    gZIPInputStream.close();
                }
            } else {
                resource.transferred = file.length();
            }
            if (!file.getPath().equals(file2.getPath())) {
                cacheEntry2.markForDelete();
                cacheEntry2.store();
            }
            resource.changeStatus(16, 32);
            Object object2 = lock;
            object = object2;
            synchronized (object2) {
                lock.notifyAll();
                // ** MonitorExit[var12_14 /* !! */ ] (shouldn't be in output)
                resource.fireDownloadEvent();
            }
        }
        catch (Exception exception) {
            OutputController.getLogger().log(exception);
            resource.changeStatus(0, 64);
            Object object = lock;
            synchronized (object) {
                lock.notifyAll();
            }
            resource.fireDownloadEvent();
        }
        finally {
            cacheEntry.unlock();
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeResource(Resource resource) {
        resource.fireDownloadEvent();
        Object object = new CacheEntry(resource.location, resource.requestVersion);
        ((CacheEntry)object).lock();
        try {
            Object object2;
            boolean bl;
            File file = CacheUtil.getCacheFile(resource.location, resource.downloadVersion);
            URL uRL = this.findBestUrl(resource);
            if (uRL == null) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Attempted to download " + resource.location + ", but failed to connect!");
                throw new NullPointerException("finalLocation == null");
            }
            resource.setDownloadLocation(uRL);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.addRequestProperty("Accept-Encoding", "pack200-gzip, gzip");
            int n = uRLConnection.getContentLength();
            boolean bl2 = bl = CacheUtil.isCurrent(resource.location, resource.requestVersion, uRLConnection) && resource.getUpdatePolicy() != UpdatePolicy.FORCE;
            if (!bl && ((CacheEntry)object).isCached()) {
                ((CacheEntry)object).markForDelete();
                ((CacheEntry)object).store();
                file = CacheUtil.makeNewCacheFile(resource.location, resource.downloadVersion);
                object2 = new CacheEntry(resource.location, resource.requestVersion);
                ((CacheEntry)object2).lock();
                ((CacheEntry)object).unlock();
                object = object2;
            }
            object2 = resource;
            synchronized (object2) {
                resource.localFile = file;
                resource.size = n;
                resource.changeStatus(3, 4);
                if (bl) {
                    resource.changeStatus(24, 32);
                }
            }
            if (!bl) {
                ((CacheEntry)object).initialize(uRLConnection);
            }
            ((CacheEntry)object).setLastUpdated(System.currentTimeMillis());
            ((CacheEntry)object).store();
            object2 = lock;
            synchronized (object2) {
                lock.notifyAll();
            }
            resource.fireDownloadEvent();
            if (uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).disconnect();
            }
        }
        catch (Exception exception) {
            OutputController.getLogger().log(exception);
            resource.changeStatus(0, 64);
            Object object3 = lock;
            synchronized (object3) {
                lock.notifyAll();
            }
            resource.fireDownloadEvent();
        }
        finally {
            ((CacheEntry)object).unlock();
        }
    }

    static int getUrlResponseCode(URL uRL, Map<String, String> map, String string) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            uRLConnection.addRequestProperty(entry.getKey(), entry.getValue());
        }
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            httpURLConnection.setRequestMethod(string);
            int n = httpURLConnection.getResponseCode();
            HttpUtils.consumeAndCloseConnectionSilently(httpURLConnection);
            return n;
        }
        return 200;
    }

    URL findBestUrl(Resource resource) {
        DownloadOptions downloadOptions = ResourceTracker.downloadOptions.get(resource);
        if (downloadOptions == null) {
            downloadOptions = new DownloadOptions(false, false);
        }
        List<URL> list = new ResourceUrlCreator(resource, downloadOptions).getUrls();
        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "All possible urls for " + resource.toString() + " : " + list);
        for (String string : requestMethods) {
            for (URL uRL : list) {
                try {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("Accept-Encoding", "pack200-gzip, gzip");
                    int n = ResourceTracker.getUrlResponseCode(uRL, hashMap, string);
                    if (n < 200 || n >= 300) {
                        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "For " + resource.toString() + " the server returned " + n + " code for " + string + " request for " + uRL.toExternalForm());
                        continue;
                    }
                    OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "best url for " + resource.toString() + " is " + uRL.toString() + " by " + string);
                    return uRL;
                }
                catch (IOException iOException) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "While processing " + uRL.toString() + " by " + string + " for resource " + resource.toString() + " got " + iOException + ": ");
                    OutputController.getLogger().log(iOException);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Resource selectNextResource() {
        Resource resource = ResourceTracker.selectByFlag(queue, 1, 64);
        if (resource == null) {
            resource = ResourceTracker.selectByFlag(queue, 8, 67);
        }
        if (resource != null) {
            queue.remove(resource);
        }
        if (resource == null && threads == 1) {
            resource = ResourceTracker.getPrefetch();
        }
        if (resource == null) {
            return null;
        }
        Resource resource2 = resource;
        synchronized (resource2) {
            if (resource.isSet(1)) {
                resource.changeStatus(1, 2);
            } else if (resource.isSet(8)) {
                resource.changeStatus(8, 16);
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Resource getPrefetch() {
        Resource resource = null;
        Resource resource2 = null;
        WeakList<ResourceTracker> weakList = prefetchTrackers;
        synchronized (weakList) {
            for (int i = 0; i < prefetchTrackers.size() && resource == null; ++i) {
                ResourceTracker resourceTracker = prefetchTrackers.get(i);
                if (resourceTracker == null) continue;
                List<Resource> list = resourceTracker.resources;
                synchronized (list) {
                    resource = ResourceTracker.selectByFlag(resourceTracker.resources, 0, 64);
                    if (resource == null && resource2 == null) {
                        resource2 = ResourceTracker.selectByFlag(resourceTracker.resources, 4, 120);
                    }
                    continue;
                }
            }
        }
        if (resource == null) {
            resource = resource2;
        }
        if (resource == null) {
            return null;
        }
        weakList = resource;
        synchronized (weakList) {
            ResourceTracker resourceTracker = resource.getTracker();
            if (resourceTracker == null) {
                return null;
            }
            resource.changeStatus(0, 128);
            resourceTracker.startResource(resource);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Resource selectByFlag(List<Resource> list, int n, int n2) {
        Resource resource = null;
        int n3 = Integer.MAX_VALUE;
        for (Resource resource2 : list) {
            boolean bl = false;
            Resource resource3 = resource2;
            synchronized (resource3) {
                if (resource2.isSet(n) && !resource2.isSet(n2)) {
                    bl = true;
                }
            }
            if (!bl) continue;
            int n4 = 0;
            for (ResourceTracker resourceTracker : active) {
                if (resourceTracker != resource2.getTracker()) continue;
                ++n4;
            }
            if (n4 >= n3) continue;
            resource = resource2;
            n3 = n4;
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource getResource(URL uRL) {
        List<Resource> list = this.resources;
        synchronized (list) {
            for (Resource resource : this.resources) {
                if (!CacheUtil.urlEquals(resource.location, uRL)) continue;
                return resource;
            }
        }
        throw new IllegalResourceDescriptorException("Location does not specify a resource being tracked.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wait(Resource[] resourceArray, long l) throws InterruptedException {
        long l2 = System.currentTimeMillis();
        for (Resource resource : resourceArray) {
            this.startResource(resource);
        }
        while (true) {
            boolean bl = true;
            Object object = lock;
            synchronized (object) {
                Resource[] resourceArray2 = resourceArray;
                int n = resourceArray2.length;
                for (int i = 0; i < n; ++i) {
                    Resource resource;
                    Resource resource2 = resource = resourceArray2[i];
                    synchronized (resource2) {
                        if (!resource.isSet(96)) {
                            bl = false;
                            break;
                        }
                        continue;
                    }
                }
                if (bl) {
                    return true;
                }
                long l3 = 0L;
                if (l > 0L && (l3 = l - (System.currentTimeMillis() - l2)) <= 0L) {
                    return false;
                }
                lock.wait(l3);
            }
        }
    }

    private class Downloader
    implements Runnable {
        Resource resource = null;

        private Downloader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object = lock;
                synchronized (object) {
                    if (this.resource != null) {
                        active.remove(this.resource.getTracker());
                    }
                    this.resource = ResourceTracker.selectNextResource();
                    if (this.resource == null) {
                        ResourceTracker.this.endThread();
                        break;
                    }
                    active.add(this.resource.getTracker());
                }
                try {
                    object = this.resource;
                    AccessController.doPrivileged(new PrivilegedAction<Void>((Resource)object){
                        final /* synthetic */ Resource val$fResource;
                        {
                            this.val$fResource = resource;
                        }

                        @Override
                        public Void run() {
                            ResourceTracker.this.processResource(this.val$fResource);
                            return null;
                        }
                    });
                }
                catch (Exception exception) {
                    OutputController.getLogger().log(exception);
                }
            }
        }
    }
}

