/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.jnlp.DownloadServiceListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.sourceforge.jnlp.cache.DownloadIndicator;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.ImageResources;
import net.sourceforge.jnlp.util.ScreenFinder;

public class DefaultDownloadIndicator
implements DownloadIndicator {
    private static String downloading = Translator.R("CDownloading");
    private static String complete = Translator.R("CComplete");
    private static final int CLOSE_DELAY = 750;
    private static JFrame frame;
    private static final Object frameMutex;
    static GridBagConstraints vertical;
    static GridBagConstraints verticalNoClean;
    static GridBagConstraints verticalIndent;

    @Override
    public int getUpdateRate() {
        return 150;
    }

    @Override
    public int getInitialDelay() {
        return 300;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadServiceListener getListener(ApplicationInstance applicationInstance, String string, URL[] uRLArray) {
        DownloadPanel downloadPanel = new DownloadPanel(string);
        Object object = frameMutex;
        synchronized (object) {
            if (frame == null) {
                frame = DefaultDownloadIndicator.createDownloadIndicatorFrame(true);
            }
            if (uRLArray != null) {
                for (URL uRL : uRLArray) {
                    downloadPanel.addProgressPanel(uRL, null);
                }
            }
            frame.getContentPane().add((Component)downloadPanel, vertical);
            frame.pack();
            DefaultDownloadIndicator.placeFrameToLowerRight();
            downloadPanel.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    DefaultDownloadIndicator.placeFrameToLowerRight();
                }
            });
            frame.setVisible(true);
            return downloadPanel;
        }
    }

    public static JFrame createDownloadIndicatorFrame(boolean bl) throws HeadlessException {
        JFrame jFrame = new JFrame(downloading + "...");
        jFrame.setUndecorated(bl);
        jFrame.setIconImages(ImageResources.INSTANCE.getApplicationImages());
        jFrame.getContentPane().setLayout(new GridBagLayout());
        return jFrame;
    }

    private static void placeFrameToLowerRight() throws HeadlessException {
        Rectangle rectangle = ScreenFinder.getCurrentScreenSizeWithoutBounds();
        frame.setLocation(rectangle.width + rectangle.x - frame.getWidth(), rectangle.height + rectangle.y - frame.getHeight());
    }

    @Override
    public void disposeListener(final DownloadServiceListener downloadServiceListener) {
        if (!(downloadServiceListener instanceof DownloadPanel)) {
            return;
        }
        ActionListener actionListener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = frameMutex;
                synchronized (object) {
                    frame.getContentPane().remove((DownloadPanel)downloadServiceListener);
                    frame.pack();
                    if (frame.getContentPane().getComponentCount() == 0) {
                        frame.setVisible(false);
                        frame.dispose();
                        frame = null;
                    }
                }
            }
        };
        Timer timer = new Timer(750, actionListener);
        timer.setRepeats(false);
        timer.start();
    }

    static {
        frameMutex = new Object();
        vertical = new GridBagConstraints();
        DefaultDownloadIndicator.vertical.gridwidth = 0;
        DefaultDownloadIndicator.vertical.weightx = 1.0;
        DefaultDownloadIndicator.vertical.fill = 2;
        DefaultDownloadIndicator.vertical.anchor = 17;
        verticalNoClean = new GridBagConstraints();
        DefaultDownloadIndicator.verticalNoClean.weightx = 1.0;
        verticalIndent = (GridBagConstraints)vertical.clone();
        DefaultDownloadIndicator.verticalIndent.insets = new Insets(0, 10, 3, 0);
    }

    static class ProgressPanel
    extends JPanel {
        private JPanel bar = new JPanel();
        private long total;
        private long readSoFar;
        private Dimension size = new Dimension(80, 15);

        ProgressPanel() {
            this.bar.setMinimumSize(this.size);
            this.bar.setPreferredSize(this.size);
            this.bar.setOpaque(false);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.styleGridBagConstraints(gridBagConstraints);
            this.add((Component)this.bar, gridBagConstraints);
        }

        ProgressPanel(URL uRL, String string) {
            this(" " + uRL.getHost() + "/" + uRL.getFile(), string);
        }

        ProgressPanel(String string, String string2) {
            JLabel jLabel = new JLabel(string);
            this.bar.setMinimumSize(this.size);
            this.bar.setPreferredSize(this.size);
            this.bar.setOpaque(false);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = -1;
            this.add((Component)this.bar, gridBagConstraints);
            this.styleGridBagConstraints(gridBagConstraints);
            this.add((Component)jLabel, gridBagConstraints);
        }

        public void setProgress(long l, long l2) {
            this.readSoFar = l;
            this.total = l2;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = this.bar.getX();
            int n2 = this.bar.getY();
            int n3 = this.bar.getHeight();
            int n4 = this.bar.getWidth();
            if (this.readSoFar > 0L && this.total > 0L) {
                double d = (double)this.readSoFar / (double)this.total;
                int n5 = (int)((double)n4 * d);
                graphics.setColor(Color.white);
                graphics.fillRect(n, n2, n4, n3);
                graphics.setColor(Color.blue);
                graphics.fillRect(n + 1, n2 + 1, n5 - 1, n3 - 1);
            }
        }

        private void styleGridBagConstraints(GridBagConstraints gridBagConstraints) {
            gridBagConstraints.insets = new Insets(0, 3, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
        }
    }

    static class DownloadPanel
    extends JPanel
    implements DownloadServiceListener {
        private final DownloadPanel self;
        private static final String DETAILS = Translator.R("ButShowDetails");
        private static final String HIDE_DETAILS = Translator.R("ButHideDetails");
        private String downloadName;
        private JLabel header = new JLabel();
        private final JButton detailsButton;
        private static final URL magnifyGlassUrl = ClassLoader.getSystemResource("net/sourceforge/jnlp/resources/showDownloadDetails.png");
        private static final URL redCrossUrl = ClassLoader.getSystemResource("net/sourceforge/jnlp/resources/hideDownloadDetails.png");
        private static final Icon magnifyGlassIcon = new ImageIcon(magnifyGlassUrl);
        private static final Icon redCrossIcon = new ImageIcon(redCrossUrl);
        private JLabel delimiter = new JLabel("");
        private List<ProgressPanel> progressPanels = new ArrayList<ProgressPanel>();
        private States state = States.ONE_JAR;
        private ProgressPanel mainProgressPanel;
        private List<URL> urls = new ArrayList<URL>();
        private List<ProgressPanel> panels = new ArrayList<ProgressPanel>();

        protected DownloadPanel(String string) {
            this.self = this;
            this.setLayout(new GridBagLayout());
            this.downloadName = string;
            this.add((Component)this.header, verticalNoClean);
            this.header.setFont(this.header.getFont().deriveFont(1));
            this.add((Component)this.delimiter, vertical);
            this.detailsButton = new JButton(magnifyGlassIcon);
            int n = magnifyGlassIcon.getIconWidth();
            int n2 = magnifyGlassIcon.getIconHeight();
            this.detailsButton.setPreferredSize(new Dimension(n + 2, n2 + 2));
            this.detailsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DownloadPanel.this.state == States.DETAILED) {
                        DownloadPanel.this.state = States.COLLAPSED;
                        DownloadPanel.this.detailsButton.setToolTipText(DETAILS);
                        DownloadPanel.this.detailsButton.setIcon(magnifyGlassIcon);
                        for (ProgressPanel progressPanel : DownloadPanel.this.progressPanels) {
                            DownloadPanel.this.remove(progressPanel);
                        }
                        DownloadPanel.this.add((Component)DownloadPanel.this.mainProgressPanel, verticalIndent);
                        this.recreateFrame(true);
                    } else {
                        DownloadPanel.this.state = States.DETAILED;
                        DownloadPanel.this.detailsButton.setToolTipText(HIDE_DETAILS);
                        DownloadPanel.this.detailsButton.setIcon(redCrossIcon);
                        DownloadPanel.this.remove(DownloadPanel.this.mainProgressPanel);
                        for (ProgressPanel progressPanel : DownloadPanel.this.progressPanels) {
                            DownloadPanel.this.add((Component)progressPanel, verticalIndent);
                        }
                        this.recreateFrame(false);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void recreateFrame(boolean bl) throws HeadlessException {
                    JFrame jFrame = frame;
                    frame = DefaultDownloadIndicator.createDownloadIndicatorFrame(bl);
                    frame.getContentPane().add((Component)DownloadPanel.this.self, vertical);
                    Object object = frameMutex;
                    synchronized (object) {
                        frame.pack();
                        DefaultDownloadIndicator.placeFrameToLowerRight();
                    }
                    frame.setVisible(true);
                    jFrame.dispose();
                }
            });
            this.setOverallPercent(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addProgressPanel(URL uRL, String string) {
            if (!this.urls.contains(uRL)) {
                ProgressPanel progressPanel = new ProgressPanel(uRL, string);
                if (this.state != States.COLLAPSED) {
                    this.add((Component)progressPanel, verticalIndent);
                }
                this.progressPanels.add(progressPanel);
                this.urls.add(uRL);
                this.panels.add(progressPanel);
                if (this.panels.size() == 2) {
                    this.remove(this.panels.get(0));
                    this.remove(this.panels.get(1));
                    this.remove(this.delimiter);
                    this.add((Component)this.detailsButton, vertical);
                    this.mainProgressPanel = new ProgressPanel();
                    this.add((Component)this.mainProgressPanel, verticalIndent);
                    this.state = States.COLLAPSED;
                }
                Object object = frameMutex;
                synchronized (object) {
                    frame.pack();
                    DefaultDownloadIndicator.placeFrameToLowerRight();
                }
            }
        }

        protected void update(final URL uRL, final String string, final long l, final long l2, final int n) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!DownloadPanel.this.urls.contains(uRL)) {
                        DownloadPanel.this.addProgressPanel(uRL, string);
                    }
                    DownloadPanel.this.setOverallPercent(n);
                    ProgressPanel progressPanel = (ProgressPanel)DownloadPanel.this.panels.get(DownloadPanel.this.urls.indexOf(uRL));
                    progressPanel.setProgress(l, l2);
                    progressPanel.repaint();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        public void setOverallPercent(int n) {
            this.header.setText(downloading + " " + this.downloadName + ": " + n + "% " + complete + ".");
            for (Container container = this.header.getParent(); container != null; container = container.getParent()) {
                container.invalidate();
                container.validate();
                if (!(container instanceof Window)) continue;
                ((Window)container).pack();
            }
            if (this.mainProgressPanel != null) {
                this.mainProgressPanel.setProgress(n, 100L);
                this.mainProgressPanel.repaint();
            }
        }

        @Override
        public void downloadFailed(URL uRL, String string) {
            this.update(uRL, string, -1L, -1L, -1);
        }

        @Override
        public void progress(URL uRL, String string, long l, long l2, int n) {
            this.update(uRL, string, l, l2, n);
        }

        @Override
        public void upgradingArchive(URL uRL, String string, int n, int n2) {
            this.update(uRL, string, n, 100L, n2);
        }

        @Override
        public void validating(URL uRL, String string, long l, long l2, int n) {
            this.update(uRL, string, l, l2, n);
        }

        private static enum States {
            ONE_JAR,
            COLLAPSED,
            DETAILED;

        }
    }
}

