/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jnlp.DownloadServiceListener;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.CacheEntry;
import net.sourceforge.jnlp.cache.CacheLRUWrapper;
import net.sourceforge.jnlp.cache.DownloadIndicator;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.PropertiesFile;
import net.sourceforge.jnlp.util.UrlUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class CacheUtil {
    private static final String setCacheDir = JNLPRuntime.getConfiguration().getProperty("deployment.user.cachedir");
    private static final String cacheDir = new File(setCacheDir != null ? setCacheDir : System.getProperty("java.io.tmpdir")).getPath();
    private static final CacheLRUWrapper lruHandler = CacheLRUWrapper.getInstance();
    private static final HashMap<String, FileLock> propertiesLockPool = new HashMap();

    public static boolean urlEquals(URL uRL, URL uRL2) {
        if (uRL == uRL2) {
            return true;
        }
        if (uRL == null || uRL2 == null) {
            return false;
        }
        if (CacheUtil.notNullUrlEquals(uRL, uRL2)) {
            return true;
        }
        try {
            URL uRL3 = UrlUtils.normalizeUrl(uRL);
            URL uRL4 = UrlUtils.normalizeUrl(uRL2);
            if (CacheUtil.notNullUrlEquals(uRL3, uRL4)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean notNullUrlEquals(URL uRL, URL uRL2) {
        return CacheUtil.compare(uRL.getProtocol(), uRL2.getProtocol(), true) && CacheUtil.compare(uRL.getHost(), uRL2.getHost(), true) && CacheUtil.compare(uRL.getPath(), uRL2.getPath(), false) && CacheUtil.compare(uRL.getQuery(), uRL2.getQuery(), false) && CacheUtil.compare(uRL.getRef(), uRL2.getRef(), false);
    }

    public static URL getCachedResource(URL uRL, Version version, UpdatePolicy updatePolicy) {
        ResourceTracker resourceTracker = new ResourceTracker();
        resourceTracker.addResource(uRL, version, null, updatePolicy);
        try {
            File file = resourceTracker.getCacheFile(uRL);
            return file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return uRL;
        }
    }

    private static boolean compare(String string, String string2, boolean bl) {
        if (string == string2) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        if (bl) {
            return string.equalsIgnoreCase(string2);
        }
        return string.equals(string2);
    }

    public static Permission getReadPermission(URL uRL, Version version) {
        if (CacheUtil.isCacheable(uRL, version)) {
            File file = CacheUtil.getCacheFile(uRL, version);
            return new FilePermission(file.getPath(), "read");
        }
        try {
            return uRL.openConnection().getPermission();
        }
        catch (IOException iOException) {
            OutputController.getLogger().log(iOException);
            return null;
        }
    }

    public static boolean clearCache() {
        if (!CacheUtil.okToClearCache()) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("CCannotClearCache"));
            return false;
        }
        File file = new File(cacheDir);
        if (!file.isDirectory()) {
            return false;
        }
        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Clearing cache directory: " + file);
        try {
            file = file.getCanonicalFile();
            FileUtils.recursiveDelete(file, file);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return true;
    }

    private static boolean okToClearCache() {
        File file = new File(JNLPRuntime.getConfiguration().getProperty("deployment.user.runningfile"));
        try {
            if (file.isFile()) {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                FileChannel fileChannel = fileOutputStream.getChannel();
                if (fileChannel.tryLock() == null) {
                    OutputController.getLogger().log("Other instances of netx are running");
                    return false;
                }
                OutputController.getLogger().log("No other instances of netx are running");
                return true;
            }
            OutputController.getLogger().log("No instance file found");
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isCurrent(URL uRL, Version version, URLConnection uRLConnection) {
        if (!CacheUtil.isCacheable(uRL, version)) {
            throw new IllegalArgumentException(Translator.R("CNotCacheable", uRL));
        }
        try {
            if (uRLConnection == null) {
                uRLConnection = uRL.openConnection();
            }
            uRLConnection.connect();
            CacheEntry cacheEntry = new CacheEntry(uRL, version);
            boolean bl = cacheEntry.isCurrent(uRLConnection);
            OutputController.getLogger().log("isCurrent: " + uRL + " = " + bl);
            return bl;
        }
        catch (Exception exception) {
            OutputController.getLogger().log(exception);
            return CacheUtil.isCached(uRL, version);
        }
    }

    public static boolean isCached(URL uRL, Version version) {
        if (!CacheUtil.isCacheable(uRL, version)) {
            throw new IllegalArgumentException(Translator.R("CNotCacheable", uRL));
        }
        CacheEntry cacheEntry = new CacheEntry(uRL, version);
        boolean bl = cacheEntry.isCached();
        OutputController.getLogger().log("isCached: " + uRL + " = " + bl);
        return bl;
    }

    public static boolean isCacheable(URL uRL, Version version) {
        if (uRL == null) {
            return false;
        }
        if (uRL.getProtocol().equals("file")) {
            return false;
        }
        return !uRL.getProtocol().equals("jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getCacheFile(URL uRL, Version version) {
        if (!CacheUtil.isCacheable(uRL, version)) {
            throw new IllegalArgumentException(Translator.R("CNotCacheable", uRL));
        }
        File file = null;
        CacheLRUWrapper cacheLRUWrapper = lruHandler;
        synchronized (cacheLRUWrapper) {
            lruHandler.lock();
            lruHandler.load();
            file = CacheUtil.getCacheFileIfExist(CacheUtil.urlToPath(uRL, ""));
            if (file == null) {
                file = CacheUtil.makeNewCacheFile(uRL, version);
            } else {
                lruHandler.store();
            }
            lruHandler.unlock();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getCacheFileIfExist(File file) {
        CacheLRUWrapper cacheLRUWrapper = lruHandler;
        synchronized (cacheLRUWrapper) {
            File file2 = null;
            List<Map.Entry<String, String>> list = lruHandler.getLRUSortedEntries();
            for (Map.Entry<String, String> entry : list) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                if (!CacheUtil.pathToURLPath(string2).equals(file.getPath())) continue;
                file2 = new File(string2);
                lruHandler.updateEntry(string);
                break;
            }
            return file2;
        }
    }

    private static String pathToURLPath(String string) {
        int n = cacheDir.length();
        int n2 = string.indexOf(File.separatorChar, n + 1);
        return string.substring(n2);
    }

    public static String getCacheParentDirectory(String string) {
        String string2 = string;
        String string3 = "";
        while (string2.startsWith(cacheDir) && !string2.equals(cacheDir) && !(string3 = new File(string2).getParent()).equals(cacheDir)) {
            string2 = string3;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File makeNewCacheFile(URL uRL, Version version) {
        CacheLRUWrapper cacheLRUWrapper = lruHandler;
        synchronized (cacheLRUWrapper) {
            lruHandler.lock();
            lruHandler.load();
            File file = null;
            for (long i = 0L; i < Long.MAX_VALUE; ++i) {
                String string = cacheDir + File.separator + i;
                File file2 = new File(string);
                if (file2.exists()) continue;
                try {
                    file = CacheUtil.urlToPath(uRL, string);
                    FileUtils.createParentDir(file);
                    File file3 = new File(file.getPath() + ".info");
                    FileUtils.createRestrictedFile(file3, true);
                    lruHandler.addEntry(lruHandler.generateKey(file.getPath()), file.getPath());
                }
                catch (IOException iOException) {
                    OutputController.getLogger().log(iOException);
                }
                break;
            }
            lruHandler.store();
            lruHandler.unlock();
            return file;
        }
    }

    public static OutputStream getOutputStream(URL uRL, Version version) throws IOException {
        File file = CacheUtil.getCacheFile(uRL, version);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        return new BufferedOutputStream(fileOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamCopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!(outputStream instanceof BufferedOutputStream)) {
            outputStream = new BufferedOutputStream(outputStream);
        }
        try {
            int n;
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }

    public static File urlToPath(URL uRL, String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(File.separatorChar);
        stringBuffer.append(uRL.getProtocol());
        stringBuffer.append(File.separatorChar);
        stringBuffer.append(uRL.getHost());
        stringBuffer.append(File.separatorChar);
        stringBuffer.append(uRL.getPath().replace('/', File.separatorChar));
        return new File(FileUtils.sanitizePath(stringBuffer.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForResources(ApplicationInstance applicationInstance, ResourceTracker resourceTracker, URL[] uRLArray, String string) {
        DownloadIndicator downloadIndicator = JNLPRuntime.getDefaultDownloadIndicator();
        DownloadServiceListener downloadServiceListener = null;
        try {
            if (downloadIndicator == null) {
                resourceTracker.waitForResources(uRLArray, 0L);
                return;
            }
            if (resourceTracker.waitForResources(uRLArray, downloadIndicator.getInitialDelay())) {
                return;
            }
            ArrayList<URL> arrayList = new ArrayList<URL>();
            for (URL uRL : uRLArray) {
                if (resourceTracker.checkResource(uRL)) continue;
                arrayList.add(uRL);
            }
            URL[] uRLArray2 = arrayList.toArray(new URL[arrayList.size()]);
            downloadServiceListener = downloadIndicator.getListener(applicationInstance, string, uRLArray2);
            do {
                long l = 0L;
                long l2 = 0L;
                for (URL uRL : uRLArray2) {
                    l2 += resourceTracker.getTotalSize(uRL);
                    l += resourceTracker.getAmountRead(uRL);
                }
                int n = (int)(100L * l / Math.max(1L, l2));
                for (URL uRL : uRLArray2) {
                    downloadServiceListener.progress(uRL, "version", resourceTracker.getAmountRead(uRL), resourceTracker.getTotalSize(uRL), n);
                }
            } while (!resourceTracker.waitForResources(uRLArray, downloadIndicator.getUpdateRate()));
            for (URL uRL : uRLArray2) {
                downloadServiceListener.progress(uRL, "version", resourceTracker.getTotalSize(uRL), resourceTracker.getTotalSize(uRL), 100);
            }
            if (downloadServiceListener != null) {
                downloadIndicator.disposeListener(downloadServiceListener);
            }
        }
        catch (InterruptedException interruptedException) {
            OutputController.getLogger().log(interruptedException);
        }
        finally {
            if (downloadServiceListener != null) {
                downloadIndicator.disposeListener(downloadServiceListener);
            }
        }
    }

    public static void cleanCache() {
        if (CacheUtil.okToClearCache()) {
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            lruHandler.load();
            long l = -1L;
            try {
                l = Long.parseLong(JNLPRuntime.getConfiguration().getProperty("deployment.cache.max.size"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            l <<= 20;
            long l2 = 0L;
            for (Map.Entry<String, String> entry : lruHandler.getLRUSortedEntries()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                File file = new File(string2);
                PropertiesFile propertiesFile = new PropertiesFile(new File(string2 + ".info"));
                boolean bl = Boolean.parseBoolean(propertiesFile.getProperty("delete"));
                String string3 = file.getPath().substring(cacheDir.length());
                string3 = cacheDir + string3.substring(0, string3.indexOf(File.separatorChar, 1));
                long l3 = file.length();
                if (hashSet.contains(file.getPath().substring(string3.length()))) {
                    lruHandler.removeEntry(string);
                    continue;
                }
                if (bl || !file.isFile() || l >= 0L && l2 + l3 > l) {
                    lruHandler.removeEntry(string);
                    hashSet2.add(string3);
                    continue;
                }
                l2 += l3;
                hashSet.add(file.getPath().substring(string3.length()));
                for (File file2 : file.getParentFile().listFiles()) {
                    if (file2.equals(file) || file2.equals(propertiesFile.getStoreFile())) continue;
                    try {
                        FileUtils.recursiveDelete(file2, file2);
                    }
                    catch (IOException iOException) {
                        OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException);
                    }
                }
            }
            lruHandler.store();
            hashSet2.add(cacheDir + File.separator + "http");
            hashSet2.add(cacheDir + File.separator + "https");
            CacheUtil.removeSetOfDirectories(hashSet2);
        }
    }

    private static void removeSetOfDirectories(Set<String> set) {
        for (String string : set) {
            File file = new File(string);
            try {
                FileUtils.recursiveDelete(file, file);
            }
            catch (IOException iOException) {}
        }
    }

    public static void lockFile(PropertiesFile propertiesFile) {
        String string = propertiesFile.getStoreFile().getPath();
        try {
            propertiesLockPool.put(string, FileUtils.getFileLock(string, false, true));
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, fileNotFoundException);
        }
    }

    public static void unlockFile(PropertiesFile propertiesFile) {
        File file = propertiesFile.getStoreFile();
        FileLock fileLock = propertiesLockPool.get(file.getPath());
        try {
            if (fileLock == null) {
                return;
            }
            fileLock.release();
            fileLock.channel().close();
            propertiesLockPool.remove(file.getPath());
        }
        catch (IOException iOException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException);
        }
    }
}

