/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.jnlp.ExtensionDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.JREDesc;
import net.sourceforge.jnlp.PackageDesc;
import net.sourceforge.jnlp.PropertyDesc;

public class ResourcesDesc {
    private Locale[] locales;
    private String[] os;
    private String[] arch;
    private JNLPFile jnlpFile;
    private List<Object> resources = new ArrayList<Object>();

    public ResourcesDesc(JNLPFile jNLPFile, Locale[] localeArray, String[] stringArray, String[] stringArray2) {
        this.jnlpFile = jNLPFile;
        this.locales = localeArray;
        this.os = stringArray;
        this.arch = stringArray2;
    }

    public JREDesc[] getJREs() {
        List<JREDesc> list = this.getResources(JREDesc.class);
        return list.toArray(new JREDesc[list.size()]);
    }

    public static JARDesc getMainJAR(JARDesc[] jARDescArray) {
        return ResourcesDesc.getMainJAR(Arrays.asList(jARDescArray));
    }

    public static JARDesc getMainJAR(List<JARDesc> list) {
        for (JARDesc jARDesc : list) {
            if (!jARDesc.isMain()) continue;
            return jARDesc;
        }
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public JARDesc getMainJAR() {
        return ResourcesDesc.getMainJAR(this.getJARs());
    }

    public JARDesc[] getJARs() {
        List<JARDesc> list = this.getResources(JARDesc.class);
        return list.toArray(new JARDesc[list.size()]);
    }

    public JARDesc[] getJARs(String string) {
        List<JARDesc> list = this.getResources(JARDesc.class);
        int n = list.size();
        while (n-- > 0) {
            JARDesc jARDesc = list.get(n);
            if (("" + jARDesc.getPart()).equals("" + string)) continue;
            list.remove(n);
        }
        return list.toArray(new JARDesc[list.size()]);
    }

    public ExtensionDesc[] getExtensions() {
        List<ExtensionDesc> list = this.getResources(ExtensionDesc.class);
        return list.toArray(new ExtensionDesc[list.size()]);
    }

    public PackageDesc[] getPackages() {
        List<PackageDesc> list = this.getResources(PackageDesc.class);
        return list.toArray(new PackageDesc[list.size()]);
    }

    public PackageDesc[] getPackages(String string) {
        List<PackageDesc> list = this.getResources(PackageDesc.class);
        int n = list.size();
        while (n-- > 0) {
            PackageDesc packageDesc = list.get(n);
            if (packageDesc.matches(string)) continue;
            list.remove(n);
        }
        return list.toArray(new PackageDesc[list.size()]);
    }

    public PropertyDesc[] getProperties() {
        List<PropertyDesc> list = this.getResources(PropertyDesc.class);
        return list.toArray(new PropertyDesc[list.size()]);
    }

    public Map<String, String> getPropertiesMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List<PropertyDesc> list = this.getResources(PropertyDesc.class);
        for (PropertyDesc propertyDesc : list) {
            hashMap.put(propertyDesc.getKey(), propertyDesc.getValue());
        }
        return hashMap;
    }

    public String[] getOS() {
        return this.os;
    }

    public String[] getArch() {
        return this.arch;
    }

    public Locale[] getLocales() {
        return this.locales;
    }

    public JNLPFile getJNLPFile() {
        return this.jnlpFile;
    }

    public <T> List<T> getResources(Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Object object : this.resources) {
            if (!clazz.isAssignableFrom(object.getClass())) continue;
            arrayList.add(clazz.cast(object));
        }
        return arrayList;
    }

    public void addResource(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null resource");
        }
        this.resources.add(object);
    }
}

