/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.ApplicationDesc;
import net.sourceforge.jnlp.AssociationDesc;
import net.sourceforge.jnlp.ComponentDesc;
import net.sourceforge.jnlp.ExtensionDesc;
import net.sourceforge.jnlp.IconDesc;
import net.sourceforge.jnlp.InformationDesc;
import net.sourceforge.jnlp.InstallerDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.JREDesc;
import net.sourceforge.jnlp.LaunchDesc;
import net.sourceforge.jnlp.MenuDesc;
import net.sourceforge.jnlp.MissingInformationException;
import net.sourceforge.jnlp.MissingTitleException;
import net.sourceforge.jnlp.MissingVendorException;
import net.sourceforge.jnlp.Node;
import net.sourceforge.jnlp.PackageDesc;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.ParserSettings;
import net.sourceforge.jnlp.PropertyDesc;
import net.sourceforge.jnlp.RelatedContentDesc;
import net.sourceforge.jnlp.RequiredElementException;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.ShortcutDesc;
import net.sourceforge.jnlp.UpdateDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.OutputController;

class Parser {
    private JNLPFile file;
    private Node root;
    private Version spec;
    private URL base;
    private URL codebase;
    private URL fileLocation;
    private boolean strict;
    private boolean allowExtensions;

    public Parser(JNLPFile jNLPFile, URL uRL, Node node, ParserSettings parserSettings) throws ParseException {
        this(jNLPFile, uRL, node, parserSettings, null);
    }

    public Parser(JNLPFile jNLPFile, URL uRL, Node node, ParserSettings parserSettings, URL uRL2) throws ParseException {
        this.file = jNLPFile;
        this.root = node;
        this.strict = parserSettings.isStrict();
        this.allowExtensions = parserSettings.isExtensionAllowed();
        if (node == null || !node.getNodeName().equals("jnlp")) {
            throw new ParseException(Translator.R("PInvalidRoot"));
        }
        this.spec = this.getVersion(node, "spec", "1.0+");
        try {
            this.codebase = this.addSlash(this.getURL(node, "codebase", uRL));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (this.codebase == null) {
            this.codebase = uRL2;
        }
        this.base = this.codebase != null ? this.codebase : uRL;
        this.fileLocation = this.getURL(node, "href", this.base);
        node.normalize();
    }

    public Version getFileVersion() {
        return this.getVersion(this.root, "version", null);
    }

    public URL getFileLocation() {
        return this.fileLocation;
    }

    public URL getCodeBase() {
        return this.codebase;
    }

    public Version getSpecVersion() {
        return this.spec;
    }

    public UpdateDesc getUpdate(Node node) throws ParseException {
        UpdateDesc updateDesc = null;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!node2.getNodeName().equals("update")) continue;
            if (this.strict && updateDesc != null) {
                throw new ParseException(Translator.R("PTwoUpdates"));
            }
            Node node3 = node2;
            String string = this.getAttribute(node3, "check", "timeout");
            UpdateDesc.Check check = string.equals("always") ? UpdateDesc.Check.ALWAYS : (string.equals("timeout") ? UpdateDesc.Check.TIMEOUT : (string.equals("background") ? UpdateDesc.Check.BACKGROUND : UpdateDesc.Check.TIMEOUT));
            String string2 = this.getAttribute(node3, "policy", "always");
            UpdateDesc.Policy policy = string2.equals("always") ? UpdateDesc.Policy.ALWAYS : (string2.equals("prompt-update") ? UpdateDesc.Policy.PROMPT_UPDATE : (string2.equals("prompt-run") ? UpdateDesc.Policy.PROMPT_RUN : UpdateDesc.Policy.ALWAYS));
            updateDesc = new UpdateDesc(check, policy);
        }
        if (updateDesc == null) {
            updateDesc = new UpdateDesc(UpdateDesc.Check.TIMEOUT, UpdateDesc.Policy.ALWAYS);
        }
        return updateDesc;
    }

    public List<ResourcesDesc> getResources(Node node, boolean bl) throws ParseException {
        ArrayList<ResourcesDesc> arrayList = new ArrayList<ResourcesDesc>();
        Node[] nodeArray = Parser.getChildNodes(node, "resources");
        if (nodeArray.length == 0 && !bl) {
            throw new ParseException(Translator.R("PNoResources"));
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            arrayList.add(this.getResourcesDesc(nodeArray[i], bl));
        }
        return arrayList;
    }

    public ResourcesDesc getResourcesDesc(Node node, boolean bl) throws ParseException {
        boolean bl2 = false;
        ResourcesDesc resourcesDesc = new ResourcesDesc(this.file, this.getLocales(node), this.splitString(this.getAttribute(node, "os", null)), this.splitString(this.getAttribute(node, "arch", null)));
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String string = node2.getNodeName();
            if ("nativelib".equals(string) && !this.isTrustedEnvironment()) {
                throw new ParseException(Translator.R("PUntrustedNative"));
            }
            if ("j2se".equals(string) || "java".equals(string)) {
                if (Parser.getChildNode(this.root, "component-desc") != null && this.strict) {
                    throw new ParseException(Translator.R("PExtensionHasJ2SE"));
                }
                if (!bl) {
                    resourcesDesc.addResource(this.getJRE(node2));
                } else {
                    throw new ParseException(Translator.R("PInnerJ2SE"));
                }
            }
            if ("jar".equals(string) || "nativelib".equals(string)) {
                JARDesc jARDesc = this.getJAR(node2);
                if (jARDesc.isMain()) {
                    if (bl2 && this.strict) {
                        throw new ParseException(Translator.R("PTwoMains"));
                    }
                    bl2 = true;
                }
                resourcesDesc.addResource(jARDesc);
            }
            if ("extension".equals(string)) {
                resourcesDesc.addResource(this.getExtension(node2));
            }
            if ("property".equals(string)) {
                resourcesDesc.addResource(this.getProperty(node2));
            }
            if (!"package".equals(string)) continue;
            resourcesDesc.addResource(this.getPackage(node2));
        }
        return resourcesDesc;
    }

    public JREDesc getJRE(Node node) throws ParseException {
        Version version = this.getVersion(node, "version", null);
        URL uRL = this.getURL(node, "href", this.base);
        String string = this.getAttribute(node, "java-vm-args", null);
        try {
            this.checkVMArgs(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = null;
        }
        String string2 = this.getAttribute(node, "initial-heap-size", null);
        String string3 = this.getAttribute(node, "max-heap-size", null);
        List<ResourcesDesc> list = this.getResources(node, true);
        this.getRequiredAttribute(node, "version", null);
        return new JREDesc(version, uRL, string, string2, string3, list);
    }

    public JARDesc getJAR(Node node) throws ParseException {
        boolean bl = "nativelib".equals(node.getNodeName());
        URL uRL = this.getRequiredURL(node, "href", this.base);
        Version version = this.getVersion(node, "version", null);
        String string = this.getAttribute(node, "part", null);
        boolean bl2 = "true".equals(this.getAttribute(node, "main", "false"));
        boolean bl3 = "lazy".equals(this.getAttribute(node, "download", "eager"));
        if (bl && bl2 && this.strict) {
            throw new ParseException(Translator.R("PNativeHasMain"));
        }
        return new JARDesc(uRL, version, string, bl3, bl2, bl, true);
    }

    public ExtensionDesc getExtension(Node node) throws ParseException {
        String string = this.getAttribute(node, "name", null);
        Version version = this.getVersion(node, "version", null);
        URL uRL = this.getRequiredURL(node, "href", this.base);
        ExtensionDesc extensionDesc = new ExtensionDesc(string, version, uRL);
        Node[] nodeArray = Parser.getChildNodes(node, "ext-download");
        for (int i = 0; i < nodeArray.length; ++i) {
            boolean bl = "lazy".equals(this.getAttribute(nodeArray[i], "download", "eager"));
            extensionDesc.addPart(this.getRequiredAttribute(nodeArray[i], "ext-part", null), this.getAttribute(nodeArray[i], "part", null), bl);
        }
        return extensionDesc;
    }

    public PropertyDesc getProperty(Node node) throws ParseException {
        String string = this.getRequiredAttribute(node, "name", null);
        String string2 = this.getRequiredAttribute(node, "value", "");
        return new PropertyDesc(string, string2);
    }

    public PackageDesc getPackage(Node node) throws ParseException {
        String string = this.getRequiredAttribute(node, "name", null);
        String string2 = this.getRequiredAttribute(node, "part", "");
        boolean bl = this.getAttribute(node, "recursive", "false").equals("true");
        return new PackageDesc(string, string2, bl);
    }

    void checkForInformation() throws RequiredElementException {
        OutputController.getLogger().log("Homepage: " + this.file.getInformation().getHomepage());
        OutputController.getLogger().log("Description: " + this.file.getInformation().getDescription());
        String string = this.file.getTitle();
        String string2 = this.file.getVendor();
        if (string == null || string.trim().isEmpty()) {
            throw new MissingTitleException();
        }
        OutputController.getLogger().log("Acceptable title tag found, contains: " + string);
        if (string2 == null || string2.trim().isEmpty()) {
            throw new MissingVendorException();
        }
        OutputController.getLogger().log("Acceptable vendor tag found, contains: " + string2);
    }

    public List<InformationDesc> getInfo(Node node) throws ParseException {
        ArrayList<InformationDesc> arrayList = new ArrayList<InformationDesc>();
        Node[] nodeArray = Parser.getChildNodes(node, "information");
        if (nodeArray.length == 0) {
            throw new MissingInformationException();
        }
        for (Node node2 : nodeArray) {
            arrayList.add(this.getInformationDesc(node2));
        }
        return arrayList;
    }

    public InformationDesc getInformationDesc(Node node) throws ParseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Locale[] localeArray = this.getLocales(node);
        InformationDesc informationDesc = new InformationDesc(localeArray);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String string = node2.getNodeName();
            if ("title".equals(string)) {
                this.addInfo(informationDesc, node2, null, this.getSpanText(node2, false));
            }
            if ("vendor".equals(string)) {
                this.addInfo(informationDesc, node2, null, this.getSpanText(node2, false));
            }
            if ("description".equals(string)) {
                String string2 = this.getAttribute(node2, "kind", "default");
                if (arrayList.contains(string2) && this.strict) {
                    throw new ParseException(Translator.R("PTwoDescriptions", string2));
                }
                arrayList.add(string2);
                this.addInfo(informationDesc, node2, string2, this.getSpanText(node2, false));
            }
            if ("homepage".equals(string)) {
                this.addInfo(informationDesc, node2, null, this.getRequiredURL(node2, "href", this.base));
            }
            if ("icon".equals(string)) {
                this.addInfo(informationDesc, node2, this.getAttribute(node2, "kind", "default"), this.getIcon(node2));
            }
            if ("offline-allowed".equals(string)) {
                this.addInfo(informationDesc, node2, null, Boolean.TRUE);
            }
            if ("sharing-allowed".equals(string)) {
                if (this.strict && !this.allowExtensions) {
                    throw new ParseException(Translator.R("PSharing"));
                }
                this.addInfo(informationDesc, node2, null, Boolean.TRUE);
            }
            if ("association".equals(string)) {
                this.addInfo(informationDesc, node2, null, this.getAssociation(node2));
            }
            if ("shortcut".equals(string)) {
                this.addInfo(informationDesc, node2, null, this.getShortcut(node2));
            }
            if (!"related-content".equals(string)) continue;
            this.addInfo(informationDesc, node2, null, this.getRelatedContent(node2));
        }
        return informationDesc;
    }

    protected void addInfo(InformationDesc informationDesc, Node node, String string, Object object) {
        String string2;
        String string3 = string2 = string == null ? "" : "-" + string;
        if (node == null) {
            return;
        }
        informationDesc.addItem(node.getNodeName() + string2, object);
    }

    public IconDesc getIcon(Node node) throws ParseException {
        int n = Integer.parseInt(this.getAttribute(node, "width", "-1"));
        int n2 = Integer.parseInt(this.getAttribute(node, "height", "-1"));
        int n3 = Integer.parseInt(this.getAttribute(node, "size", "-1"));
        int n4 = Integer.parseInt(this.getAttribute(node, "depth", "-1"));
        URL uRL = this.getRequiredURL(node, "href", this.base);
        String string = this.getAttribute(node, "kind", "default");
        return new IconDesc(uRL, string, n, n2, n4, n3);
    }

    public SecurityDesc getSecurity(Node node) throws ParseException {
        Node[] nodeArray = Parser.getChildNodes(node, "security");
        if (nodeArray.length > 1 && this.strict) {
            throw new ParseException(Translator.R("PTwoSecurity"));
        }
        Object object = SecurityDesc.SANDBOX_PERMISSIONS;
        if (nodeArray.length == 0) {
            object = SecurityDesc.SANDBOX_PERMISSIONS;
        } else if (null != Parser.getChildNode(nodeArray[0], "all-permissions")) {
            object = SecurityDesc.ALL_PERMISSIONS;
        } else if (null != Parser.getChildNode(nodeArray[0], "j2ee-application-client-permissions")) {
            object = SecurityDesc.J2EE_PERMISSIONS;
        } else if (this.strict) {
            throw new ParseException(Translator.R("PEmptySecurity"));
        }
        if (this.base != null) {
            return new SecurityDesc(this.file, object, this.base.getHost());
        }
        return new SecurityDesc(this.file, object, null);
    }

    protected boolean isTrustedEnvironment() {
        Node node = Parser.getChildNode(this.root, "security");
        return node != null && (Parser.getChildNode(node, "all-permissions") != null || Parser.getChildNode(node, "j2ee-application-client-permissions") != null);
    }

    public LaunchDesc getLauncher(Node node) throws ParseException {
        if (1 < Parser.getChildNodes(node, "applet-desc").length + Parser.getChildNodes(node, "application-desc").length + Parser.getChildNodes(node, "installer-desc").length) {
            throw new ParseException(Translator.R("PTwoDescriptors"));
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String string = node2.getNodeName();
            if ("applet-desc".equals(string)) {
                return this.getApplet(node2);
            }
            if ("application-desc".equals(string)) {
                return this.getApplication(node2);
            }
            if (!"installer-desc".equals(string)) continue;
            return this.getInstaller(node2);
        }
        return null;
    }

    public AppletDesc getApplet(Node node) throws ParseException {
        String string = this.getRequiredAttribute(node, "name", Translator.R("PUnknownApplet"));
        String string2 = this.getRequiredAttribute(node, "main-class", null);
        URL uRL = this.getURL(node, "documentbase", this.base);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(this.getRequiredAttribute(node, "width", "100"));
            n2 = Integer.parseInt(this.getRequiredAttribute(node, "height", "100"));
        }
        catch (NumberFormatException numberFormatException) {
            if (n <= 0) {
                throw new ParseException(Translator.R("PBadWidth"));
            }
            throw new ParseException(Translator.R("PBadWidth"));
        }
        Node[] nodeArray = Parser.getChildNodes(node, "param");
        for (int i = 0; i < nodeArray.length; ++i) {
            hashMap.put(this.getRequiredAttribute(nodeArray[i], "name", null), this.getRequiredAttribute(nodeArray[i], "value", ""));
        }
        return new AppletDesc(string, string2, uRL, n, n2, hashMap);
    }

    public ApplicationDesc getApplication(Node node) throws ParseException {
        String string = this.getAttribute(node, "main-class", null);
        ArrayList<String> arrayList = new ArrayList<String>();
        Node[] nodeArray = Parser.getChildNodes(node, "argument");
        for (int i = 0; i < nodeArray.length; ++i) {
            arrayList.add(this.getSpanText(nodeArray[i]));
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return new ApplicationDesc(string, stringArray);
    }

    public ComponentDesc getComponent(Node node) throws ParseException {
        if (1 < Parser.getChildNodes(node, "component-desc").length) {
            throw new ParseException(Translator.R("PTwoDescriptors"));
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String string = node2.getNodeName();
            if (!"component-desc".equals(string)) continue;
            return new ComponentDesc();
        }
        return null;
    }

    public InstallerDesc getInstaller(Node node) {
        String string = this.getAttribute(node, "main-class", null);
        return new InstallerDesc(string);
    }

    public AssociationDesc getAssociation(Node node) throws ParseException {
        String[] stringArray = this.getRequiredAttribute(node, "extensions", null).split(" ");
        String string = this.getRequiredAttribute(node, "mime-type", null);
        return new AssociationDesc(string, stringArray);
    }

    public ShortcutDesc getShortcut(Node node) throws ParseException {
        Object object;
        String string = this.getAttribute(node, "online", "true");
        boolean bl = Boolean.valueOf(string);
        boolean bl2 = false;
        MenuDesc menuDesc = null;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            object = node2.getNodeName();
            if ("desktop".equals(object)) {
                if (bl2 && this.strict) {
                    throw new ParseException(Translator.R("PTwoDesktops"));
                }
                bl2 = true;
                continue;
            }
            if (!"menu".equals(object)) continue;
            if (menuDesc != null && this.strict) {
                throw new ParseException(Translator.R("PTwoMenus"));
            }
            menuDesc = this.getMenu(node2);
        }
        object = new ShortcutDesc(bl, bl2);
        if (menuDesc != null) {
            ((ShortcutDesc)object).addMenu(menuDesc);
        }
        return object;
    }

    public MenuDesc getMenu(Node node) {
        String string = this.getAttribute(node, "submenu", null);
        return new MenuDesc(string);
    }

    public RelatedContentDesc getRelatedContent(Node node) throws ParseException {
        Object object;
        this.getRequiredAttribute(node, "href", null);
        URL uRL = this.getURL(node, "href", this.base);
        String string = null;
        String string2 = null;
        IconDesc iconDesc = null;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            object = node2.getNodeName();
            if ("title".equals(object)) {
                if (string != null && this.strict) {
                    throw new ParseException(Translator.R("PTwoTitles"));
                }
                string = this.getSpanText(node2, false);
                continue;
            }
            if ("description".equals(object)) {
                if (string2 != null && this.strict) {
                    throw new ParseException(Translator.R("PTwoDescriptions"));
                }
                string2 = this.getSpanText(node2, false);
                continue;
            }
            if (!"icon".equals(object)) continue;
            if (iconDesc != null && this.strict) {
                throw new ParseException(Translator.R("PTwoIcons"));
            }
            iconDesc = this.getIcon(node2);
        }
        object = new RelatedContentDesc(uRL);
        ((RelatedContentDesc)object).setDescription(string2);
        ((RelatedContentDesc)object).setIconDesc(iconDesc);
        ((RelatedContentDesc)object).setTitle(string);
        return object;
    }

    public String[] splitString(String string) {
        if (string == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuilder.setLength(0);
            while (true) {
                stringBuilder.append(stringTokenizer.nextToken());
                if (!stringTokenizer.hasMoreTokens() || stringBuilder.charAt(stringBuilder.length() - 1) != '\\') break;
                stringBuilder.setCharAt(stringBuilder.length() - 1, ' ');
            }
            int n = stringBuilder.length();
            while (n-- > 0) {
                if (stringBuilder.charAt(n) != '\\') continue;
                stringBuilder.deleteCharAt(n--);
            }
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Locale[] getLocales(Node node) {
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        String[] stringArray = this.splitString(this.getAttribute(node, "locale", ""));
        for (int i = 0; i < stringArray.length; ++i) {
            Locale locale = this.getLocale(stringArray[i]);
            if (locale == null) continue;
            arrayList.add(locale);
        }
        return arrayList.toArray(new Locale[arrayList.size()]);
    }

    public Locale getLocale(String string) {
        if (string.length() < 2) {
            return null;
        }
        String string2 = string.substring(0, 2);
        String string3 = string.length() < 5 ? "" : string.substring(3, 5);
        String string4 = string.length() > 7 ? string.substring(6) : "";
        return new Locale(string2, string3, string4);
    }

    public String getSpanText(Node node) throws ParseException {
        return this.getSpanText(node, true);
    }

    public String getSpanText(Node node, boolean bl) throws ParseException {
        if (node == null) {
            return null;
        }
        String string = node.getNodeValue();
        if (bl) {
            return string;
        }
        if (string == null) {
            return null;
        }
        return string.replaceAll("\\s+", " ");
    }

    public static Node getChildNode(Node node, String string) {
        Node[] nodeArray = Parser.getChildNodes(node, string);
        if (nodeArray.length == 0) {
            return null;
        }
        return nodeArray[0];
    }

    public static Node[] getChildNodes(Node node, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!node2.getNodeName().equals(string)) continue;
            arrayList.add(node2);
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    private URL addSlash(URL uRL) {
        if (uRL == null) {
            return null;
        }
        if (!uRL.toString().endsWith("/")) {
            try {
                uRL = new URL(uRL.toString() + "/");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL;
    }

    public URL getRequiredURL(Node node, String string, URL uRL) throws ParseException {
        this.getRequiredAttribute(node, string, "");
        return this.getURL(node, string, uRL);
    }

    /*
     * Loose catch block
     */
    public URL getURL(Node node, String string, URL uRL) throws ParseException {
        String string2;
        block8: {
            string2 = this.getAttribute(node, string, null);
            if (string2 == null) {
                return null;
            }
            if (uRL != null) break block8;
            return new URL(string2);
            {
                catch (MalformedURLException malformedURLException) {
                    if (uRL == null) {
                        throw new ParseException(Translator.R("PBadNonrelativeUrl", node.getNodeName(), string2));
                    }
                    throw new ParseException(Translator.R("PBadRelativeUrl", node.getNodeName(), string2, uRL));
                }
            }
        }
        try {
            return new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            URL uRL2 = new URL(uRL, string2);
            if (!uRL2.toString().startsWith(uRL.toString()) && !uRL.toString().startsWith(uRL2.toString()) && this.strict) {
                throw new ParseException(Translator.R("PUrlNotInCodebase", node.getNodeName(), string2, uRL));
            }
            return uRL2;
        }
    }

    public Version getVersion(Node node, String string, String string2) {
        String string3 = this.getAttribute(node, string, string2);
        if (string3 == null) {
            return null;
        }
        return new Version(string3);
    }

    private void checkVMArgs(String string) throws IllegalArgumentException {
        if (string == null) {
            return;
        }
        List<String> list = Arrays.asList(this.getValidVMArguments());
        List<String> list2 = Arrays.asList(this.getValidStartingVMArguments());
        String[] stringArray = string.split(" ");
        boolean bl = false;
        for (String string2 : stringArray) {
            bl = false;
            if (list.contains(string2)) {
                bl = true;
            } else {
                for (String string3 : list2) {
                    if (!string2.startsWith(string3)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            throw new IllegalArgumentException(string2);
        }
    }

    private String[] getValidVMArguments() {
        return new String[]{"-d32", "-client", "-server", "-verbose", "-version", "-showversion", "-help", "-X", "-ea", "-enableassertions", "-da", "-disableassertions", "-esa", "-enablesystemassertions", "-dsa", "-disablesystemassertions", "-Xmixed", "-Xint", "-Xnoclassgc", "-Xincgc", "-Xbatch", "-Xprof", "-Xdebug", "-Xfuture", "-Xrs", "-XX:+ForceTimeHighResolution", "-XX:-ForceTimeHighResolution"};
    }

    private String[] getValidStartingVMArguments() {
        return new String[]{"-ea", "-enableassertions", "-da", "-disableassertions", "-verbose", "-Xms", "-Xmx", "-Xss", "-XX:NewRatio", "-XX:NewSize", "-XX:MaxNewSize", "-XX:PermSize", "-XX:MaxPermSize", "-XX:MaxHeapFreeRatio", "-XX:MinHeapFreeRatio", "-XX:UseSerialGC", "-XX:ThreadStackSize", "-XX:MaxInlineSize", "-XX:ReservedCodeCacheSize", "-XX:MaxDirectMemorySize"};
    }

    public String getRequiredAttribute(Node node, String string, String string2) throws ParseException {
        String string3 = this.getAttribute(node, string, null);
        if (!(string3 != null && string3.length() != 0 || !this.strict && string2 != null)) {
            throw new ParseException(Translator.R("PNeedsAttribute", node.getNodeName(), string));
        }
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public String getAttribute(Node node, String string, String string2) {
        String string3 = node.getAttribute(string);
        if (string3 == null || string3.length() == 0) {
            return string2;
        }
        return string3;
    }

    public static Node getRootNode(InputStream inputStream, ParserSettings parserSettings) throws ParseException {
        String string = null;
        string = parserSettings.isMalformedXmlAllowed() ? "net.sourceforge.jnlp.MalformedXMLParser" : "net.sourceforge.jnlp.XMLParser";
        try {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Class.forName("net.sourceforge.jnlp.XMLParser");
            }
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("getRootNode", InputStream.class);
            return (Node)method.invoke(obj, inputStream);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof ParseException) {
                throw (ParseException)invocationTargetException.getCause();
            }
            throw new ParseException(Translator.R("PBadXML"), invocationTargetException);
        }
        catch (Exception exception) {
            throw new ParseException(Translator.R("PBadXML"), exception);
        }
    }
}

