/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.javascript;

import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.ClassShutter;

final class RhinoClassShutter
implements ClassShutter {
    private static Map<String, Boolean> protectedClasses;
    private static RhinoClassShutter theInstance;

    private RhinoClassShutter() {
    }

    static synchronized ClassShutter getInstance() {
        if (theInstance == null) {
            theInstance = new RhinoClassShutter();
            protectedClasses = new HashMap<String, Boolean>();
            protectedClasses.put("java.security.AccessController", Boolean.TRUE);
        }
        return theInstance;
    }

    public boolean visibleToScripts(String string) {
        int n;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n = string.lastIndexOf(".")) != -1) {
            try {
                securityManager.checkPackageAccess(string.substring(0, n));
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        return protectedClasses.get(string) == null;
    }
}

