/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import sun.applet.PluginDebug;

class Signature {
    private String signature;
    private int currentIndex;
    private List<Class<?>> typeList;
    private static final char ARRAY = '[';
    private static final char OBJECT = 'L';
    private static final char SIGNATURE_ENDCLASS = ';';
    private static final char SIGNATURE_FUNC = '(';
    private static final char SIGNATURE_ENDFUNC = ')';
    private static final char VOID = 'V';
    private static final char BOOLEAN = 'Z';
    private static final char BYTE = 'B';
    private static final char CHARACTER = 'C';
    private static final char SHORT = 'S';
    private static final char INTEGER = 'I';
    private static final char LONG = 'J';
    private static final char FLOAT = 'F';
    private static final char DOUBLE = 'D';

    private String nextTypeName() {
        char c = this.signature.charAt(this.currentIndex++);
        switch (c) {
            case '[': {
                return this.nextTypeName() + "[]";
            }
            case 'L': {
                int n = this.signature.indexOf(59, this.currentIndex);
                String string = this.signature.substring(this.currentIndex, n);
                string = string.replace('/', '.');
                this.currentIndex = n + 1;
                return string;
            }
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'S': {
                return "short";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'F': {
                return "float";
            }
            case 'D': {
                return "double";
            }
            case ')': {
                return null;
            }
            case '(': {
                return this.nextTypeName();
            }
        }
        throw new IllegalArgumentException("Invalid JNI signature character '" + c + "'");
    }

    public Signature(String string, ClassLoader classLoader) {
        this.signature = string;
        this.currentIndex = 0;
        this.typeList = new ArrayList(10);
        while (this.currentIndex < string.length()) {
            String string2 = this.nextTypeName();
            if (string2 == null) continue;
            Class<?> clazz = Signature.primitiveNameToType(string2);
            if (clazz != null) {
                this.typeList.add(clazz);
                continue;
            }
            int n = 0;
            int n2 = string2.indexOf(91);
            if (n2 != -1) {
                String string3 = string2.substring(0, n2);
                ++n;
                n2 = string2.indexOf(91, n2 + 1);
                while (n2 != -1) {
                    ++n;
                    n2 = string2.indexOf(91, n2 + 1);
                }
                int[] nArray = new int[n];
                clazz = Signature.primitiveNameToType(string3);
                if (clazz != null) {
                    this.typeList.add(Array.newInstance(clazz, nArray).getClass());
                    continue;
                }
                this.typeList.add(Array.newInstance(Signature.getClass(string3, classLoader), nArray).getClass());
                continue;
            }
            this.typeList.add(Signature.getClass(string2, classLoader));
        }
        if (string.length() < 2) {
            throw new IllegalArgumentException("Invalid JNI signature '" + string + "'");
        }
    }

    public static Class<?> getClass(String string, ClassLoader classLoader) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            PluginDebug.debug("Class ", string, " not found in primordial loader. Looking in ", classLoader);
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new RuntimeException(new ClassNotFoundException("Unable to find class " + string));
            }
        }
        return clazz;
    }

    public static Class<?> primitiveNameToType(String string) {
        if (string.equals("void")) {
            return Void.TYPE;
        }
        if (string.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (string.equals("byte")) {
            return Byte.TYPE;
        }
        if (string.equals("char")) {
            return Character.TYPE;
        }
        if (string.equals("short")) {
            return Short.TYPE;
        }
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("long")) {
            return Long.TYPE;
        }
        if (string.equals("float")) {
            return Float.TYPE;
        }
        if (string.equals("double")) {
            return Double.TYPE;
        }
        return null;
    }

    public Class<?>[] getClassArray() {
        return this.typeList.subList(0, this.typeList.size()).toArray(new Class[0]);
    }
}

