/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.splashscreen.parts;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.about.AboutDialog;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.splashscreen.parts.InfoItem;
import net.sourceforge.jnlp.splashscreen.parts.InformationElement;
import net.sourceforge.jnlp.util.BasicExceptionDialog;
import net.sourceforge.jnlp.util.logging.OutputController;

public class JEditorPaneBasedExceptionDialog
extends JDialog
implements HyperlinkListener {
    private JButton closeButton;
    private JButton closeAndCopyButton;
    private JButton homeButton;
    private JButton aboutButton;
    private JButton consoleButton;
    private JEditorPane htmlErrorAndHelpPanel;
    private JLabel exceptionLabel;
    private JLabel iconLabel;
    private JPanel mainPanel;
    private JPanel topPanel;
    private JPanel bottomPanel;
    private JScrollPane htmlPaneScroller;
    private final String message;
    private final Throwable exception;
    private final Date shown = new Date();
    private final String anotherInfo;

    public JEditorPaneBasedExceptionDialog(Frame frame, boolean bl, Throwable throwable, InformationElement informationElement, String string) {
        super(frame, bl);
        this.initComponents();
        this.htmlErrorAndHelpPanel.setContentType("text/html");
        this.htmlErrorAndHelpPanel.setEditable(false);
        this.anotherInfo = string;
        List<String> list = JEditorPaneBasedExceptionDialog.infoElementToList(informationElement);
        this.message = JEditorPaneBasedExceptionDialog.getText(throwable, list, string, this.shown);
        this.exception = throwable;
        if (this.exception == null) {
            this.closeAndCopyButton.setVisible(false);
        }
        this.htmlErrorAndHelpPanel.setText(this.message);
        this.htmlErrorAndHelpPanel.setCaretPosition(0);
        try {
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/net/sourceforge/jnlp/resources/warning.png"));
            this.iconLabel.setIcon(imageIcon);
        }
        catch (Exception exception) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
        }
        this.htmlErrorAndHelpPanel.addHyperlinkListener(this);
        this.homeButton.setVisible(false);
        this.setDefaultCloseOperation(2);
    }

    static List<String> infoElementToList(InformationElement informationElement) {
        List<String> list = null;
        if (informationElement != null) {
            list = informationElement.getHeader();
            InfoItem infoItem = informationElement.getLongestDescriptionForSplash();
            if (infoItem != null) {
                list.add(infoItem.toNiceString());
            }
        }
        return list;
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.closeButton = new JButton();
        this.closeAndCopyButton = new JButton();
        this.mainPanel = new JPanel();
        this.exceptionLabel = new JLabel();
        this.iconLabel = new JLabel();
        this.bottomPanel = new JPanel();
        this.htmlPaneScroller = new JScrollPane();
        this.htmlErrorAndHelpPanel = new JEditorPane();
        this.homeButton = new JButton();
        this.aboutButton = new JButton();
        this.consoleButton = BasicExceptionDialog.getShowButton(this);
        this.setDefaultCloseOperation(2);
        this.closeButton.setText(Translator.R("SPLASHClose"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JEditorPaneBasedExceptionDialog.this.closeWindowButtonActionPerformed(actionEvent);
            }
        });
        this.closeAndCopyButton.setText(Translator.R("SPLASHclosewAndCopyException"));
        this.closeAndCopyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JEditorPaneBasedExceptionDialog.this.copyAndCloseButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.topPanel);
        this.topPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.closeButton).addContainerGap().addComponent(this.aboutButton).addContainerGap().addComponent(this.consoleButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 314, Short.MAX_VALUE).addComponent(this.closeAndCopyButton).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(24, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.aboutButton).addComponent(this.consoleButton).addComponent(this.closeAndCopyButton)).addContainerGap()));
        this.exceptionLabel.setFont(new Font("Dialog", 1, 18));
        this.exceptionLabel.setHorizontalAlignment(0);
        this.exceptionLabel.setText(Translator.R("SPLASHexOccured"));
        this.bottomPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.bottomPanel.setLayout(new BorderLayout());
        this.htmlPaneScroller.setViewportView(this.htmlErrorAndHelpPanel);
        this.bottomPanel.add((Component)this.htmlPaneScroller, "Center");
        this.homeButton.setText(Translator.R("SPLASHHome"));
        this.homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JEditorPaneBasedExceptionDialog.this.homeButtonActionPerformed(actionEvent);
            }
        });
        this.aboutButton.setText(Translator.R("AboutDialogueTabAbout"));
        this.aboutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    AboutDialog.display(true);
                }
                catch (Exception exception) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
                    JOptionPane.showConfirmDialog(JEditorPaneBasedExceptionDialog.this, exception);
                }
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.iconLabel, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.exceptionLabel, -1, 503, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.homeButton, -2, 101, -2).addContainerGap()).addComponent(this.bottomPanel, GroupLayout.Alignment.TRAILING, -1, 723, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iconLabel, -2, 70, -2).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exceptionLabel, -2, 70, -2).addComponent(this.homeButton, -2, 64, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bottomPanel, -1, 158, Short.MAX_VALUE)));
        GroupLayout groupLayout3 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.mainPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.topPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.mainPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.topPanel, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void copyAndCloseButtonActionPerformed(ActionEvent actionEvent) {
        if (this.exception != null) {
            try {
                StringSelection stringSelection = new StringSelection(this.anotherInfo + "\n" + this.shown.toString() + "\n" + JEditorPaneBasedExceptionDialog.getExceptionStackTraceAsString(this.exception) + JEditorPaneBasedExceptionDialog.addPlainChain());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, stringSelection);
            }
            catch (Exception exception) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
                JOptionPane.showMessageDialog(this, Translator.R("SPLASHcantCopyEx"));
            }
        } else {
            JOptionPane.showMessageDialog(this, Translator.R("SPLASHnoExRecorded"));
        }
        this.close();
    }

    private void homeButtonActionPerformed(ActionEvent actionEvent) {
        this.htmlErrorAndHelpPanel.setText(this.message);
        this.homeButton.setVisible(false);
    }

    private void closeWindowButtonActionPerformed(ActionEvent actionEvent) {
        this.close();
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RuntimeException runtimeException = new RuntimeException("dsgsfdg");
                JEditorPaneBasedExceptionDialog jEditorPaneBasedExceptionDialog = new JEditorPaneBasedExceptionDialog(new JFrame(), true, runtimeException, null, "uaaa: aaa\nwqdeweq:sdsds");
                jEditorPaneBasedExceptionDialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
                jEditorPaneBasedExceptionDialog.setVisible(true);
            }
        });
    }

    static String getText(Throwable throwable, List<String> list, String string, Date date) {
        StringBuilder stringBuilder = new StringBuilder("<html><body>");
        String string2 = "<p>" + Translator.R("SPLASHmainL1", JEditorPaneBasedExceptionDialog.createLink()) + " </p> \n" + "<p>" + Translator.R("SPLASHmainL2", JEditorPaneBasedExceptionDialog.createLink()) + " </p> \n";
        String string3 = "<p>" + Translator.R("SPLASHmainL3") + "</p> \n" + string2 + JEditorPaneBasedExceptionDialog.formatListInfoList(list) + JEditorPaneBasedExceptionDialog.formatInfo(string);
        String[] stringArray = new String[]{Translator.R("SPLASHClose"), Translator.R("SPLASHcloseAndCopyShorter")};
        string3 = throwable != null ? "<p>" + Translator.R("SPLASHmainL4") + " </p>\n" + string2 + JEditorPaneBasedExceptionDialog.formatListInfoList(list) + JEditorPaneBasedExceptionDialog.formatInfo(string) + "<br>" + DateFormat.getInstance().format(date) + "<br>" + "<p>" + Translator.R("SPLASHexWas") + " <br/>\n" + "<pre>" + JEditorPaneBasedExceptionDialog.getExceptionStackTraceAsString(throwable) + "</pre>" + JEditorPaneBasedExceptionDialog.addChain() : string3 + JEditorPaneBasedExceptionDialog.formatListInfoList(list);
        stringBuilder.append(string3);
        stringBuilder.append("</body></html>");
        return stringBuilder.toString();
    }

    public static String getExceptionStackTraceAsString(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        return OutputController.exceptionToString(throwable);
    }

    public static String[] getExceptionStackTraceAsStrings(Throwable throwable) {
        if (throwable == null) {
            return new String[0];
        }
        return OutputController.exceptionToString(throwable).split("\n");
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.htmlErrorAndHelpPanel.setPage(hyperlinkEvent.getURL());
                this.homeButton.setVisible(true);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, Translator.R("SPLASHcfl") + " " + hyperlinkEvent.getURL().toExternalForm() + ": " + exception);
            }
        }
    }

    private void close() {
        this.processWindowEvent(new WindowEvent(this, 201));
    }

    static String formatListInfoList(List<String> list) {
        if (list == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<p>");
        stringBuilder.append("<h3>").append(Translator.R("SPLASHvendorsInfo")).append(":</h3>");
        stringBuilder.append("<pre>");
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            stringBuilder.append(string).append("\n");
        }
        stringBuilder.append("</pre>");
        stringBuilder.append("</p>");
        return stringBuilder.toString();
    }

    static String formatInfo(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<p>");
        stringBuilder.append("<h3>").append(Translator.R("SPLASHanotherInfo")).append(": </h3>");
        stringBuilder.append("<pre>");
        stringBuilder.append(string);
        stringBuilder.append("</pre>");
        stringBuilder.append("</p>");
        return stringBuilder.toString();
    }

    Throwable getException() {
        return this.exception;
    }

    String getMessage() {
        return this.message;
    }

    private static String createLink() {
        return "<a href=\"" + Translator.R("SPLASHurl") + "\">" + Translator.R("SPLASHurlLooks") + "</a>";
    }

    private static String addChain() {
        if (LaunchException.getLaunchExceptionChain().isEmpty()) {
            return "";
        }
        return Translator.R("SPLASHchainWas") + " <br/>\n" + "<pre>" + JEditorPaneBasedExceptionDialog.getChainAsString(true) + "</pre>";
    }

    private static String addPlainChain() {
        if (LaunchException.getLaunchExceptionChain().isEmpty()) {
            return "";
        }
        return "\n Chain: \n" + JEditorPaneBasedExceptionDialog.getChainAsString(false);
    }

    private static String getChainAsString(boolean bl) {
        return JEditorPaneBasedExceptionDialog.getChainAsString(LaunchException.getLaunchExceptionChain(), bl);
    }

    private static String getChainAsString(List<LaunchException.LaunchExceptionWithStamp> list, boolean bl) {
        String string = "";
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                LaunchException.LaunchExceptionWithStamp launchExceptionWithStamp = list.get(i);
                string = string + (i + 1) + ") at " + JEditorPaneBasedExceptionDialog.formatTime(launchExceptionWithStamp.getStamp(), bl) + "\n" + JEditorPaneBasedExceptionDialog.getExceptionStackTraceAsString(launchExceptionWithStamp.getEx());
            }
        }
        return string;
    }

    private static String formatTime(Date date, boolean bl) {
        if (date == null) {
            return "unknown time";
        }
        if (bl) {
            return DateFormat.getInstance().format(date);
        }
        return date.toString();
    }
}

