/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.splashscreen;

import net.sourceforge.jnlp.runtime.AppletEnvironment;
import net.sourceforge.jnlp.runtime.AppletInstance;
import net.sourceforge.jnlp.runtime.Boot;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.splashscreen.SplashController;
import net.sourceforge.jnlp.splashscreen.SplashErrorPanel;
import net.sourceforge.jnlp.splashscreen.SplashPanel;
import net.sourceforge.jnlp.splashscreen.impls.DefaultErrorSplashScreen2012;
import net.sourceforge.jnlp.splashscreen.impls.DefaultSplashScreen2012;
import net.sourceforge.jnlp.splashscreen.parts.BasicComponentSplashScreen;
import net.sourceforge.jnlp.util.logging.OutputController;

public class SplashUtils {
    static final String ICEDTEA_WEB_PLUGIN_SPLASH = "ICEDTEA_WEB_PLUGIN_SPLASH";
    static final String ICEDTEA_WEB_SPLASH = "ICEDTEA_WEB_SPLASH";
    static final String NONE = "none";
    static final String DEFAULT = "default";

    public static void showErrorCaught(Throwable throwable, AppletInstance appletInstance) {
        try {
            SplashUtils.showError(throwable, appletInstance);
        }
        catch (Throwable throwable2) {
            OutputController.getLogger().log(throwable2);
        }
    }

    public static void showError(Throwable throwable, AppletInstance appletInstance) {
        if (appletInstance == null) {
            return;
        }
        AppletEnvironment appletEnvironment = appletInstance.getAppletEnvironment();
        SplashUtils.showError(throwable, appletEnvironment);
    }

    public static void showError(Throwable throwable, AppletEnvironment appletEnvironment) {
        if (appletEnvironment == null) {
            return;
        }
        SplashController splashController = appletEnvironment.getSplashControler();
        SplashUtils.showError(throwable, splashController);
    }

    public static void showError(Throwable throwable, SplashController splashController) {
        if (splashController == null) {
            return;
        }
        splashController.replaceSplash(SplashUtils.getErrorSplashScreen(splashController.getSplashWidth(), splashController.getSplashHeigth(), throwable));
    }

    private static SplashReason getReason() {
        if (JNLPRuntime.isWebstartApplication()) {
            return SplashReason.JAVAWS;
        }
        return SplashReason.APPLET;
    }

    public static SplashPanel getSplashScreen(int n, int n2) {
        return SplashUtils.getSplashScreen(n, n2, SplashUtils.getReason());
    }

    public static SplashErrorPanel getErrorSplashScreen(int n, int n2, Throwable throwable) {
        return SplashUtils.getErrorSplashScreen(n, n2, SplashUtils.getReason(), throwable);
    }

    static SplashPanel getSplashScreen(int n, int n2, SplashReason splashReason) {
        return SplashUtils.getSplashScreen(n, n2, splashReason, null, false);
    }

    static SplashErrorPanel getErrorSplashScreen(int n, int n2, SplashReason splashReason, Throwable throwable) {
        return (SplashErrorPanel)SplashUtils.getSplashScreen(n, n2, splashReason, throwable, true);
    }

    static SplashPanel getSplashScreen(int n, int n2, SplashReason splashReason, Throwable throwable, boolean bl) {
        String string = null;
        String string2 = null;
        try {
            string2 = System.getenv(ICEDTEA_WEB_PLUGIN_SPLASH);
            string = System.getenv(ICEDTEA_WEB_SPLASH);
        }
        catch (Exception exception) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
        }
        BasicComponentSplashScreen basicComponentSplashScreen = null;
        if (SplashReason.JAVAWS.equals((Object)splashReason)) {
            if (NONE.equals(string)) {
                return null;
            }
            if (DEFAULT.equals(string)) {
                basicComponentSplashScreen = bl ? new DefaultErrorSplashScreen2012(n, n2, splashReason, throwable) : new DefaultSplashScreen2012(n, n2, splashReason);
            }
        }
        if (SplashReason.APPLET.equals((Object)splashReason)) {
            if (NONE.equals(string2)) {
                return null;
            }
            if (DEFAULT.equals(string2)) {
                basicComponentSplashScreen = bl ? new DefaultErrorSplashScreen2012(n, n2, splashReason, throwable) : new DefaultSplashScreen2012(n, n2, splashReason);
            }
        }
        basicComponentSplashScreen = bl ? new DefaultErrorSplashScreen2012(n, n2, splashReason, throwable) : new DefaultSplashScreen2012(n, n2, splashReason);
        basicComponentSplashScreen.setVersion(Boot.version);
        return basicComponentSplashScreen;
    }

    public static enum SplashReason {
        APPLET,
        JAVAWS;


        public String toString() {
            switch (this) {
                case APPLET: {
                    return "IcedTea-Web Plugin";
                }
                case JAVAWS: {
                    return "IcedTea-Web";
                }
            }
            return "unknown";
        }
    }
}

