/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jnlp.SingleInstanceListener;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.services.ExtendedSingleInstanceService;
import net.sourceforge.jnlp.services.InstanceExistsException;
import net.sourceforge.jnlp.services.SingleInstanceLock;
import net.sourceforge.jnlp.util.logging.OutputController;

public class XSingleInstanceService
implements ExtendedSingleInstanceService {
    boolean initialized = false;
    List<SingleInstanceListener> listeners = new LinkedList<SingleInstanceListener>();

    protected XSingleInstanceService() {
    }

    @Override
    public void initializeSingleInstance() {
        JNLPFile jNLPFile = JNLPRuntime.getApplication().getJNLPFile();
        if (!this.initialized || jNLPFile instanceof PluginBridge) {
            this.checkSingleInstanceRunning(jNLPFile);
            this.initialized = true;
            SingleInstanceLock singleInstanceLock = new SingleInstanceLock(jNLPFile);
            if (!singleInstanceLock.isValid()) {
                this.startListeningServer(singleInstanceLock);
            }
        }
    }

    @Override
    public void checkSingleInstanceRunning(JNLPFile jNLPFile) {
        SingleInstanceLock singleInstanceLock = new SingleInstanceLock(jNLPFile);
        if (singleInstanceLock.isValid()) {
            int n = singleInstanceLock.getPort();
            OutputController.getLogger().log("Lock file is valid (port=" + n + "). Exiting.");
            String[] stringArray = null;
            if (jNLPFile.isApplet()) {
                Set<Map.Entry<String, String>> set = jNLPFile.getApplet().getParameters().entrySet();
                stringArray = new String[set.size() * 2];
                int n2 = 0;
                for (Map.Entry<String, String> entry : set) {
                    stringArray[n2] = entry.getKey();
                    stringArray[n2 + 1] = entry.getValue();
                    n2 += 2;
                }
            } else if (!jNLPFile.isInstaller()) {
                stringArray = jNLPFile.getApplication().getArguments();
            }
            try {
                this.sendProgramArgumentsToExistingApplication(n, stringArray);
                throw new InstanceExistsException(String.valueOf(n));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    private void startListeningServer(SingleInstanceLock singleInstanceLock) {
        SingleInstanceServer singleInstanceServer = new SingleInstanceServer(singleInstanceLock);
        Thread thread = new Thread(singleInstanceServer);
        thread.setDaemon(true);
        thread.start();
    }

    private void sendProgramArgumentsToExistingApplication(int n, String[] stringArray) throws IOException {
        try {
            Socket socket = new Socket((String)null, n);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
            objectOutputStream.writeObject(stringArray);
            objectOutputStream.close();
            socket.close();
        }
        catch (UnknownHostException unknownHostException) {
            OutputController.getLogger().log("Unable to find localhost");
            throw new RuntimeException(unknownHostException);
        }
    }

    private void notifySingleInstanceListeners(String[] stringArray) {
        for (SingleInstanceListener singleInstanceListener : this.listeners) {
            singleInstanceListener.newActivation(stringArray);
        }
    }

    @Override
    public void addSingleInstanceListener(SingleInstanceListener singleInstanceListener) {
        this.initializeSingleInstance();
        if (singleInstanceListener == null) {
            return;
        }
        this.listeners.add(singleInstanceListener);
    }

    @Override
    public void removeSingleInstanceListener(SingleInstanceListener singleInstanceListener) {
        this.initializeSingleInstance();
        if (singleInstanceListener == null) {
            return;
        }
        this.listeners.remove(singleInstanceListener);
    }

    class SingleInstanceServer
    implements Runnable {
        SingleInstanceLock lockFile = null;

        public SingleInstanceServer(SingleInstanceLock singleInstanceLock) {
            this.lockFile = singleInstanceLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ServerSocket serverSocket = null;
            try {
                try {
                    serverSocket = new ServerSocket(0);
                    this.lockFile.createWithPort(serverSocket.getLocalPort());
                    OutputController.getLogger().log("Starting SingleInstanceServer on port" + serverSocket);
                    while (true) {
                        try {
                            while (true) {
                                Socket socket = serverSocket.accept();
                                ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
                                String[] stringArray = (String[])objectInputStream.readObject();
                                XSingleInstanceService.this.notifySingleInstanceListeners(stringArray);
                            }
                        }
                        catch (Exception exception) {
                            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException);
                    if (serverSocket != null) {
                        try {
                            serverSocket.close();
                        }
                        catch (IOException iOException2) {
                            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException2);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (IOException iOException) {
                        OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException);
                    }
                }
                throw throwable;
            }
        }
    }
}

