/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.viewer;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.UIManager;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.viewer.CertificatePane;
import net.sourceforge.jnlp.util.ImageResources;
import net.sourceforge.jnlp.util.ScreenFinder;

public class CertificateViewer
extends JDialog {
    private boolean initialized = false;
    private static final String dialogTitle = Translator.R("CVCertificateViewer");
    CertificatePane panel;

    public CertificateViewer() {
        super((Frame)null, dialogTitle, true);
        this.setIconImages(ImageResources.INSTANCE.getApplicationImages());
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.panel = new CertificatePane(this);
        this.add(this.panel);
        this.pack();
        WindowAdapter windowAdapter = new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                if (!this.gotFocus) {
                    CertificateViewer.this.panel.focusOnDefaultButton();
                    this.gotFocus = true;
                }
            }
        };
        this.addWindowFocusListener(windowAdapter);
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void centerDialog() {
        ScreenFinder.centerWindowsToCurrentScreen(this);
    }

    public static void showCertificateViewer() throws Exception {
        JNLPRuntime.initialize(true);
        CertificateViewer.setSystemLookAndFeel();
        CertificateViewer certificateViewer = new CertificateViewer();
        certificateViewer.setResizable(true);
        certificateViewer.centerDialog();
        certificateViewer.setVisible(true);
        certificateViewer.dispose();
    }

    private static void setSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) throws Exception {
        CertificateViewer.showCertificateViewer();
    }
}

