/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.PropertiesFile;
import net.sourceforge.jnlp.util.logging.OutputController;

public class CacheEntry {
    private URL location;
    private Version version;
    private PropertiesFile properties;

    public CacheEntry(URL uRL, Version version) {
        this.location = uRL;
        this.version = version;
        File file = CacheUtil.getCacheFile(uRL, version);
        file = new File(file.getPath() + ".info");
        this.properties = new PropertiesFile(file, Translator.R("CAutoGen"));
    }

    void initialize(URLConnection uRLConnection) {
        long l = uRLConnection.getLastModified();
        long l2 = uRLConnection.getContentLength();
        this.properties.setProperty("content-length", Long.toString(l2));
        this.properties.setProperty("last-modified", Long.toString(l));
    }

    public URL getLocation() {
        return this.location;
    }

    public long getLastUpdated() {
        try {
            return Long.parseLong(this.properties.getProperty("last-updated"));
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public void setLastUpdated(long l) {
        this.properties.setProperty("last-updated", Long.toString(l));
    }

    public boolean isCurrent(URLConnection uRLConnection) {
        boolean bl = this.isCached();
        if (!bl) {
            return false;
        }
        try {
            long l = uRLConnection.getLastModified();
            long l2 = Long.parseLong(this.properties.getProperty("last-modified"));
            return l > 0L && l <= l2;
        }
        catch (Exception exception) {
            OutputController.getLogger().log(exception);
            return bl;
        }
    }

    public boolean isCached() {
        File file = CacheUtil.getCacheFile(this.location, this.version);
        if (!file.exists()) {
            return false;
        }
        try {
            long l = file.length();
            long l2 = Long.parseLong(this.properties.getProperty("content-length", "-1"));
            return l2 < 0L || l == l2;
        }
        catch (Exception exception) {
            OutputController.getLogger().log(exception);
            return false;
        }
    }

    protected void store() {
        this.properties.store();
    }

    public void markForDelete() {
        this.properties.setProperty("delete", Boolean.toString(true));
    }

    protected void lock() {
        CacheUtil.lockFile(this.properties);
    }

    protected void unlock() {
        CacheUtil.unlockFile(this.properties);
    }
}

