/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.net.URL;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import net.sourceforge.jnlp.PluginParameterException;
import net.sourceforge.jnlp.runtime.Translator;

public class PluginParameters {
    private final Hashtable<String, String> parameters;

    public PluginParameters(Map<String, String> map) {
        this.parameters = PluginParameters.createParameterTable(map);
        if (this.parameters.get("code") == null && this.parameters.get("object") == null && this.parameters.get("jnlp_href") == null) {
            throw new PluginParameterException(Translator.R("BNoCodeOrObjectApplet"));
        }
    }

    public String get(String string) {
        return this.parameters.get(string);
    }

    public void put(String string, String string2) {
        this.parameters.put(string.toLowerCase(), string2);
    }

    public Map<String, String> getUnmodifiableMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    Hashtable<String, String> getUnderlyingHashtable() {
        return this.parameters;
    }

    public String getDefaulted(String string, String string2) {
        String string3 = this.get(string);
        return string3 != null ? string3 : string2;
    }

    public String getAppletTitle() {
        String string = this.get("name");
        if (string == null) {
            return "Applet";
        }
        return string + " applet";
    }

    public boolean useCodebaseLookup() {
        return Boolean.valueOf(this.getDefaulted("codebase_lookup", "true"));
    }

    public String getArchive() {
        return this.getDefaulted("archive", "");
    }

    public String getJavaArchive() {
        return this.getDefaulted("java_archive", "");
    }

    public String getJavaArguments() {
        return this.getDefaulted("java_arguments", "");
    }

    public String getCacheArchive() {
        return this.getDefaulted("cache_archive", "");
    }

    public String getCacheArchiveEx() {
        return this.getDefaulted("cache_archive_ex", "");
    }

    public String getCacheOption() {
        return this.getDefaulted("cache_option", "");
    }

    public String getCacheVersion() {
        return this.getDefaulted("cache_version", "");
    }

    public String getCode() {
        return this.getDefaulted("code", "");
    }

    public String getJNLPHref() {
        return this.get("jnlp_href");
    }

    public String getJNLPEmbedded() {
        return this.get("jnlp_embedded");
    }

    public String getJarFiles() {
        return this.getDefaulted("archive", "");
    }

    public int getWidth() {
        String string = this.getDefaulted("width", "0");
        return Integer.valueOf(string);
    }

    public int getHeight() {
        String string = this.getDefaulted("height", "0");
        return Integer.valueOf(string);
    }

    public void updateSize(int n, int n2) {
        this.parameters.put("width", Integer.toString(n));
        this.parameters.put("height", Integer.toString(n2));
    }

    public String getUniqueKey(URL uRL) {
        return "codebase=" + uRL.toExternalForm() + "cache_archive=" + this.getCacheArchive() + "java_archive=" + this.getJavaArchive() + "archive=" + this.getArchive();
    }

    static void ensureJavaPrefixTakesPrecedence(Map<String, String> map, String string) {
        String string2 = map.get("java_" + string);
        if (string2 != null) {
            map.put(string, string2);
        }
    }

    static Hashtable<String, String> createParameterTable(Map<String, String> map) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (Map.Entry<String, String> object2 : map.entrySet()) {
            String string = object2.getKey().toLowerCase();
            String string2 = object2.getValue();
            hashtable.put(string, string2);
        }
        Object object3 = (String)hashtable.get("code");
        String string = (String)hashtable.get("classid");
        if (object3 == null && string != null && !string.startsWith("clsid:")) {
            object3 = string;
            hashtable.put("code", (String)object3);
        }
        if (object3 != null && ((String)object3).startsWith("java:")) {
            object3 = ((String)object3).substring("java:".length());
            hashtable.put("code", (String)object3);
        }
        PluginParameters.ensureJavaPrefixTakesPrecedence(hashtable, "code");
        PluginParameters.ensureJavaPrefixTakesPrecedence(hashtable, "codebase");
        PluginParameters.ensureJavaPrefixTakesPrecedence(hashtable, "archive");
        PluginParameters.ensureJavaPrefixTakesPrecedence(hashtable, "object");
        PluginParameters.ensureJavaPrefixTakesPrecedence(hashtable, "type");
        return hashtable;
    }

    public String toString() {
        return this.parameters.toString();
    }
}

