/* Copyright (c) 1990 by Carrick Sean Casey. */
/* For copying and distribution information, see the file COPYING. */

/* In the future, this file will include everything a user needs to */
/* know about the client-server protocol */

/* macros */

/* this gets used a lot */
#define setlen (*pp = (unsigned char) (strlen(pbuf) + 1))

/* limits */

#define MAX_FIELDS	20	/* fields in a packet */
#define MAX_GROUPLEN	8	/* chars in a group name */
#define MAX_GROUPUSERS	25	/* people in the same group */
#define MAX_IDLEN	12	/* chars in a login id */
#define MAX_INPUTSTR	(250 - MAX_NICKLEN - MAX_NICKLEN - 6) /* input line */
#define MAX_INVITES	10	/* invitations in a group */
#define MAX_NICKLEN	12	/* chars in a username */
#define MAX_NODELEN	64	/* chars in a node name */
#define MAX_NOPONG	600	/* seconds a client may not PONG a PING */
#define MAX_PASSWDLEN	12	/* chars in a user password */
#define MAX_REALLEN	64	/* chars in a real life name */
#define MAX_TEXTLEN	(80 - MAX_NICKLEN - 5) 	/* max chars in a message */
#define MAX_TOPICLEN	32	/* chars in a group topic */
#define MAX_IDLE	3600	/* maximum idle seconds before disconnect */

#define IDLE_POLLWAIT	30000	/* polltimeout (msecs) when users = 0 */
#define BUSY_POLLWAIT	10000	/* polltimeout (msecs) when users >= 1 */
#define POLL_DELAY	1000	/* min wait through each poll */

/* message types */
/* note: changing these necessitates upgrading the protocol number */

#define ICB_LOGIN	'a'	/* login packet */
#define ICB_LOGINOK	'a'	/* login packet */
#define ICB_OPEN	'b'	/* open msg to group */
#define ICB_PERSONAL	'c'	/* personal msg */
#define ICB_STATUS	'd'	/* status update message */
#define ICB_ERROR	'e'	/* error message */
#define ICB_IMPORTANT	'f'	/* special important announcement */
#define ICB_EXIT	'g'	/* tell other side to exit */
#define ICB_COMMAND	'h'	/* send a command from user */
#define ICB_CMDOUT	'i'	/* output from a command */
#define ICB_PROTO	'j'	/* protocol version information */
#define ICB_BEEP	'k'	/* beeps */
#define ICB_PING	'l'	/* ping packet */
#define ICB_PONG	'm'	/* return for ping packet */
