<?xml version='1.0'?>
<!DOCTYPE xsl:stylesheet
  PUBLIC "-//NetBSD//DTD NetBSD XSLT 1.0 DTD//EN"
         "http://www.NetBSD.org/XML/htdocs/share/xml/xslt10-netbsd.dtd">

<!-- $NetBSD: netbsd-docbook-html-chunk.xsl,v 1.19 2023/06/11 19:45:57 andvar Exp $ -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version='1.0'
                xmlns:html="http://www.w3.org/1999/xhtml"
		xmlns:suwl="http://nwalsh.com/xslt/ext/com.nwalsh.saxon.UnwrapLinks"
		xmlns:exsl="http://exslt.org/common"
                exclude-result-prefixes="html suwl exsl">

  <!-- Pull in the base stylesheets -->
  <xsl:import href="http://docbook.sourceforge.net/release/xsl/current/html/chunk.xsl" />

  <xsl:param name="VERSION" select="'X.X.X'" />

  <xsl:param name="chunker.output.doctype-public"
      select="'-//W3C//DTD HTML 4.01 Transitional//EN'"/>

  <xsl:param name="chunker.output.doctype-system"
      select="'http://www.w3.org/TR/html4/loose.dtd'"/>

  <xsl:include href="citerefentry-docbook-html.xsl"/>

  <xsl:template match="hostid">
    <xsl:call-template name="inline.monoseq" />
  </xsl:template>

  <xsl:template match="devicename">
    <xsl:call-template name="inline.monoseq" />
  </xsl:template>

  <xsl:template match="username">
    <xsl:call-template name="inline.monoseq" />
  </xsl:template>

  <xsl:template match="maketarget">
    <xsl:call-template name="inline.monoseq" />
  </xsl:template>

  <xsl:template match="makevar">
    <xsl:call-template name="inline.monoseq" />
  </xsl:template>

  <xsl:template match="processing-instruction('sdataEntity')">
    <xsl:text disable-output-escaping="yes">&amp;</xsl:text>
    <xsl:value-of select="substring-before(.,' [')" />
    <xsl:text>;</xsl:text>
  </xsl:template>

  <xsl:template name="l10n.pubdate.label">
    <xsl:text>Published: </xsl:text>
  </xsl:template>

  <xsl:template match="pubdate" mode="book.titlepage.recto.auto.mode">
    <div xsl:use-attribute-sets="book.titlepage.recto.style">
      <xsl:if test="@role = 'cvstag'">
        <xsl:variable name="tmp1" select="substring-after(., ' ')" />
        <xsl:variable name="tmp2" select="substring-after($tmp1, ' ')" />
        <xsl:variable name="tmp3" select="substring-after($tmp2, ' ')" />
        <xsl:variable name="date" select="substring-before($tmp3, ' ')" />
        <xsl:variable name="tmp4" select="substring-after($tmp3, ' ')" />
        <xsl:variable name="time" select="substring-before($tmp4, ' ')" />
        <xsl:call-template name="paragraph">
          <xsl:with-param name="class" select="name(.)"/>
          <xsl:with-param name="content">
            <xsl:call-template name="l10n.pubdate.label" />
            <xsl:value-of select="concat($date, ' ', $time)" />
          </xsl:with-param>
        </xsl:call-template>
      </xsl:if>
      <xsl:apply-templates select="." mode="book.titlepage.recto.mode"/>
    </div>
  </xsl:template>

  <xsl:template match="filename">
    <xsl:variable name="filename.label" select="." />

    <xsl:variable name="ulink.url">
      <xsl:choose>
        <xsl:when test="@role = 'cvsweb'">
          <xsl:value-of select="concat('&url.cvsweb;', '/')" />
          <xsl:if test="@path">
            <xsl:value-of select="concat(@path, '/')" />
          </xsl:if>
          <xsl:value-of select="concat('', $filename.label)" />
          <xsl:choose>
            <xsl:when test="@revision != ''">
              <xsl:value-of select="concat('?', 'rev=', @revision)" />
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="concat('?', 'rev=', 'HEAD')" />
            </xsl:otherwise>
          </xsl:choose>
          <xsl:value-of select="concat('&amp;', 'content-type=text/x-cvsweb-markup')" />
        </xsl:when>
        <xsl:when test="@role = 'pkg'">
          <xsl:value-of select="concat('&url.pkg;', '/')" />
          <xsl:value-of select="concat(normalize-space(.),
                                       '/&url.pkg.readme;')" />
        </xsl:when>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="link">
      <xsl:choose>
        <xsl:when test="@role = 'cvsweb' or @role = 'pkg'">
          <a>
            <xsl:if test="@id">
              <xsl:attribute name="name">
                <xsl:value-of select="@id"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:attribute name="href"><xsl:value-of select="$ulink.url"/></xsl:attribute>
            <xsl:if test="$ulink.target != ''">
              <xsl:attribute name="target">
                <xsl:value-of select="$ulink.target"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:call-template name="inline.monoseq" />
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="inline.monoseq" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:choose>
      <xsl:when test="function-available('suwl:unwrapLinks')">
        <xsl:copy-of select="suwl:unwrapLinks($link)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy-of select="$link"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
