#!/usr/bin/env perl
#
# $NetBSD: man-refs.pl,v 1.3 2010/03/07 19:25:47 dsieger Exp $
#
# Adapted from:
# $FreeBSD: /repoman/r/dcvs/doc/share/sgml/man-refs.pl,v 1.1 2002/06/07 13:16:50 des Exp $
#
# XXX: Don't use this script to overwrite current man-refs.ent.
#
# usage:
#	find /usr/{share,X11R6,X11R7}/man -type f -print \
#	| man-refs.pl \
#	> man-refs.ent

use strict;
use warnings;
use POSIX;

my @list = POSIX::uname();
my $arch = pop(@list);
my $version = $list[@list-2];

while (<>) {
	next unless (m,^(.*/)?([\w\._-]+)\.(\d\w*)(\.gz)?$,);
	my ($entity, $page, $volume) = ($2, $2, $3);
	$entity =~ y/_/./;
	print "<!ENTITY man.$entity.$volume.$arch.$version \"<citerefentry os=&#34;$version&#34; arch=&#34;$arch&#34;>";
	print "<refentrytitle>$page</refentrytitle>";
	print "<manvolnum>$volume</manvolnum></citerefentry>\">\n";
}
