/*
 * Copyright (c) 2005 Jacob Meuser <jakemsr@jakemsr.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * $Id: bsdav_utils.c,v 1.3 2006/03/24 10:22:44 jakemsr Exp $
 */

#include "includes.h"

#include <err.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "bsdav.h"


int
bsdav_write_pid(char *filename)
{
char 	*string;
int	 pid_fd;
size_t	 slen = 32;

	if ((string = malloc(slen)) == NULL) {
		warn("pid string, size = %lu", (unsigned long)slen);
		return(1);
	}

	if (snprintf(string, slen, "%d\n", getpid()) >= slen) {
		warnx("truncated pid string");
		free(string);
		return(1);
	}

	slen = strlen(string);

	pid_fd = open(filename, O_WRONLY | O_CREAT | O_TRUNC, 0644);
	if (pid_fd < 0) {
		warn("%s", filename);
		free(string);
		return(1);
	}

	if (write(pid_fd, string, slen) < 0) {
		warnx("pid file, size = %lu", (unsigned long)slen);
		close(pid_fd);
		free(string);
		return(1);
	}

	close(pid_fd);
	free(string);

	return(0);
}
