/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.SharedDictBase;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.util.Native;

public class ZstdDictCompress
extends SharedDictBase {
    private long nativePtr = 0L;
    private int level = Zstd.defaultCompressionLevel();

    private native void init(byte[] var1, int var2, int var3, int var4);

    private native void free();

    public ZstdDictCompress(byte[] dict, int level) {
        this(dict, 0, dict.length, level);
    }

    public ZstdDictCompress(byte[] dict, int offset, int length, int level) {
        this.level = level;
        if (dict.length - offset < 0) {
            throw new IllegalArgumentException("Dictionary buffer is to short");
        }
        this.init(dict, offset, length, level);
        if (0L == this.nativePtr) {
            throw new IllegalStateException("ZSTD_createCDict failed");
        }
        this.storeFence();
    }

    int level() {
        return this.level;
    }

    @Override
    void doClose() {
        if (this.nativePtr != 0L) {
            this.free();
            this.nativePtr = 0L;
        }
    }

    static {
        Native.load();
    }
}

