/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.lookup;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.turbine.binder.lookup.CanonicalSymbolResolver;
import com.google.turbine.binder.lookup.ImportScope;
import com.google.turbine.binder.lookup.LookupKey;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.lookup.PackageScope;
import com.google.turbine.binder.lookup.TopLevelIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.tree.Tree;
import org.jspecify.nullness.Nullable;

public class WildImportIndex
implements ImportScope {
    private final ImmutableList<Supplier<ImportScope>> packages;

    public WildImportIndex(ImmutableList<Supplier<ImportScope>> packages) {
        this.packages = packages;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static WildImportIndex create(final CanonicalSymbolResolver importResolver, final TopLevelIndex cpi, ImmutableList<Tree.ImportDecl> imports) {
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable ImmutableList.Builder packageScopes = ImmutableList.builder();
        for (final Tree.ImportDecl i : imports) {
            if (!i.wild()) continue;
            packageScopes.add((Object)Suppliers.memoize((Supplier)new Supplier<ImportScope>(){

                public @Nullable ImportScope get() {
                    if (i.stat()) {
                        return WildImportIndex.staticOnDemandImport(cpi, i, importResolver);
                    }
                    return WildImportIndex.onDemandImport(cpi, i, importResolver);
                }
            }));
        }
        return new WildImportIndex((ImmutableList<Supplier<ImportScope>>)packageScopes.build());
    }

    private static @Nullable ImportScope onDemandImport(TopLevelIndex cpi, Tree.ImportDecl i, final CanonicalSymbolResolver importResolver) {
        ImmutableList.Builder flatNames = ImmutableList.builder();
        for (Tree.Ident ident : i.type()) {
            flatNames.add((Object)ident.value());
        }
        final PackageScope packageIndex = cpi.lookupPackage((Iterable<String>)flatNames.build());
        if (packageIndex != null) {
            return new ImportScope(){

                @Override
                public @Nullable LookupResult lookup(LookupKey lookupKey, ImportScope.ResolveFunction resolve) {
                    return packageIndex.lookup(lookupKey);
                }
            };
        }
        LookupResult result = cpi.scope().lookup(new LookupKey(i.type()));
        if (result == null) {
            return null;
        }
        final ClassSymbol member = WildImportIndex.resolveImportBase(result, importResolver, importResolver);
        if (member == null) {
            return null;
        }
        return new ImportScope(){

            @Override
            public @Nullable LookupResult lookup(LookupKey lookupKey, ImportScope.ResolveFunction unused) {
                return WildImportIndex.resolveMember(member, importResolver, importResolver, lookupKey);
            }
        };
    }

    private static @Nullable ImportScope staticOnDemandImport(TopLevelIndex cpi, Tree.ImportDecl i, final CanonicalSymbolResolver importResolver) {
        final LookupResult result = cpi.scope().lookup(new LookupKey(i.type()));
        if (result == null) {
            return null;
        }
        return new ImportScope(){

            @Override
            public @Nullable LookupResult lookup(LookupKey lookupKey, ImportScope.ResolveFunction resolve) {
                ClassSymbol member = WildImportIndex.resolveImportBase(result, resolve, importResolver);
                if (member == null) {
                    return null;
                }
                return WildImportIndex.resolveMember(member, resolve, importResolver, lookupKey);
            }
        };
    }

    private static @Nullable LookupResult resolveMember(ClassSymbol base, ImportScope.ResolveFunction resolve, CanonicalSymbolResolver importResolver, LookupKey lookupKey) {
        ClassSymbol member = resolve.resolveOne(base, lookupKey.first());
        if (member == null) {
            return null;
        }
        if (!importResolver.visible(member)) {
            return null;
        }
        return new LookupResult(member, lookupKey);
    }

    static @Nullable ClassSymbol resolveImportBase(LookupResult result, ImportScope.ResolveFunction resolve, CanonicalSymbolResolver importResolver) {
        ClassSymbol member = (ClassSymbol)result.sym();
        for (Tree.Ident bit : result.remaining()) {
            if ((member = resolve.resolveOne(member, bit)) == null) {
                return null;
            }
            if (importResolver.visible(member)) continue;
            return null;
        }
        return member;
    }

    @Override
    public @Nullable LookupResult lookup(LookupKey lookup, ImportScope.ResolveFunction resolve) {
        for (Supplier packageScope : this.packages) {
            LookupResult result;
            ImportScope scope = (ImportScope)packageScope.get();
            if (scope == null || (result = scope.lookup(lookup, resolve)) == null) continue;
            return result;
        }
        return null;
    }
}

